	
#There is no builtin solution in OpenCV to perform histogram stretching, but you can do it easily in a loop.

#imadjust allows to select a tolerance for upper and lower bounds, or the bounds directly, so you need a little more logic than a simple for loop.

#You can use the example below as a reference while implementing your own:

#include <opencv2\opencv.hpp>
#include <vector>
#include <algorithm>

#using namespace std;
#using namespace cv;

src=cvLoadImage("src.png",0);
#void imadjust(const Mat1b& src, Mat1b& dst, int tol = 1, Vec2i in = Vec2i(0, 255), Vec2i out = Vec2i(0, 255))
{
    # src : input CV_8UC1 image
    # dst : output CV_8UC1 imge
    # tol : tolerance, from 0 to 100.
    # in  : src image bounds
    # out : dst image buonds

    int tol = 1
    dst = src.clone();

    tol = max(0, min(100, tol));

    if (tol > 0)
    {
        # Compute in and out limits

        # Histogram
        vector<int> hist(256, 0);
        for (int r = 0; r < src.rows; ++r) {
            for (int c = 0; c < src.cols; ++c) {
                hist[src(r,c)]++;
            }
        }

        # Cumulative histogram
        vector<int> cum = hist;
        for (int i = 1; i < hist.size(); ++i) {
            cum[i] = cum[i - 1] + hist[i];
        }

        # Compute bounds
        int total = src.rows * src.cols;
        int low_bound = total * tol / 100;
        int upp_bound = total * (100-tol) / 100;
        in[0] = distance(cum.begin(), lower_bound(cum.begin(), cum.end(), low_bound));
        in[1] = distance(cum.begin(), lower_bound(cum.begin(), cum.end(), upp_bound));

    }

    # Stretching
    float scale = float(out[1] - out[0]) / float(in[1] - in[0]);
    for (int r = 0; r < dst.rows; ++r)
    {
        for (int c = 0; c < dst.cols; ++c)
        {
            int vs = max(src(r, c) - in[0], 0);
            int vd = min(int(vs * scale + 0.5f) + out[0], out[1]);
            dst(r, c) = saturate_cast<uchar>(vd);
        }
    }
}

int main()
{
    Mat3b img = imread("path_to_image");

    Mat1b gray;
    cvtColor(img, gray, COLOR_RGB2GRAY);

    Mat1b adjusted;
    imadjust(gray, adjusted);

    # int low_in, high_in, low_out, high_out
    # imadjust(gray, adjusted, 0, Vec2i(low_in, high_in), Vec2i(low_out, high_out));

    return 0;
}

