    
function [dirlist,dirlist2] = uploaddirs_ARM3(dirall,dirlistall,starthr,endhr)
%UPLOAD Uploads directory names of the MASC fallspeed and image filenames to be processed
%   dirlist = uploaddirs(dirlistall,starthr,endhr) where inputs are specified in label_params 
%   dirall is the main directory, dirlistall lists all directories in the main directory, and starthr and endhr are in
%   the format [yyyy mm dd hh].
%
%   Copyright Tim Garrett, University of Utah. This code is freely available for
%   non-commercial distribution and modification

% updated by Kyle Fitch for uploading directories of co-located ARM data

%dirall=ARM_data_loc;dirlistall=file_names;starthr=masc_datetime(1,1:4);endhr=masc_datetime(end,1:4);


%%% The following parses the names of the directories for timestamp content    
for i = 1:length(dirlistall)
    temp = cell2mat(dirlistall(i));

% Add to the following list as need be if getting an error in loaddata.m
%%omit '.' and '..', '.mat' .ps .pdf .zip etc.
    if strcmp(temp(1),'.') == 1 || ...
       ~contains(temp,'.mat') ~= 1 || ...
       ~contains(temp,'.ps') ~= 1 || ...
       ~contains(temp,'.pdf') ~= 1 ||...
       ~contains(temp,'.zip') ~= 1
       continue
    end
    r = regexp(temp, '\.', 'split' );
%     m = regexp( r{1}, '\.','split' );
%     d = regexp( r{2}, '\.','split' );
%     t = regexp( r{4}, '\.','split' );
    
    diryr = str2double(r{3}(1:4));
    dirmonth = str2double(r{3}(5:6));
    dirday = str2double(r{3}(7:8));
%     dirhr = str2num(t{1});
    
    dirtime(i) = datenum([diryr dirmonth dirday 0 0 0]);
    
    
end

    %use only directories between starthr and endhr
    good = dirtime >= datenum([starthr 0 0]) & dirtime < datenum([endhr 0 0]);
    
    dirlist = strcat(dirall,'/',dirlistall(good),'/');
    dirlist2 = dirlistall(good);
    
    if isempty(dirlist2) && datenum(starthr(1:3))==datenum(endhr(1:3))
        good = dirtime == datenum([starthr(1:3) 0 0 0]);
        dirlist = strcat(dirall,'/',dirlistall(good),'/');
        dirlist2 = dirlistall(good);
    end
