    
function dirlist = uploaddirs(dirall,dirlistall,starthr,endhr)
%UPLOAD Uploads directory names of the MASC fallspeed and image filenames to be processed
%   dirlist = uploaddirs(dirlistall,starthr,endhr) where inputs are specified in label_params 
%   dirall is the main directory, dirlistall lists all directories in the main directory, and starthr and endhr are in
%   the format [yyyy mm dd hh].
%
%   Copyright Tim Garrett, University of Utah. This code is freely available for
%   non-commercial distribution and modification


%%% The following parses the names of the directories for timestamp content    
for i = 1:length(dirlistall)
    temp = cell2mat(dirlistall(i));

% Add to the following list as need be if getting an error in loaddata.m
%%omit '.' and '..', '.mat' .ps .pdf .zip etc.
    if strcmp(temp(1),'.') == 1 || ...
       ~contains(temp,'.mat') ~= 1 || ...
       ~contains(temp,'.ps') ~= 1 || ...
       ~contains(temp,'.pdf') ~= 1 ||...
       ~contains(temp,'.csv') ~= 1 ||...
       ~contains(temp,'.zip') ~= 1 ||...
       ~contains(temp,'class_results') ~= 1 ||...
       ~contains(temp,'fix') ~= 1 ||...
       ~contains(temp,'to_classify') ~= 1 
       continue
    end
    r = regexp(temp, '_', 'split' );
    m = regexp( r{1}, '\.','split' );
    d = regexp( r{2}, '\.','split' );
    t = regexp( r{4}, '\.','split' );
    
    dirMASC = str2num(m{1});
    diryr = str2num(d{1});
    dirmonth = str2num(d{2});
    dirday = str2num(d{3});
    dirhr = str2num(t{1});
    
    dirtime(i) = datenum([diryr dirmonth dirday dirhr 0 0]);
    
    
end

    %use only directories between starthr and endhr
    good = find(dirtime >= datenum([starthr 0 0]) & dirtime <= datenum([endhr 0 0]));
    dirlist = strcat(dirall,'/',dirlistall(good),'/');
