pro retrieve_nd_fad_re_from_zmax_ext_eta_ztop_nofad_test3, sfc_temp,sfc_press, base_height,temperature, pressure,height, $
dbz, uncert_dbz, ext, uncert_ext, zmax, uncert_zmax, lwp, uncert_lwp, dh, uncert_dh, eta, uncert_eta, alpha, uncert_alpha, $
fad_input, uncert_fad, nd, uncert_nd, nd_info, re_top, uncert_re_top, re_top_info, y, fx, info_content, sx, sy, kx, kb, sb, x_final,num_ret_param, $
info_vector,S_info,num_ind_obs,m_test, i, fx_vector_uncertainty,ccn_med,ccn_sdv,re_prior, re_prior_sdv

;;;;; in this version fad is removed from the state vector and used as an assumption in kb, sb

; OE algorithm to retreive Nd and Fad from zmax, extinction, eta
; Units:  Assuming meters, grams, kelvins for all calculations.  LWP in g/m2
; sfc_temp kelvins
; sfc_press pascals
; base_height is cloud base height in meters
; temperature is in kelvins and is cloud temperature
; pressure is in pascals and is cloud pressure
; zmax - is the distance in meters to the maximum in attenuated backscatter a laser penetrates into a cloud layer
; uncer_zmax - fractional uncertainty in zmax
; ext - is the extinction in inverse m derived from the Li et al., 2011 method
; uncert_ext - is the fractional uncertainty in extinction
; lwp - is the liquid water path in grams per square meter
; uncert_lwp - is the fractional uncertainty in lwp
; dh - is the layer thickness in meters
; uncert_dh is the fractional uncertainty in dh
; eta - is the multiple scattering factor (unitless)
; uncert_eta - is the frational uncertainty in eta
; nd is the retrieved number concentration in inverse cubic centimeters
; uncer_nd is the fractional uncertainty in Nd
; fad is the adiabaticity of the layer (unitless)
; uncert_fad is the uncertainty in adiabaticity
; info is the shannon informaiton content matrix
; sx is the state parameter covariance matrix - unitless
; sy is the observational convariance matrix - unitless
; kx is the first order derivatives of the observables wrt the retreived quantities, unitless
; kb is the first order derivatives of the observables wrt the assumptions
; sb is the covariance matrix of the assumptions
; x_final is the retreived state parameter vector
; y is the observables vector used in the inversion


; written by Jay Mace.  May 2023.  in Hobart Tas.

;Revised by adding input of radar dbz at layer top with uncertainty and outputting effective radius and uncertainty

; preliminaries.  Get the prior information and the kx information.  Check first to see if the information is in the common blocks already.

Rd=287.04d
Rv=461.5d
Lv=2.25d6
g=9.81d  ; m/s2
cp=1003.5 ; j/kg/k   approximate between 250K and 300 K
epsilon=Rd/Rv
rho_liquid=1.e6 ; g/m3

; convert input dbz to z_top
z_top=(10.^(dbz/10.))*1.e-18  ; converts mm^6/m^3 to m^3

z_top_p=(10.^((dbz+uncert_dbz)/10.))*1.e-18 
z_top_m=(10.^((dbz-uncert_dbz)/10.))*1.e-18
uncert_z=(z_top_p-z_top_m)/z_top

temp=temperature
press=pressure

common cold_cloud_prior_data, Exy_cc,Exy_pp,Exy_pc,dz_w_dt_accret,dVd_w_dt_accret,dz_ka_dt_accret,dVd_ka_dt_accret,dz_ku_dt_accret,dVd_ku_dt_accret,dz_x_dt_accret,dVd_x_dt_accret,Lx_s, $
  Nx_s,alpha_s,Lx_l,Nx_l,alpha_l,am_s,bm_s,aa_s,ba_s,am_l,bm_l,aa_l,ba_l,mass_precip,re_precip,ext_precip,Nd_precip,precip_rate_precip,mass_cloud,re_cloud,ext_cloud,Nd_cloud, $
  precip_rate_cloud,dbz_w,vd_convol_w,sigma_convol_w,ext_coef_w,atten_dbpkm_w_cloud,ext_coef_w_precip,atten_dbpkm_w_precip,dbz_convol_Ka,vd_convol_Ka,sigma_convol_Ka, $
  ext_coef_Ka_cloud,atten_dbpkm_Ka_cloud,ext_coef_Ka_precip,atten_dbpkm_Ka,dbz_convol_Ku,vd_convol_Ku,sigma_convol_Ku,ext_coef_Ku_cloud,atten_dbpkm_Ku_cloud,ext_coef_Ku_precip, $
  atten_dbpkm_Ku_precip,dbz_convol_X,vd_convol_X,sigma_convol_X,ext_coef_X_cloud,atten_dbpkm_X_cloud,ext_coef_X_precip,atten_dbpkm_X_precip,accretion,aggregation, $
  kk_autocon,kk_accret,j_vec,index_end,altitude,lat,lon,temp_prior,press_prior,time,rh,lwc,w,phase_flag,type,dbz_ku_test_cloud,dbz_ku_test_precip

common kx_nd_zm_ext_table, nd_vec, fad_vec, alpha_vec, dh_vec, zmax_table, tau_at_extinction_table, ext_table, nd_eta_zm_table_table, offset_eta_table, eta_vec

  if n_elements(Nx_s) eq 0. then begin
  prior_paths='/Users/u0029340/Documents/data/Socrates/'
  prior_file_prefixes='SOCRATES_PSD_Anal_Process_201904_'
  get_cold_prior_reduced, prior_paths, prior_file_prefixes
  endif
  
  if n_elements(eta_vec) eq 0 then begin
  kx_path='/Users/u0029340/Documents/idl_code/Capricorn_SO/lookup_tables/nd_fad_oe_kx/'
  file='nd_oe_kx_sensitivity2.cdf'
  cdfid=ncdf_open(kx_path+file)
  x_id=ncdf_varid(cdfid, 'nd') & ncdf_varget, cdfid, x_id, nd_vec
  x_id=ncdf_varid(cdfid, 'fad') & ncdf_varget, cdfid, x_id, fad_vec
  x_id=ncdf_varid(cdfid, 'alpha') & ncdf_varget, cdfid, x_id, alpha_vec
  x_id=ncdf_varid(cdfid, 'dh') & ncdf_varget, cdfid, x_id, dh_vec
  x_id=ncdf_varid(cdfid, 'eta') & ncdf_varget, cdfid, x_id, eta_vec
  x_id=ncdf_varid(cdfid, 'zmax') & ncdf_varget, cdfid, x_id, zmax_table
  x_id=ncdf_varid(cdfid, 'tau_at_extinction') & ncdf_varget, cdfid, x_id, tau_at_extinction_table
  x_id=ncdf_varid(cdfid, 'extinction') & ncdf_varget, cdfid, x_id, ext_table
  x_id=ncdf_varid(cdfid, 'nd_eta_zm') & ncdf_varget, cdfid, x_id, nd_eta_zm_table
  x_id=ncdf_varid(cdfid, 'offset_eta') & ncdf_varget, cdfid, x_id, offset_eta_table
  ncdf_close, cdfid
  endif
  
  ; initialze the computatinal arrays
  ny=4   ; zmax, ext, lwp, dbz
  nx=2    ; nd, re
  nass=3 ;alpha, fad, eta
  kx=fltarr(ny,nx) ; sensitivity of measurements to retrieved quantities.
  kb=fltarr(ny,nass)  ; sensitivity of measurements to assumptions
  sa=fltarr(nx,nx)  ; covariance matrix of retrieved quantities (here only precip rate)
  sb=fltarr(nass,nass)  ; covariance of assumptions - here am and bm
  s_eps=fltarr(ny,ny) ; this contains the measurement noise or observational error covariance
  s_y=fltarr(ny, ny) ; this contains the true measurement covariance including the noise and the forward model error
  s_x=fltarr(nx,nx) ; this contains the retrieval error covaraince or just the variance in precip rate for this example.
  info_content=fltarr(nx,nx)
  y=fltarr(ny)
  x=fltarr(nx)
  xa=fltarr(nx)
  fx=fltarr(ny)
  
        base_height_index=where(abs(base_height-height) eq min(abs(base_height-height))) & base_height_index=base_height_index[0]
  
        gamma_m=double(moist_adiabatic_lapse_rate(temp[base_height_index], 1., pressure[base_height_index]))/1000.d   ; k/m.  input kelvins and pascals
        gamma_l=(pressure[base_height_index]/(rd*temp[base_height_index]))*(cp/lv)*((g/cp)-gamma_m)  ; condensation rate from Grosvenor et al, 2018 equation 14. kg/m3/m
  
        adiabatic_lwp_est=(gamma_l*((dh^2)/2.))*1000. ; g/m2
        fad_first=fad_input ; lwp/adiabatic_lwp_est
        
        nd_first=(nd_dlnbeta_calc(0.,zmax,fad_first, eta, gamma_l*1000.,alpha))*1.e6  ; per cubic meter  ;nd_dlnbeta[j]
        nd_first=75.e6

if ccn_med eq 0.0 then begin
  ccn_med=nd_first/1.e6
  ccn_sdv=0.5*ccn_med
endif
        
        nd_oe_forward_model, sfc_temp,sfc_press, base_height, nd_first*1.e-6, fad_first, alpha, eta, extinction_output, $
          zmax_output, lwp_output, lwc_output, dh,tau_at_extinction_output, re_output,z_top_sim, layer_tau ; z_top_sim is returned in m^3.  Multiply by 1.e18 to convert to mm^6/m^3
          
          ;if (zmax-zmax_output)/zmax gt 0.01 then stop
          if n_elements(re_output) eq 0 then return
          re_output=(re_output*1.e-6) ; meters
          extinction_output=extinction_output/1000. ; per meter
          
        zmax_output=zmax_output[0]
        fx=[alog(zmax_output), alog(extinction_output), alog(lwp_output),alog(z_top_sim)]
        y=[alog(zmax), alog(ext), alog(lwp),alog(z_top)]

        x_first=[alog(nd_first),alog(re_output)]
        x=x_first        
        
  ; get first guess

  nd_index=where(abs(nd_vec-nd_first) eq min(abs(nd_vec-nd_first))) & nd_index=nd_index[0] & if nd_index eq 0 then nd_index=1 & if nd_index eq n_elements(nd_vec)-1 then nd_index=nd_index-1
  fad_index=where(abs(fad_vec-fad_first) eq min(abs(fad_vec-fad_first))) & fad_index=fad_index[0] & if fad_index eq 0 then fad_index=1 & if fad_index eq n_elements(nd_vec)-1 then fad_index=fad_index-1
  eta_index=where(abs(eta_vec-eta) eq min(abs(eta_vec-eta))) & eta_index=eta_index[0] & if eta_index eq 0 then eta_index=1 & if eta_index eq n_elements(eta_vec)-1 then eta_index=eta_index-1
  dh_index=where(abs(dh_vec-dh) eq min(abs(dh_vec-dh))) & dh_index=dh_index[0] & if dh_index eq 0 then dh_index=1 & if dh_index eq n_elements(dh_vec)-1 then dh_index=dh_index-1
  alpha_index=where(abs(alpha_vec-alpha) eq min(abs(alpha_vec-alpha))) & alpha_index=alpha_index[0] & if alpha_index eq 0 then alpha_index=1 & if alpha_index eq n_elements(alpha_vec)-1 then alpha_index=alpha_index-1
  
  
  ;;;; this is from the derivation on page 27 of notebook 8/18/2022
  A=(9.*!pi/(2.*(rho_liquid^2)))*((gamma(alpha+3.))^3)/(((gamma(alpha+4))^2)*gamma(alpha+1.)) ; see derivation on page 24
  B=double(A^(1./3.))
  
  term1=((3.d)*double(eta)*(((gamma_l*1000.)*double(fad_input))^(2.d/3.d))*B)^(3.d/5.d)
  dzmax_dnd=(-1.5d/5.d)*(nd_first^(-6.d/5.d))/term1  ; bottom right of page 27
  kx[0,0]=(dzmax_dnd)*((nd_first)/(zmax_output))
  
  kx[1,0]=(2.*!pi)*((re_output)^2)*(1./(((alpha+3)^2)*gamma(alpha+1.)))*(nd_first/extinction_output)
  kx[2,0]=0.0 ; I'm thinking that LWP would not vary with Nd by much in reality.  this should be zero in practice
  
  ; dz_top/dnd
  ;kx[3,0]
  dz_top_dnd=((re_output^6)*gamma(alpha+7.))/(gamma(alpha+1.)*((alpha+3.)^6))
  kx[3,0]=dz_top_dnd*(nd_first/z_top)
  

  dext_dre=(-3.*lwc_output)/(2.*rho_liquid)*(1./re_output^2)
  dlnext_dlnre=dext_dre*(re_output/extinction_output)
  
  k=(alpha+2.)*(alpha+1.)/((alpha+3.)^2)
  dlnnd_dlnre=((-9./4.)*(lwc_output/(k*!pi*rho_liquid))*(1./re_output^4))*(re_output/nd_first)
  dlnzm_dlnre=dlnnd_dlnre*kx[0,0]
  kx[0,1]=dlnzm_dlnre
  
  ;dext_dre

  kx[1,1]=dext_dre*(re_output/extinction_output)

  ;dlwp_dre
  kx[2,1]=((2./(3.*rho_liquid))/layer_tau)*(lwp/re_output)

  ;dz_top/dre
  dz_top_dre=3.*(re_output^2)*((48.*lwc_output)/(!pi*rho_liquid))*((gamma(alpha+7.))/((gamma(alpha+4.))*((alpha+3.)^3)))
  kx[3,1]=dz_top_dre*(re_output/z_top)

  ;ddh/dre
  D=(0.0620/(0.8^(1./3.)))^3 ; units of m/kg
  
  ;;;;;;;;;;;;;;;; Kb terms
  ;
  ;% Compiled module: CALC_KB_DERIVS.
  ;mean, median, stdev
;  dzm_dalpha    -0.0837186   -0.0857143    0.0198336
;  dext_dalpha      0.108322     0.103949    0.0243979
;  dztop_dalpha     -0.352581    -0.352648  3.71200e-07
;  dzm_dfad     -0.590996    -0.543479     0.227547
;  dext_dfad      0.547898     0.553176     0.218189
;  dztop_dfad       2.00000      2.00000  3.34147e-06
;  dzm_deta     -0.639993    -0.642857    0.0543589
;  dext_deta     0.0297916  -0.00464395     0.103189

kb[0,0]=-0.084 & kb[0,1]=-0.59 & kb[0,2]=-0.63  ; dzm_d_assumption row
kb[1,0]=0.11 & kb[1,1]=0.55 & kb[1,2]=0.03  ; dextinction_d_assumption row
kb[2,0]=0.2 & kb[2,1]=1. & kb[2,2]=0. ; dlwp/d_assumption row ; & kb[0,2]=0.2 guess at sens of lwp to alpha
kb[3,0]=-0.35 & kb[3,1]=2. & kb[3,2]=0. ; dz_top_d_assumption row

;;;;;;;   sa=fltarr(nx,nx)  nd, fad, re
  
  ; get the ln variance of the nd
  
  indexes=where(abs(temperature-temp_prior) lt 5. and Nd_cloud gt 10. and Nd_cloud lt 500.)
  if n_elements(indexes) lt 10 then indexes=where(abs(Nd_cloud gt 10. and Nd_cloud lt 500.))
  
sa[0,0]= 10.*(((stddev(Nd_cloud[indexes]))/mean(Nd_cloud[indexes]))^2)

if ccn_sdv gt 0. then begin
  sa[0]=(ccn_sdv/ccn_med)^2
endif 

sa[1,1]=(((stddev(re_cloud[indexes]))/mean(re_cloud[indexes]))^2)/0.50

if re_prior_sdv gt 0. then begin
  sa[1,1]=re_prior_sdv^2  ; fraction
endif


sb[0,0]=uncert_alpha^2 ;((stddev(alpha_s[where(alpha_s gt 0.01)]))/mean(alpha_s[where(alpha_s gt 0.01)]))^2 
sb[1,1]=uncert_fad^2  ;0.3^2 ; estimated uncertainty in fad
sb[2,2]=uncert_eta^2  ;0.2^2 ; estimated uncertainty in eta

s_eps[0,0]=uncert_zmax^2
s_eps[1,1]=uncert_ext^2
s_eps[2,2]=uncert_lwp^2
s_eps[3,3]=uncert_z^2

s_eps[0,1]=-0.69*(uncert_zmax*uncert_ext) ; leading fractions are derived from capricorn and marcus data
s_eps[0,2]=0.24*(uncert_zmax*uncert_lwp)
s_eps[0,3]=0.23*(uncert_zmax*uncert_z)
;
s_eps[1,2]=-0.22*(uncert_ext*uncert_lwp)
s_eps[1,3]=0.48*(uncert_ext*uncert_z)


forward_model_error_frac=1.
s_eps_forward_model=((transpose(kb)##transpose(sb))##(kb)) & s_eps_forward_model[1,0]=0.0 & s_eps_forward_model[0,1]=0.0 ;for l=0,n_elements(s_eps_forward_model[*,0])-2 do s_eps_forward_model[l+1:n_elements(s_eps_forward_model[*,0])-1,l]=0.0
Sy=S_eps;+(s_eps_forward_model*forward_model_error_frac)


;what to predict: zmax, ext, lwp
; what is input: nd, fad, alpha, tau_max, eta, dh
  xa[0]=alog(ccn_med*1.e6)  ; see above.  ccn_med is set to nd_first value
xa[1]=alog(mean(re_cloud[indexes]*1.e-2))

if re_prior gt 0. then begin
  xa[1]=alog(re_prior*1.e-6)  ; assume comes in microns
endif


for i=0,30 do begin
  ; Equation for Newtonian Iteration
  ;x(i+1.) = x(i) + invert((invert(Sa) +transpose(Kx)*invert(Sy)*Kx)) * ( transpose(Kx)*invert(Sy)(y-Fx) - invert(Sa)*(x-xa))

  if i gt 0 then begin
    fu=Fx-Fx_prev
    m_test=((transpose(fu)))#(((invert(S_delta_y)))#(((fu))))
    Fx_prev=Fx
    if m_test lt 1.e-2 then i=301
  endif else begin
    m_test=1.e12
    Fx_prev=Fx
  endelse

  term1=(invert(double(1.*Sa)))#(reform(double(x-xa)))
  term2=(double(transpose(Kx)))#(invert(double(Sy)))#(double(y-Fx))
  term3=invert((invert(double(1.*Sa)))+(((double(transpose(Kx))))#(invert(double(Sy)))#((double(Kx)))))
  dx=(term3)#((term2)-(term1))

  if min(finite(dx)) gt 0 then begin
    x=x+(dx)

    arg = transpose(Kx)#invert(Sy)
    arg2 = arg#(Kx) & arg2[1,0]=0.0

    Sx = invert( invert(Sa)+arg2 )

      nd_next=exp(x[0])
      fad_next=fad_input

      re_next=exp(x[1])

    nd_oe_forward_model, sfc_temp,sfc_press, base_height, nd_next*1.e-6, fad_next, alpha, eta, extinction_output, $
      zmax_output, lwp_output, lwc_output, dh,tau_at_extinction_output, re_output,z_top_sim, layer_tau & zmax_output=zmax_output[0]
      
    re_output=re_output*1.e-6 ; meters
    re_next=re_output
    x[1]=alog(re_next)
    extinction_output=extinction_output/1000. ; per meter

    fx=[alog(zmax_output), alog(extinction_output), alog(lwp_output),alog(z_top_sim)]
      
      s_delta_y = Sy##(invert((transpose(Kx))##(Sa)##(Kx)+Sy))##Sy
    
    endif else begin
      m_test=99.
     return
    endelse

endfor

x_hat=x
x_final=x_hat

  s_eps_forward_model_temp=s_eps_forward_model
  s_eps_forward_model[*,*]=0.
  s_eps_forward_model[0,0]=s_eps_forward_model_temp[0,0]
  s_eps_forward_model[1,1]=s_eps_forward_model_temp[1,1]
  s_eps_forward_model[2,2]=s_eps_forward_model_temp[2,2]
  s_eps_forward_model[3,3]=s_eps_forward_model_temp[3,3]

  s_eps_forward_model[1,1]=s_eps_forward_model[1,1]*10.
  S_y=s_eps+s_eps_forward_model
  kx[0,1]=kx[0,1]/3.
  kx[1,1]=kx[1,1]/3.

  arg = transpose(Kx)#invert(S_y)
  arg2 = arg#(Kx) ;& arg2[0,1:4]=0. & arg2[1,2:4]=0. & arg2[2,3:4]=0. & arg2[3,4]=0.
  Sx = invert( (invert(Sa))+arg2 )


  ; pull the quantities for output.

  ret_vector=x_hat

  ret_vector[0]=exp(x_hat[0]) ;+(sx[0,0]/2.))  ; return the median values
  ret_vector[1]=exp(x_hat[1])  ;+(sx[1,1]/2.))
  unc_vector=fltarr(n_elements(ret_vector))
  
  nd=ret_vector[0]/1.e6 ; output in cm-3

  re_top=ret_vector[1]*1.e6  ; output in microns

  ;;;; need to determine correlations, informtion content, number of independent obs, etc.,

  unc_vector[0]=(sqrt((exp((2.*x_hat[0])+sx[0,0]))*((exp(sx[0,0]))-1.)))/ret_vector[0] ; fractional uncertainties.
  unc_vector[1]=(sqrt((exp((2.*x_hat[1])+sx[1,1]))*((exp(sx[1,1]))-1.)))/ret_vector[1]

  uncert_nd=unc_vector[0]

  uncert_re_top=unc_vector[1]
  
  fx_vector_uncertainty=[s_y[0,0],s_y[1,1],s_y[2,2],s_y[3,3]]

  ;;;;;; Need to include convergence test in output.
  ;
  ;
  info_content=(alog(determ((Sa)##(invert(sx, /double)))))/alog(2.)
  S_info=((((Sa)##(invert(sx, /double)))))

  nd_info=alog(S_info[0,0])/alog(2.)

  re_top_info=alog(S_info[1,1])/alog(2.)
  info_vector=[nd_info,re_top_info]

  sqrt_sa_phys=sqrt_matrix(sa)
  inverse_sqrt_sa_phys=invert(sqrt_sa_phys)
  sqrt_sy=sqrt_matrix(s_y)
  inverse_sqrt_sy=invert(sqrt_sy)
  k_tilda=inverse_sqrt_sy##transpose(kx)##inverse_sqrt_sa_phys
  lambda_matrix=k_tilda##transpose(k_tilda)
  svdc, lambda_matrix, W, U, V
  num_ret_param=n_elements(where(W gt 1.))
  num_ind_obs=0. & for ii=0,n_elements(w)-1 do num_ind_obs=num_ind_obs+(w[ii]/(w[ii]+1.))
  

return
end