pro read_plot_ena_vectors


fname='/Users/u0029340/Documents/data/ena/graphics/ena_cld_pre.cdf'
cdfid=ncdf_open(fname)
x_id=ncdf_varid(cdfid, 'lwp') & ncdf_varget, cdfid, x_id, lwp_oe_pre
x_id=ncdf_varid(cdfid, 'm_test') & ncdf_varget, cdfid, x_id, m_test_output_pre
x_id=ncdf_varid(cdfid, 'nd') & ncdf_varget, cdfid, x_id, nd_oe_pre
x_id=ncdf_varid(cdfid, 're') & ncdf_varget, cdfid, x_id, re_top_oe_pre
x_id=ncdf_varid(cdfid, 'ccn') & ncdf_varget, cdfid, x_id, ccn_array_oe_pre
x_id=ncdf_varid(cdfid, 'albedo') & ncdf_varget, cdfid, x_id, albedo_pre
x_id=ncdf_varid(cdfid, 'tau') & ncdf_varget, cdfid, x_id, optical_depth_pre
x_id=ncdf_varid(cdfid, 'rain_rate') & ncdf_varget, cdfid, x_id, rain_rate_pre
x_id=ncdf_varid(cdfid, 'dbz') & ncdf_varget, cdfid, x_id, dbz_avg_subcloud_pre
x_id=ncdf_varid(cdfid, 'low_cld_flag') & ncdf_varget, cdfid, x_id, low_cloud_flag_pre
x_id=ncdf_varid(cdfid, 'w_dir') & ncdf_varget, cdfid, x_id, w_dir_cld_pre
x_id=ncdf_varid(cdfid, 'julian_day') & ncdf_varget, cdfid, x_id, julian_day_ret_pre
x_id=ncdf_varid(cdfid, 'w_spd') & ncdf_varget, cdfid, x_id, w_spd_cld_pre
ncdf_close, cdfid


fname='/Users/u0029340/Documents/data/ena/graphics/ena_cld_post.cdf'
cdfid=ncdf_open(fname)
x_id=ncdf_varid(cdfid, 'lwp') & ncdf_varget, cdfid, x_id, lwp_oe_post
x_id=ncdf_varid(cdfid, 'm_test') & ncdf_varget, cdfid, x_id, m_test_output_post
x_id=ncdf_varid(cdfid, 'nd') & ncdf_varget, cdfid, x_id, nd_oe_post
x_id=ncdf_varid(cdfid, 're') & ncdf_varget, cdfid, x_id, re_top_oe_post
x_id=ncdf_varid(cdfid, 'ccn') & ncdf_varget, cdfid, x_id, ccn_array_oe_post
x_id=ncdf_varid(cdfid, 'albedo') & ncdf_varget, cdfid, x_id, albedo_post
x_id=ncdf_varid(cdfid, 'tau') & ncdf_varget, cdfid, x_id, optical_depth_post
x_id=ncdf_varid(cdfid, 'rain_rate') & ncdf_varget, cdfid, x_id, rain_rate_post
x_id=ncdf_varid(cdfid, 'dbz') & ncdf_varget, cdfid, x_id, dbz_avg_subcloud_post
x_id=ncdf_varid(cdfid, 'low_cld_flag') & ncdf_varget, cdfid, x_id, low_cloud_flag_post
x_id=ncdf_varid(cdfid, 'w_dir') & ncdf_varget, cdfid, x_id, w_dir_cld_post
x_id=ncdf_varid(cdfid, 'julian_day') & ncdf_varget, cdfid, x_id, julian_day_ret_post
x_id=ncdf_varid(cdfid, 'w_spd') & ncdf_varget, cdfid, x_id, w_spd_cld_post
ncdf_close, cdfid


fname='/Users/u0029340/Documents/data/ena/graphics/ena_lwp_pre.cdf'
cdfid=ncdf_open(fname)
x_id=ncdf_varid(cdfid, 'lwp') & ncdf_varget, cdfid, x_id, lwp_pre
x_id=ncdf_varid(cdfid, 'julday') & ncdf_varget, cdfid, x_id, julday_mwr_pre
x_id=ncdf_varid(cdfid, 'pwv') & ncdf_varget, cdfid, x_id, pwv_pre
x_id=ncdf_varid(cdfid, 'irt') & ncdf_varget, cdfid, x_id, irt_pre
x_id=ncdf_varid(cdfid, 'w_dir_mwr') & ncdf_varget, cdfid, x_id, w_dir_mwr_pre
x_id=ncdf_varid(cdfid, 'w_spd_mwr') & ncdf_varget, cdfid, x_id, w_spd_mwr_pre
ncdf_close, cdfid

fname='/Users/u0029340/Documents/data/ena/graphics/ena_lwp_post.cdf'
cdfid=ncdf_open(fname)
x_id=ncdf_varid(cdfid, 'lwp') & ncdf_varget, cdfid, x_id, lwp_post
x_id=ncdf_varid(cdfid, 'julday') & ncdf_varget, cdfid, x_id, julday_mwr_post
x_id=ncdf_varid(cdfid, 'pwv') & ncdf_varget, cdfid, x_id, pwv_post
x_id=ncdf_varid(cdfid, 'irt') & ncdf_varget, cdfid, x_id, irt_post
x_id=ncdf_varid(cdfid, 'w_dir_mwr') & ncdf_varget, cdfid, x_id, w_dir_mwr_post
x_id=ncdf_varid(cdfid, 'w_spd_mwr') & ncdf_varget, cdfid, x_id, w_spd_mwr_post
ncdf_close, cdfid


fname='/Users/u0029340/Documents/data/ena/graphics/ena_ccn_pre.cdf'
cdfid=ncdf_open(fname)
x_id=ncdf_varid(cdfid, 'ss_calc') & ncdf_varget, cdfid, x_id, ss_calc_pre
x_id=ncdf_varid(cdfid, 'cn_calc') & ncdf_varget, cdfid, x_id, cn_pre
x_id=ncdf_varid(cdfid, 'ccn_calc') & ncdf_varget, cdfid, x_id, ccn_pre
x_id=ncdf_varid(cdfid, 'wdir') & ncdf_varget, cdfid, x_id, w_dir_pre
x_id=ncdf_varid(cdfid, 'wsdp') & ncdf_varget, cdfid, x_id, w_spd_pre
x_id=ncdf_varid(cdfid, 'qc') & ncdf_varget, cdfid, x_id, qc_ccn_pre
x_id=ncdf_varid(cdfid, 'julday') & ncdf_varget, cdfid, x_id, julday_pre
ncdf_close, cdfid

fname='/Users/u0029340/Documents/data/ena/graphics/ena_ccn_post.cdf'
cdfid=ncdf_open(fname)
x_id=ncdf_varid(cdfid, 'ss_calc') & ncdf_varget, cdfid, x_id, ss_calc_post
x_id=ncdf_varid(cdfid, 'cn_calc') & ncdf_varget, cdfid, x_id, cn_post
x_id=ncdf_varid(cdfid, 'ccn_calc') & ncdf_varget, cdfid, x_id, ccn_post
x_id=ncdf_varid(cdfid, 'wdir') & ncdf_varget, cdfid, x_id, w_dir_post
x_id=ncdf_varid(cdfid, 'wsdp') & ncdf_varget, cdfid, x_id, w_spd_post
x_id=ncdf_varid(cdfid, 'qc') & ncdf_varget, cdfid, x_id, qc_ccn_post
x_id=ncdf_varid(cdfid, 'julday') & ncdf_varget, cdfid, x_id, julday_post
ncdf_close, cdfid

conditions_vec_pre=where(w_spd_pre gt 2.5 and w_dir_pre gt 0. and w_dir_pre lt 70. and cn_pre gt 0.)
conditions_vec_post=where(w_spd_post gt 2.5 and w_dir_post gt 0. and w_dir_post lt 70. and cn_post gt 0.)

conditions_lwp_pre=where(lwp_pre lt 300. and lwp_pre gt 20. and w_spd_mwr_pre gt 5. and w_dir_mwr_pre gt 0. and w_dir_mwr_pre lt 70.)
conditions_lwp_post=where(lwp_post lt 300. and lwp_post gt 20. and w_spd_mwr_post gt 5. and w_dir_mwr_post gt 0. and w_dir_mwr_post lt 70.)

conditions_cloud_pre=where(m_test_output_pre lt 1. and nd_oe_pre gt 10. and nd_oe_pre lt 1.e6 and m_test_output_pre gt 0. and lwp_oe_pre gt 20. and lwp_oe_pre lt 150. and finite(re_top_oe_pre) eq 1)
conditions_cloud_post=where(m_test_output_post lt 1. and nd_oe_post gt 10. and nd_oe_post lt 1.e6 and m_test_output_post gt 0. and lwp_oe_post gt 20. and lwp_oe_post lt 150. and finite(re_top_oe_post) eq 1)

conditions_precip_pre2=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 1.e6 and rain_rate_pre gt 0.0 and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
conditions_precip_post2=where(lwp_oe_post gt 20. and lwp_oe_post lt 1.e6 and rain_rate_post gt 0.0 and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)

conditions_precip_0p001_pre2=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 1.e6 and rain_rate_pre gt 0.001 and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
conditions_precip_0p001_post2=where(lwp_oe_post gt 20. and lwp_oe_post lt 1.e6 and rain_rate_post gt 0.001 and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)

conditions_precip_0p01_pre2=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 1.e6 and rain_rate_pre gt 0.01 and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
conditions_precip_0p01_post2=where(lwp_oe_post gt 20. and lwp_oe_post lt 1.e6 and rain_rate_post gt 0.01 and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)

conditions_precip_0p1_pre2=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 1.e6 and rain_rate_pre gt 0.1 and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
conditions_precip_0p1_post2=where(lwp_oe_post gt 20. and lwp_oe_post lt 1.e6 and rain_rate_post gt 0.1 and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)

conditions_precip_1p0_pre2=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 1.e6 and rain_rate_pre gt 1. and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
conditions_precip_1p0_post2=where(lwp_oe_post gt 20. and lwp_oe_post lt 1.e6 and rain_rate_post gt 1. and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)

conditions_pre222=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 1.e6 and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
conditions_post222=where(lwp_oe_post gt 20. and lwp_oe_post lt 1.e6 and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)

conditions_pre2_all=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 1.e6 and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
conditions_post2_all=where(lwp_oe_post gt 20. and lwp_oe_post lt 1.e6 and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)

conditions_pre22_all=where(w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
conditions_post22_all=where(w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)


julian_days_int_pre=long(julian_day_ret_pre[conditions_cloud_pre])
days_pre=0 & curr_day=julian_days_int_pre[0]
for j=1,n_elements(julian_days_int_pre)-1 do begin
  diff=abs(julian_days_int_pre[j]-curr_day)
  if diff ge 1 then begin
    curr_day=julian_days_int_pre[j]
    days_pre=days_pre+1
  endif
endfor

julian_days_int_post=long(julian_day_ret_post[conditions_cloud_post])
days_post=0 & curr_day=julian_days_int_post[0]
for j=1,n_elements(julian_days_int_post)-1 do begin
  diff=abs(julian_days_int_post[j]-curr_day)
  if diff ge 1 then begin
    curr_day=julian_days_int_post[j]
    days_post=days_post+1
  endif
endfor


print, ' Cloud occurrence ',float(n_elements(conditions_pre222))/float(n_elements(conditions_pre22_all)), float(n_elements(conditions_post222))/float(n_elements(conditions_post22_all))
print, ' Precip occurrence ',float(n_elements(conditions_precip_pre2))/float(n_elements(conditions_pre2_all)), float(n_elements(conditions_precip_post2))/float(n_elements(conditions_post2_all))
print, ' Precip occurrence (>0.001) ',float(n_elements(conditions_precip_0p001_pre2))/float(n_elements(conditions_precip_pre2)), float(n_elements(conditions_precip_0p001_post2))/float(n_elements(conditions_precip_post2))
print, ' Precip occurrence (>0.01) ',float(n_elements(conditions_precip_0p01_pre2))/float(n_elements(conditions_precip_pre2)), float(n_elements(conditions_precip_0p01_post2))/float(n_elements(conditions_precip_post2))
print, ' Precip occurrence (>0.1) ',float(n_elements(conditions_precip_0p1_pre2))/float(n_elements(conditions_precip_pre2)), float(n_elements(conditions_precip_0p1_post2))/float(n_elements(conditions_precip_post2))
print, ' Precip occurrence (>1.) ',float(n_elements(conditions_precip_1p0_pre2))/float(n_elements(conditions_precip_pre2)), float(n_elements(conditions_precip_1p0_post2))/float(n_elements(conditions_precip_post2))
;
;Cloud occurrence      0.280390     0.363377
;Precip occurrence      0.633919     0.697731

rain_total_pre=0.
for j=0,n_elements(conditions_precip_pre2)-1 do begin
  rain_total_pre=rain_total_pre+(rain_rate_pre[conditions_precip_pre2[j]]*(30.d/86400.d))
endfor

rain_total_post=0.
for j=0,n_elements(conditions_precip_post2)-1 do begin
  rain_total_post=rain_total_post+(rain_rate_post[conditions_precip_post2[j]]*(30.d/86400.d))
endfor

print, 'Normalized Drizzle pre (mm)/cloud_fraction: ',rain_total_pre/(float(n_elements(conditions_pre222))/float(n_elements(conditions_pre22_all)))
print, 'Normalized Drizzle post (mm)/cloud_fraction: ',rain_total_post/(float(n_elements(conditions_post222))/float(n_elements(conditions_post22_all)))


lin_histo_2_logplot, rain_rate_pre[where(rain_rate_pre gt 0.0)], rain_rate_post[where(rain_rate_post gt 0.0)], 5, 20, rain_rate_pre_histo1, rain_rate_post_histo2, precip_bins, $
  rain_rate_pre_moments1, rain_rate_post_moments2, rain_rate_pre_med1, rain_rate_pst_med2, num, 0.00001, 5., 1.5

  set_plot, 'Z'
  loadct, 5 & gamma_ct, 1.0 & set_plot, 'Z' & device, set_resolution=[3000,2000] & !p.charsize=3.25 & !p.font=-1 & !p.background=!d.n_colors-1
  top_top_y=0.93 & dy=0.1 & top_y=0.95 & bot_y=top_y-dy & sep_y=0.05
  sx=0.12 & sy=0.06 & xl=0.1 & xr=0.9 & yt=0.95 & yb=0.1
  !p.thick=3. & numplots_x=3 & numplots_y=3
  position_plots,xl,xr,yb,yt,sx,sy,numplots_x,numplots_y,pos
  cbpos=pos & cbpos[*,0]=cbpos[*,2]+0.08 & cbpos[*,2]=cbpos[*,0]+0.012
  !p.multi=[0,4,4]

  pnum=8
  
  
  plot, precip_bins, rain_rate_pre_histo1/float(total(rain_rate_pre_histo1)), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='Rain Rate (mm/day)', ytitle='Frequency', title='Precip Rate Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.25, charthick=4, yrange=[0.001,1.], /xlog, /ylog ;max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])

  oplot, precip_bins,rain_rate_post_histo2/float(total(rain_rate_post_histo2)), psym=10, color=100
  
  kstwo_nin, rain_rate_pre[where(rain_rate_pre gt 0.0)], rain_rate_post[where(rain_rate_post gt 0.0)], d, prob, 150.

  xyouts, mean(precip_bins), median(rain_rate_pre_histo1/float(total(rain_rate_pre_histo1))), strtrim(string(prob, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data
  ;;;;;;;;;  write precip histo data
  cdfid=ncdf_create('/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/Precip1.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(precip_bins))
  bins_id=ncdf_vardef(cdfid, 'Rain_Rate_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'Rain Rate'
  ncdf_attput, cdfid, bins_id, 'units', 'millimeters per day'
  pre_id=ncdf_vardef(cdfid, 'rain_rate_pre_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of Rain Rate of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'rain_rate_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of Rain Rate of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
  ncdf_attput, cdfid, d_id, 'units', 'unitless'
  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
  ncdf_attput, cdfid, prob_id, 'units', 'unitless'
 
  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, precip_bins
  ncdf_varput, cdfid, pre_id, rain_rate_pre_histo1
  ncdf_varput, cdfid, post_id, rain_rate_post_histo2
  ncdf_varput, cdfid, d_id, d
  ncdf_varput, cdfid, prob_id, prob
  ncdf_close, cdfid

  pnum=7

  lin_histo_2, nd_oe_pre[conditions_cloud_pre], nd_oe_post[conditions_cloud_post], 3, 30, nd_pre_histo1, nd_post_histo2, nd_bins, $
    nd_pre_moments1, nd_post_moments2, nd_pre_med1, nd_post_med2, num

plot, nd_bins[where(nd_bins ge -10.)], nd_pre_histo1[where(nd_bins ge -10.)]/float(total(nd_pre_histo1[where(nd_bins ge -10.)])), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='Nd per cc', ytitle='Frequency', title='Nd Pre 2020 (black), Post 2020 (red) ',  $
  charsize=3.25, charthick=4, yrange=[0.,0.35] ;max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])

oplot, nd_bins[where(nd_bins ge -10.)],nd_post_histo2[where(nd_bins ge -10.)]/float(total(nd_post_histo2[where(nd_bins ge -10.)])), psym=10, color=100

kstwo_nin, nd_oe_pre[conditions_cloud_pre], nd_oe_post[conditions_cloud_post], d, prob, 150.

xyouts, mean(nd_bins[where(nd_bins ge -10.)]), median(nd_pre_histo1[where(nd_bins ge -10.)]/float(total(nd_pre_histo1[where(nd_bins ge -10.)]))), $
  strtrim(string(prob, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data

  ;;;;;;;;;  write precip histo data
  cdfid=ncdf_create('/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/Nd1.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(nd_bins[where(nd_bins ge -10.)]))
  bins_id=ncdf_vardef(cdfid, 'Nd_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'Nd'
  ncdf_attput, cdfid, bins_id, 'units', 'per cubic centimeter'
  pre_id=ncdf_vardef(cdfid, 'Nd_pre_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of Nd of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'Nd_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of Nd of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
  ncdf_attput, cdfid, d_id, 'units', 'unitless'
  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
  ncdf_attput, cdfid, prob_id, 'units', 'unitless'

  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, nd_bins[where(nd_bins ge -10.)]
  ncdf_varput, cdfid, pre_id, nd_pre_histo1[where(nd_bins ge -10.)]
  ncdf_varput, cdfid, post_id, nd_post_histo2[where(nd_bins ge -10.)]
  ncdf_varput, cdfid, d_id, d
  ncdf_varput, cdfid, prob_id, prob
  ncdf_close, cdfid
  
pnum=6

lin_histo_2, re_top_oe_pre[conditions_cloud_pre], re_top_oe_post[conditions_cloud_post], 3, 20, re_pre_histo1, re_post_histo2, re_bins, $
  re_pre_moments1, re_post_moments2, re_pre_med1, re_post_med2, num

plot, re_bins[where(re_bins ge 0. and re_bins lt 25.)], re_pre_histo1[where(re_bins ge 0. and re_bins lt 25.)]/float(total(re_pre_histo1[where(re_bins ge 0. and re_bins lt 25.)])), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='re (microns)', ytitle='Frequency', title='re Pre 2020 (black), Post 2020 (red) ',  $
  charsize=3.25, charthick=4, yrange=[0.,max(re_pre_histo1[where(re_bins ge 0.)]/float(total(re_pre_histo1[where(re_bins ge 0.)])))]


oplot, re_bins[where(re_bins ge 0. and re_bins lt 25.)],re_post_histo2[where(re_bins ge 0. and re_bins lt 25.)]/float(total(re_post_histo2[where(re_bins ge 0. and re_bins lt 25.)])), psym=10, color=100

kstwo_nin, re_top_oe_pre[conditions_cloud_pre], re_top_oe_post[conditions_cloud_post], d, prob, 150.

xyouts, mean(re_bins[where(re_bins ge 0. and re_bins lt 25.)]), median(re_pre_histo1[where(re_bins ge 0. and re_bins lt 25.)]/float(total(re_pre_histo1[where(re_bins ge 0. and re_bins lt 25.)]))), $
  strtrim(string(prob, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data

;;;;;;;;;  write precip histo data
cdfid=ncdf_create('/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/re1.cdf',/clobber)
event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(nd_bins[where(nd_bins ge -10.)]))
bins_id=ncdf_vardef(cdfid, 're_Bins',[event_did],/float)
ncdf_attput, cdfid, bins_id, 'long_name', 're'
ncdf_attput, cdfid, bins_id, 'units', 'microns'
pre_id=ncdf_vardef(cdfid, 're_pre_histo1',[event_did],/float)
ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of re of the Pre Fuel Change Period'
ncdf_attput, cdfid, pre_id, 'units', 'counts'
post_id=ncdf_vardef(cdfid, 're_post_histo2',[event_did],/float)
ncdf_attput, cdfid, post_id, 'long_name', 'Counts of re of the Post Fuel Change Period'
ncdf_attput, cdfid, post_id, 'units', 'counts'
d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
ncdf_attput, cdfid, d_id, 'units', 'unitless'
prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
ncdf_attput, cdfid, prob_id, 'units', 'unitless'
ncdf_control, cdfid, /endef
ncdf_varput, cdfid, bins_id, re_bins[where(re_bins ge 0. and re_bins lt 25.)]
ncdf_varput, cdfid, pre_id, re_pre_histo1[where(re_bins ge 0. and re_bins lt 25.)]
ncdf_varput, cdfid, post_id, re_post_histo2[where(re_bins ge 0. and re_bins lt 25.)]
ncdf_varput, cdfid, d_id, d
ncdf_varput, cdfid, prob_id, prob
ncdf_close, cdfid
  
pnum=5

lin_histo_2, optical_depth_pre[conditions_cloud_pre], optical_depth_post[conditions_cloud_post], 3, 15, optical_depth_pre_histo1, optical_depth_post_histo2, optical_depth_bins, $
  optical_depth_pre_moments1, optical_depth_post_moments2, optical_depth_pre_med1, optical_depth_post_med2, num


plot, optical_depth_bins[where(optical_depth_bins ge 0.)], optical_depth_pre_histo1[where(optical_depth_bins ge 0.)]/float(total(optical_depth_pre_histo1[where(optical_depth_bins ge 0.)])), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='optical depth ', ytitle='Frequency', title='Optical Depth Pre 2020 (black), Post 2020 (red) ',  $
  charsize=3.25, charthick=4, yrange=[0.,max(optical_depth_pre_histo1[where(optical_depth_bins ge 0.)]/float(total(optical_depth_pre_histo1[where(optical_depth_bins ge 0.)])))]

oplot, optical_depth_bins[where(optical_depth_bins ge 0.)],optical_depth_post_histo2[where(optical_depth_bins ge 0.)]/float(total(optical_depth_post_histo2[where(optical_depth_bins ge 0.)])), psym=10, color=100

kstwo_nin, optical_depth_pre[conditions_cloud_pre], optical_depth_post[conditions_cloud_post], d, prob, 150.

xyouts, mean(optical_depth_bins[where(optical_depth_bins ge 0.)]), median(optical_depth_pre_histo1[where(optical_depth_bins ge 0.)]/float(total(optical_depth_pre_histo1[where(optical_depth_bins ge 0.)]))), $
  strtrim(string(prob, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data

;;;;;;;;;  write tau histo data
cdfid=ncdf_create('/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/tau1.cdf',/clobber)
event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(optical_depth_bins[where(optical_depth_bins ge 0.)]))
bins_id=ncdf_vardef(cdfid, 'Optical_Depth_Bins',[event_did],/float)
ncdf_attput, cdfid, bins_id, 'long_name', 'tau'
ncdf_attput, cdfid, bins_id, 'units', 'unitless'
pre_id=ncdf_vardef(cdfid, 'Optical_Depth_pre_histo1',[event_did],/float)
ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of optical depth of the Pre Fuel Change Period'
ncdf_attput, cdfid, pre_id, 'units', 'counts'
post_id=ncdf_vardef(cdfid, 'Optical_Depth_post_histo2',[event_did],/float)
ncdf_attput, cdfid, post_id, 'long_name', 'Counts of optical depth of the Post Fuel Change Period'
ncdf_attput, cdfid, post_id, 'units', 'counts'
d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
ncdf_attput, cdfid, d_id, 'units', 'unitless'
prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
ncdf_attput, cdfid, prob_id, 'units', 'unitless'

ncdf_control, cdfid, /endef
ncdf_varput, cdfid, bins_id, optical_depth_bins[where(optical_depth_bins ge 0.)]
ncdf_varput, cdfid, pre_id, optical_depth_pre_histo1[where(optical_depth_bins ge 0.)]
ncdf_varput, cdfid, post_id, optical_depth_post_histo2[where(optical_depth_bins ge 0.)]
ncdf_varput, cdfid, d_id, d
ncdf_varput, cdfid, prob_id, prob
ncdf_close, cdfid

pnum=4

lin_histo_2, albedo_pre[conditions_cloud_pre], albedo_post[conditions_cloud_post], 3, 15, albedo_pre_histo1, albedo_post_histo2, albedo_bins, $
  albedo_pre_moments1, albedo_post_moments2, albedo_pre_med1, albedo_post_med2, num


plot, albedo_bins[where(albedo_bins ge 0.)], albedo_pre_histo1[where(albedo_bins ge 0.)]/float(total(albedo_pre_histo1[where(albedo_bins ge 0.)])), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='albedo ', ytitle='Frequency', title='Albedo Pre 2020 (black), Post 2020 (red) ',  $
  charsize=3.25, charthick=4, yrange=[0.,0.25]

oplot, albedo_bins[where(albedo_bins ge 0.)],albedo_post_histo2[where(albedo_bins ge 0.)]/float(total(albedo_post_histo2[where(albedo_bins ge 0.)])), psym=10, color=100

kstwo_nin, albedo_pre[conditions_cloud_pre], albedo_post[conditions_cloud_post], d, prob, 150.

xyouts, mean(albedo_bins[where(albedo_bins ge 0.)]), median(albedo_pre_histo1[where(albedo_bins ge 0.)]/float(total(albedo_pre_histo1[where(albedo_bins ge 0.)]))), $
  strtrim(string(prob, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data

;;;;;;;;;  write albedo histo data
cdfid=ncdf_create('/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/albedo1.cdf',/clobber)
event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(albedo_bins[where(optical_depth_bins ge 0.)]))
bins_id=ncdf_vardef(cdfid, 'Albedo_Bins',[event_did],/float)
ncdf_attput, cdfid, bins_id, 'long_name', 'albedo'
ncdf_attput, cdfid, bins_id, 'units', 'unitless'
pre_id=ncdf_vardef(cdfid, 'Albedo_pre_histo1',[event_did],/float)
ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of albedo of the Pre Fuel Change Period'
ncdf_attput, cdfid, pre_id, 'units', 'counts'
post_id=ncdf_vardef(cdfid, 'Albedo_post_histo2',[event_did],/float)
ncdf_attput, cdfid, post_id, 'long_name', 'Counts of albedo of the Post Fuel Change Period'
ncdf_attput, cdfid, post_id, 'units', 'counts'
d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
ncdf_attput, cdfid, d_id, 'units', 'unitless'
prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
ncdf_attput, cdfid, prob_id, 'units', 'unitless'
ncdf_control, cdfid, /endef
ncdf_varput, cdfid, bins_id, albedo_bins[where(albedo_bins ge 0.)]
ncdf_varput, cdfid, pre_id, albedo_pre_histo1[where(albedo_bins ge 0.)]
ncdf_varput, cdfid, post_id, albedo_post_histo2[where(albedo_bins ge 0.)]
ncdf_varput, cdfid, d_id, d
ncdf_varput, cdfid, prob_id, prob
ncdf_close, cdfid

pnum=3

lin_histo_2, ccn_pre[conditions_vec_pre], ccn_post[conditions_vec_post], 2, 20, ccn_pre_histo1, ccn_post_histo2, ccn_bins, $
  ccn_pre_moments1, ccn_post_moments2, ccn_pre_med1, ccn_post_med2, num

plot, ccn_bins, ccn_pre_histo1/float(total(ccn_pre_histo1)), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='CCN per cc', ytitle='Frequency', title='CCN SS 0.3 Pre 2020 (black), Post 2020 (red) ',  $
  charsize=3.25, charthick=4, yrange=[0.,max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])]

oplot, ccn_bins,ccn_post_histo2/float(total(ccn_post_histo2)), psym=10, color=100

kstwo_nin, ccn_pre[conditions_vec_pre], ccn_post[conditions_vec_post], d, prob, 150.

xyouts, mean(ccn_bins), median(ccn_post_histo2/float(total(ccn_post_histo2))), $
  strtrim(string(prob, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data

;;;;;;;;;  write albedo histo data
cdfid=ncdf_create('/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/ccn1.cdf',/clobber)
event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(ccn_bins))
bins_id=ncdf_vardef(cdfid, 'CCN_Bins',[event_did],/float)
ncdf_attput, cdfid, bins_id, 'long_name', 'ccn'
ncdf_attput, cdfid, bins_id, 'units', 'per cubic centimeter'
pre_id=ncdf_vardef(cdfid, 'CCN_histo1',[event_did],/float)
ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of CCN of the Pre Fuel Change Period'
ncdf_attput, cdfid, pre_id, 'units', 'counts'
post_id=ncdf_vardef(cdfid, 'CCN_post_histo2',[event_did],/float)
ncdf_attput, cdfid, post_id, 'long_name', 'Counts of CCN of the Post Fuel Change Period'
ncdf_attput, cdfid, post_id, 'units', 'counts'
d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
ncdf_attput, cdfid, d_id, 'units', 'unitless'
prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
ncdf_attput, cdfid, prob_id, 'units', 'unitless'
ncdf_control, cdfid, /endef
ncdf_varput, cdfid, bins_id, ccn_bins
ncdf_varput, cdfid, pre_id, ccn_pre_histo1
ncdf_varput, cdfid, post_id, ccn_post_histo2
ncdf_varput, cdfid, d_id, d
ncdf_varput, cdfid, prob_id, prob
ncdf_close, cdfid

pnum=2

lin_histo_2, lwp_oe_pre[conditions_cloud_pre], lwp_oe_post[conditions_cloud_post], 3, 40, lwp_pre_histo1, lwp_post_histo2, lwp_bins, $
  lwp_pre_moments1, lwp_post_moments2, lwp_pre_med1, lwp_post_med2, num

  plot, lwp_bins[where(lwp_bins ge 0.)], lwp_pre_histo1[where(lwp_bins ge 0.)]/float(total(lwp_pre_histo1[where(lwp_bins ge 0.)])), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='LWP g/m2', ytitle='Frequency', title='LWP Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.25, charthick=4, yrange=[0.,max([lwp_pre_histo1/float(total(lwp_pre_histo1)),lwp_post_histo2/float(total(lwp_post_histo2))])]

  oplot, lwp_bins[where(lwp_bins ge 0.)],lwp_post_histo2[where(lwp_bins ge 0.)]/float(total(lwp_post_histo2[where(lwp_bins ge 0.)])), psym=10, color=100

  kstwo_nin, lwp_oe_pre[conditions_cloud_pre], lwp_oe_post[conditions_cloud_post], d, prob, 150.

  xyouts, mean(lwp_bins[where(lwp_bins ge 0.)]), median(lwp_post_histo2[where(lwp_bins ge 0.)]/float(total(lwp_post_histo2[where(lwp_bins ge 0.)]))), $
    strtrim(string(prob, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data

  ;;;;;;;;;  write albedo histo data
  cdfid=ncdf_create('/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/lwp1.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(lwp_bins[where(lwp_bins ge 0.)]))
  bins_id=ncdf_vardef(cdfid, 'LWP_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'LWP'
  ncdf_attput, cdfid, bins_id, 'units', 'grams per square meter'
  pre_id=ncdf_vardef(cdfid, 'LWP_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of LWP of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'LWP_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of LWP of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
  ncdf_attput, cdfid, d_id, 'units', 'unitless'
  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
  ncdf_attput, cdfid, prob_id, 'units', 'unitless'
ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, lwp_bins[where(lwp_bins ge 0.)]
  ncdf_varput, cdfid, pre_id, lwp_pre_histo1[where(lwp_bins ge 0.)]
  ncdf_varput, cdfid, post_id, lwp_post_histo2[where(lwp_bins ge 0.)]
  ncdf_varput, cdfid, d_id, d
  ncdf_varput, cdfid, prob_id, prob
ncdf_close, cdfid
  
  pnum=1
  
  lin_histo_2, pwv_pre[conditions_lwp_pre], pwv_post[conditions_lwp_post], 3, 20, pwv_pre_histo1, pwv_post_histo2, pwv_bins, $
    pwv_pre_moments1, pwv_post_moments2, pwv_pre_med1, pwv_post_med2, num

  plot, pwv_bins, pwv_pre_histo1/float(total(pwv_pre_histo1)), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='PWV cm', ytitle='Frequency', title='PWV Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.25, charthick=4, yrange=[0.,max([pwv_pre_histo1/float(total(pwv_pre_histo1)),pwv_post_histo2/float(total(pwv_post_histo2))])]

  oplot, pwv_bins,pwv_post_histo2/float(total(pwv_post_histo2)), psym=10, color=100

  kstwo_nin, pwv_pre[conditions_lwp_pre], pwv_post[conditions_lwp_post], d, prob, 150.

  xyouts, mean(pwv_bins), median(pwv_post_histo2/float(total(pwv_post_histo2))), $
    strtrim(string(prob, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data

  ;;;;;;;;;  write albedo histo data
  cdfid=ncdf_create('/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/pwv1.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(pwv_bins))
  bins_id=ncdf_vardef(cdfid, 'PWV_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'PWV'
  ncdf_attput, cdfid, bins_id, 'units', 'cm'
  pre_id=ncdf_vardef(cdfid, 'PWV_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of PWV of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'PWV_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of PWV of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
  ncdf_attput, cdfid, d_id, 'units', 'unitless'
  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
  ncdf_attput, cdfid, prob_id, 'units', 'unitless'
ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, pwv_bins
  ncdf_varput, cdfid, pre_id, pwv_pre_histo1
  ncdf_varput, cdfid, post_id, pwv_post_histo2
  ncdf_varput, cdfid, d_id, d
  ncdf_varput, cdfid, prob_id, prob
ncdf_close, cdfid

  pnum=0
  
  x=w_spd_cld_pre[conditions_cloud_pre]
  y=w_spd_cld_post[conditions_cloud_post]
  
  lin_histo_2, x[where(x gt 0.)], y[where(y gt 0.)], 3, 20, wspd_pre_histo1, wspd_post_histo2, wspd_bins, $
    wspd_pre_moments1, wspd_post_moments2, wspd_pre_med1, wspd_post_med2, num

  plot, wspd_bins, wspd_pre_histo1/float(total(wspd_pre_histo1)), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='wspd (m/s)', ytitle='Frequency', title='wspd Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.25, charthick=4, yrange=[0.,max([wspd_pre_histo1/float(total(wspd_pre_histo1)),wspd_post_histo2/float(total(wspd_post_histo2))])]

  oplot, wspd_bins,wspd_post_histo2/float(total(wspd_post_histo2)), psym=10, color=100

  kstwo_nin, x[where(x gt 0.)], y[where(y gt 0.)], d, prob, 150.

  xyouts, mean(wspd_bins), median(wspd_pre_histo1/float(total(wspd_pre_histo1))), $
    strtrim(string(prob, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data

  ;;;;;;;;;  write albedo histo data
  cdfid=ncdf_create('/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/wspd1.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(wspd_bins))
  bins_id=ncdf_vardef(cdfid, 'wspd_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'wspd'
  ncdf_attput, cdfid, bins_id, 'units', 'm/s'
  pre_id=ncdf_vardef(cdfid, 'wspd_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of wspd of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'wspd_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of wspd of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
  ncdf_attput, cdfid, d_id, 'units', 'unitless'
  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
  ncdf_attput, cdfid, prob_id, 'units', 'unitless'
ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, wspd_bins
  ncdf_varput, cdfid, pre_id, wspd_pre_histo1
  ncdf_varput, cdfid, post_id, wspd_post_histo2
  ncdf_varput, cdfid, d_id, d
  ncdf_varput, cdfid, prob_id, prob
ncdf_close, cdfid
 

;  lin_histo_2, lwp_pre[conditions_lwp_pre], lwp_post[conditions_lwp_post], 3, 20, pwv_pre_histo1, lwp_post_histo2, lwp_bins, $
;    lwp_pre_moments1, lwp_post_moments2, lwp_pre_med1, lwp_post_med2, num
;
;  plot, lwp_bins, lwp_pre_histo1/float(total(lwp_pre_histo1)), color=0,$
;    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='lwp g/m2', ytitle='Frequency', title='LWP Pre 2020 (black), Post 2020 (red) ',  $
;    charsize=3.25, charthick=4, yrange=[0.,max([lwp_pre_histo1/float(total(lwp_pre_histo1)),lwp_post_histo2/float(total(lwp_post_histo2))])]
;
;  oplot, lwp_bins,lwp_post_histo2/float(total(lwp_post_histo2)), psym=10, color=100
;
;  ;;;;;;;;;  write albedo histo data
;  cdfid=ncdf_create('/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/lwp2.cdf',/clobber)
;  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(pwv_bins))
;  bins_id=ncdf_vardef(cdfid, 'LWP_Bins',[event_did],/float)
;  ncdf_attput, cdfid, bins_id, 'long_name', 'LWP'
;  ncdf_attput, cdfid, bins_id, 'units', 'g/m2'
;  pre_id=ncdf_vardef(cdfid, 'LWP_histo1',[event_did],/float)
;  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of LWP of the Pre Fuel Change Period'
;  ncdf_attput, cdfid, pre_id, 'units', 'counts'
;  post_id=ncdf_vardef(cdfid, 'LWP_post_histo2',[event_did],/float)
;  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of LWP of the Post Fuel Change Period'
;  ncdf_attput, cdfid, post_id, 'units', 'counts'
;  ncdf_control, cdfid, /endef
;  ncdf_varput, cdfid, bins_id, lwp_bins
;  ncdf_varput, cdfid, pre_id, lwp_pre_histo1
;  ncdf_varput, cdfid, post_id, lwp_post_histo2
;  ncdf_close, cdfid
  
  write_gif, '/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/ccn_ccn_mwr_clouds_precip_comp_PRE_POST2_2025.gif',tvrd()


;  plot, nd_bins[where(nd_bins ge -10.)], nd_pre_histo1[where(nd_bins ge -10.)]/float(total(nd_pre_histo1[where(nd_bins ge -10.)])), color=0,$
;    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='Nd per cc', ytitle='Frequency', title='Nd Pre 2020 (black), Post 2020 (red) ',  $
;    charsize=3.25, charthick=4, yrange=[0.,0.35] ;max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])
;
;  oplot, nd_bins[where(nd_bins ge -10.)],nd_post_histo2[where(nd_bins ge -10.)]/float(total(nd_post_histo2[where(nd_bins ge -10.)])), psym=10, color=100
;
;  pnum=7


stop
end

