pro read_plot_ena_lwp

  jday1=julday(1,1,1970,0,0,0)

mwr_path='/Users/u0029340/Documents/data/ena/enamwr3cC1.b1/'
sfc_met_dir='/Users/u0029340/Documents/data/ena/enaaosmetC1.a1/'


  months=['201605','201606','201607','201608','201609',$
    '201705','201706','201707','201708','201709',$
    '201805','201806','201807','201808','201809']

   ; get the pre mwr data
   first_flag=1
  for jj=0,n_elements(months)-1 do begin

    mwr_files=file_search(mwr_path+'enamwr3cC1.b1.'+months[jj]+'*.*', count=count)

    for j=0,count-1 do begin

      cdfid=ncdf_open(mwr_files[j])
      ;cdfid=ncdf_open(radar_path+radar_file,/nowrite)

      x_id=ncdf_varid(cdfid, 'base_time') & ncdf_varget,cdfid,x_id,base_time
      x_id=ncdf_varid(cdfid, 'time_offset') & ncdf_varget,cdfid,x_id,time_offset
      x_id=ncdf_varid(cdfid, 'lwp') & ncdf_varget,cdfid,x_id,lwp1
      x_id=ncdf_varid(cdfid, 'lwp_err') & ncdf_varget,cdfid,x_id,lwp_err1
      x_id=ncdf_varid(cdfid, 'pwv') & ncdf_varget,cdfid,x_id,pwv1
      x_id=ncdf_varid(cdfid, 'pwv_err') & ncdf_varget,cdfid,x_id,pwv_err1
      x_id=ncdf_varid(cdfid, 'infrared_temperature') & ncdf_varget,cdfid,x_id,infrared_temperature1
      x_id=ncdf_varid(cdfid, 'rain_flag') & ncdf_varget,cdfid,x_id,rain_flag1
      x_id=ncdf_varid(cdfid, 'lat') & ncdf_varget,cdfid,x_id,lat
      x_id=ncdf_varid(cdfid, 'lon') & ncdf_varget,cdfid,x_id,lon
      ncdf_close, cdfid
      
      julday1=jday1+((double(base_time)+time_offset)/86400.d)
      
      if first_flag eq 1 then begin
        lwp_pre=lwp1
        pwv_pre=pwv1
        julday_mwr_pre=julday1
        rain_flag_pre=rain_flag1
        first_flag=0
      endif else begin
        lwp_pre=[lwp_pre, lwp1]
        pwv_pre=[pwv_pre, pwv1]
        julday_mwr_pre=[julday_mwr_pre, julday1]
        rain_flag_pre=[rain_flag_pre,rain_flag1]
      endelse
      
      endfor
      
  
  smet_files=file_search(sfc_met_dir+'enaaosmetC1.a1.'+months[jj]+'*.*', count=count)


  for j=0,count-1 do begin

    cdfid=ncdf_open(smet_files[j])
    ;cdfid=ncdf_open(radar_path+radar_file,/nowrite)

    x_id=ncdf_varid(cdfid, 'base_time') & ncdf_varget,cdfid,x_id,base_time
    x_id=ncdf_varid(cdfid, 'time_offset') & ncdf_varget,cdfid,x_id,time_offset
    x_id=ncdf_varid(cdfid, 'wind_speed')
    if x_id gt 0. then begin
      ncdf_varget,cdfid,x_id,wind_speed1
      x_id=ncdf_varid(cdfid, 'wind_direction') & ncdf_varget,cdfid,x_id,wind_dir1
    endif else begin
      x_id=ncdf_varid(cdfid, 'WindDirection') & ncdf_varget,cdfid,x_id,wind_dir1
      x_id=ncdf_varid(cdfid, 'WindSpeed') & ncdf_varget,cdfid,x_id,wind_speed1
    endelse
    ncdf_close, cdfid

    ; subsample the met data
    for kk=0,n_elements(time_offset),25 do begin
      if kk lt n_elements(time_offset)-1 then begin
        if kk eq 0 then begin
          time_offset_temp=time_offset[kk]
          wind_dir_temp=wind_dir1[kk]
          wind_speed_temp=wind_speed1[kk]
        endif else begin
          time_offset_temp=[time_offset_temp,time_offset[kk]]
          wind_dir_temp=[wind_dir_temp,wind_dir1[kk]]
          wind_speed_temp=[wind_speed_temp,wind_speed1[kk]]
        endelse
      endif
    endfor
    time_offset=time_offset_temp
    wind_dir1=wind_dir_temp
    wind_speed1=wind_speed_temp

    julday1=jday1+((double(base_time)+time_offset)/86400.d)

    if n_elements(julday_smet_pre) eq 0 then begin
      julday_smet_pre=julday1
      wind_speed_pre=wind_speed1
      wind_dir_pre=wind_dir1
    endif else begin
      julday_smet_pre=[julday_smet_pre,julday1]
      wind_speed_pre=[wind_speed_pre, wind_speed1]
      wind_dir_pre=[wind_dir_pre, wind_dir1]
    endelse

  endfor

endfor  ; for jj=0,n_elements(months)-1 do begin
  
  
;  wdir_mwr_pre=fltarr(n_elements(julday_mwr_pre)) & wdir_mwr_pre[*]=-9999.
;  wspd_mwr_pre=fltarr(n_elements(julday_mwr_pre)) & wspd_mwr_pre[*]=-9999.
;  
;  for j=0,n_elements(julday_mwr_pre)-1 do begin
;    if lwp_pre[j] gt 0.0 and rain_flag_pre[j] eq 0. then begin
;    index=where(abs(julday_mwr_pre[j]-julday_smet_pre) eq min(abs(julday_mwr_pre[j]-julday_smet_pre)))
;    if abs(julday_mwr_pre[j]-julday_smet_pre[index[0]]) lt 0.01 then begin
;      wdir_mwr_pre[j]=wind_dir_pre[index[0]]
;      wspd_mwr_pre[j]=wind_speed_pre[index[0]]
;    endif
;    endif
;  endfor

  
  months=['202106','202107','202108','202109',$
    '202206','202207','202208','202209',$
    '202306','202307','202308','202309']

   ; get the post mwr data
   first_flag=1
  for jj=0,n_elements(months)-1 do begin

    mwr_files=file_search(mwr_path+'enamwr3cC1.b1.'+months[jj]+'*.*', count=count)

    for j=0,count-1 do begin

      cdfid=ncdf_open(mwr_files[j])
      ;cdfid=ncdf_open(radar_path+radar_file,/nowrite)

      x_id=ncdf_varid(cdfid, 'base_time') & ncdf_varget,cdfid,x_id,base_time
      x_id=ncdf_varid(cdfid, 'time_offset') & ncdf_varget,cdfid,x_id,time_offset
      x_id=ncdf_varid(cdfid, 'lwp') & ncdf_varget,cdfid,x_id,lwp1
      x_id=ncdf_varid(cdfid, 'lwp_err') & ncdf_varget,cdfid,x_id,lwp_err1
      x_id=ncdf_varid(cdfid, 'pwv') & ncdf_varget,cdfid,x_id,pwv1
      x_id=ncdf_varid(cdfid, 'pwv_err') & ncdf_varget,cdfid,x_id,pwv_err1
      x_id=ncdf_varid(cdfid, 'infrared_temperature') & ncdf_varget,cdfid,x_id,infrared_temperature1
      x_id=ncdf_varid(cdfid, 'rain_flag') & ncdf_varget,cdfid,x_id,rain_flag1
      x_id=ncdf_varid(cdfid, 'lat') & ncdf_varget,cdfid,x_id,lat
      x_id=ncdf_varid(cdfid, 'lon') & ncdf_varget,cdfid,x_id,lon
      ncdf_close, cdfid
      
      julday1=jday1+((double(base_time)+time_offset)/86400.d)
      
      if first_flag eq 1 then begin
        lwp_post=lwp1
        pwv_post=pwv1
        julday_mwr_post=julday1
        rain_flag_post=rain_flag1
        first_flag=0
      endif else begin
        lwp_post=[lwp_post, lwp1]
        pwv_post=[pwv_post, pwv1]
        julday_mwr_post=[julday_mwr_post, julday1]
        rain_flag_post=[rain_flag_post,rain_flag1]
      endelse
      
      endfor
      
  
  smet_files=file_search(sfc_met_dir+'enaaosmetC1.a1.'+months[jj]+'*.*', count=count)


  for j=0,count-1 do begin

    cdfid=ncdf_open(smet_files[j])
    ;cdfid=ncdf_open(radar_path+radar_file,/nowrite)

    x_id=ncdf_varid(cdfid, 'base_time') & ncdf_varget,cdfid,x_id,base_time
    x_id=ncdf_varid(cdfid, 'time_offset') & ncdf_varget,cdfid,x_id,time_offset
    x_id=ncdf_varid(cdfid, 'wind_speed')
    if x_id gt 0. then begin
      ncdf_varget,cdfid,x_id,wind_speed1
      x_id=ncdf_varid(cdfid, 'wind_direction') & ncdf_varget,cdfid,x_id,wind_dir1
    endif else begin
      x_id=ncdf_varid(cdfid, 'WindDirection') & ncdf_varget,cdfid,x_id,wind_dir1
      x_id=ncdf_varid(cdfid, 'WindSpeed') & ncdf_varget,cdfid,x_id,wind_speed1
    endelse
    ncdf_close, cdfid

    ; subsample the met data
    for kk=0,n_elements(time_offset),25 do begin
      if kk lt n_elements(time_offset)-1 then begin
        if kk eq 0 then begin
          time_offset_temp=time_offset[kk]
          wind_dir_temp=wind_dir1[kk]
          wind_speed_temp=wind_speed1[kk]
        endif else begin
          time_offset_temp=[time_offset_temp,time_offset[kk]]
          wind_dir_temp=[wind_dir_temp,wind_dir1[kk]]
          wind_speed_temp=[wind_speed_temp,wind_speed1[kk]]
        endelse
      endif
    endfor
    time_offset=time_offset_temp
    wind_dir1=wind_dir_temp
    wind_speed1=wind_speed_temp

    julday1=jday1+((double(base_time)+time_offset)/86400.d)

    if n_elements(julday_smet_post) eq 0 then begin
      julday_smet_post=julday1
      wind_speed_post=wind_speed1
      wind_dir_post=wind_dir1
    endif else begin
      julday_smet_post=[julday_smet_post,julday1]
      wind_speed_post=[wind_speed_post, wind_speed1]
      wind_dir_post=[wind_dir_post, wind_dir1]
    endelse

  endfor

endfor  ; for jj=0,n_elements(months)-1 do begin
  
;wdir_mwr_post=fltarr(n_elements(julday_mwr_post)) & wdir_mwr_post[*]=-9999.
;wspd_mwr_post=fltarr(n_elements(julday_mwr_post)) & wspd_mwr_post[*]=-9999.
;
;for j=0,n_elements(julday_mwr_post)-1 do begin
;  if lwp_post[j] gt 0.0 and rain_flag_post[j] eq 0. then begin
;
;  index=where(abs(julday_mwr_post[j]-julday_smet_post) eq min(abs(julday_mwr_post[j]-julday_smet_post)))
;  if abs(julday_mwr_post[j]-julday_smet_post[index[0]]) lt 0.01 then begin
;    wdir_mwr_post[j]=wind_dir_post[index[0]]
;    wspd_mwr_post[j]=wind_speed_post[index[0]]
;  endif
;  endif
;endfor
;
;i=where(wdir_mwr_pre gt 330 and wdir_mwr_pre lt 360.)
;wdir_mwr_pre[i]=30.
;i=where(wdir_mwr_post gt 330 and wdir_mwr_post lt 360.)
;wdir_mwr_post[i]=30.
;
;i=where(wdir_mwr_pre gt 220. and wdir_mwr_pre lt 250.)
;wdir_mwr_pre[i]=30.
;i=where(wdir_mwr_post gt 220. and wdir_mwr_post lt 250.)
;wdir_mwr_post[i]=30.
;
;  conditions_vec_pre=where(rain_flag_pre eq 0 and lwp_pre gt 0. and wdir_mwr_pre gt 0. and wdir_mwr_pre lt 70. and wspd_mwr_pre gt 2.5)
;  conditions_vec_post=where(rain_flag_post eq 0 and lwp_pre gt 0. and wdir_mwr_post gt 0. and wdir_mwr_post lt 70. and wspd_mwr_post gt 2.5)

  conditions_vec_pre=where(rain_flag_pre eq 0 and lwp_pre gt 20./1.e3)
  conditions_vec_post=where(rain_flag_post eq 0 and lwp_post gt 20./1.e3)

  conditions2_vec_pre=where(rain_flag_pre eq 0 and pwv_pre lt 5. and pwv_pre gt 0. )
  conditions2_vec_post=where(rain_flag_post eq 0 and pwv_post lt 5. and pwv_post gt 0. )
  
  conditions3_vec_pre=where(rain_flag_pre eq 0 and pwv_pre lt 5. and lwp_pre le 0. )
  conditions3_vec_post=where(rain_flag_post eq 0 and pwv_post lt 5. and lwp_post le 0. )

  
;  lin_histo_2, lwp_pre[conditions_vec_pre], lwp_post[conditions_vec_post], 2, 80, lwp_pre_histo1, lwp_post_histo2, lwp_bins, $
;    lwp_pre_moments1, lwp_post_moments2, lwp_pre_med1, lwp_post_med2, num

  lin_histo_2, pwv_pre[conditions3_vec_pre], pwv_post[conditions3_vec_post], 2, 20, pwv_pre_histo1, pwv_post_histo2, pwv_bins, $
    pwv_pre_moments1, pwv_post_moments2, pwv_pre_med1, pwv_post_med2, num 
    
    
    lin_histo_2_logplot, lwp_pre[conditions_vec_pre], lwp_post[conditions_vec_post], 5, 20, lwp_pre_histo1, lwp_post_histo2, lwp_bins, $
    lwp_pre_moments1, lwp_post_moments2, lwp_pre_med1, lwp_post_med2, num, 0.001, 10., 1.5

    
    set_plot, 'Z'
  loadct, 5 & gamma_ct, 1.0 & set_plot, 'Z' & device, set_resolution=[3000,2000] & !p.charsize=3.25 & !p.font=-1 & !p.background=!d.n_colors-1
  top_top_y=0.93 & dy=0.1 & top_y=0.95 & bot_y=top_y-dy & sep_y=0.05
  sx=0.12 & sy=0.06 & xl=0.1 & xr=0.9 & yt=0.95 & yb=0.1
  !p.thick=3. & numplots_x=3 & numplots_y=3
  position_plots,xl,xr,yb,yt,sx,sy,numplots_x,numplots_y,pos
  cbpos=pos & cbpos[*,0]=cbpos[*,2]+0.08 & cbpos[*,2]=cbpos[*,0]+0.012
  !p.multi=[0,4,4]

  pnum=8


  plot, lwp_bins[where(lwp_pre_histo1 gt 0.)], lwp_pre_histo1[where(lwp_pre_histo1 gt 0.)]/float(total(lwp_pre_histo1[where(lwp_pre_histo1 gt 0.)])), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='LWP (mm)', ytitle='Frequency', title='LWP Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.25, charthick=4, /xlog, /ylog ;max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])

  oplot, lwp_bins[where(lwp_post_histo2 gt 0.)],lwp_post_histo2[where(lwp_post_histo2 gt 0.)]/float(total(lwp_post_histo2[where(lwp_post_histo2 gt 0.)])), psym=10, color=100
 
  ;;;;;;;;;  write precip histo data
  cdfid=ncdf_create('/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/LWP_All.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(lwp_bins[where(lwp_pre_histo1 gt 0.)]))
  bins_id=ncdf_vardef(cdfid, 'LWP_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'Liquid Water Path'
  ncdf_attput, cdfid, bins_id, 'units', 'mm'
  pre_id=ncdf_vardef(cdfid, 'lwp_pre_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of lwp of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'lwp_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of lwp of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, lwp_bins[where(lwp_pre_histo1 gt 0.)]
  ncdf_varput, cdfid, pre_id, lwp_pre_histo1[where(lwp_pre_histo1 gt 0.)]
  ncdf_varput, cdfid, post_id, lwp_post_histo2[where(lwp_pre_histo1 gt 0.)]
  ncdf_close, cdfid

  
  pnum=7


  plot, pwv_bins, pwv_pre_histo1/float(total(pwv_pre_histo1)), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='PWV (cm)', ytitle='Frequency', title='PWV Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.25, charthick=4 ;max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])

  oplot, pwv_bins,pwv_post_histo2/float(total(pwv_post_histo2)), psym=10, color=100
  
  ;;;;;;;;;  write precip histo data
  cdfid=ncdf_create('/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/PWV_All.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(lwp_bins))
  bins_id=ncdf_vardef(cdfid, 'pwv_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'Precipitable Water Vapor'
  ncdf_attput, cdfid, bins_id, 'units', 'cm'
  pre_id=ncdf_vardef(cdfid, 'pwv_pre_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of pwv of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'pwv_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of pwv of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, pwv_bins
  ncdf_varput, cdfid, pre_id, pwv_pre_histo1
  ncdf_varput, cdfid, post_id, pwv_post_histo2
  ncdf_close, cdfid

  
  write_gif, '/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/test_mwr_histos.gif',tvrd()


  stop
  end
