function nd_zm_fad_eta, zm, fad, kappa, gamma_l, eta
; Jay Mace October 1, 2022
; this function implments equation 21 of lidar_extinction_constraints_on_Nd.docx and page 12 of notes 8/18/2022 at the top of the page.  
; units are checked on page 11, etc. 
; 
; zm is the distance in meters to the maximum in attenuated backscatter in a cloud when oberved from below. 
; fad is the adiabaticity of the layer (lwp/lwp_adiabatic).
; c1 and c2 are from mace, benson hu, grl 2020 have units of microns in the original constants
; temperature and pressure are assumed to be sent in with units of Kelvins and Pascals
; kappa is the ratio of the volume mean radius to the effective radius.  See Grosvenor et al., 2018 for discussion. 
; gamma_l is the adiabatic condensation rate or cw in Grosvenor et al., 2018.  See also Albrecht et al., 1990. units are kg per cubic meter per meter.  

; first define C3 and C4 that are defined on page2 1 and 2 of the 8/18/2022 notebook
; 

rho_w=1000. ;kg/m3 ; density of liquid water
c1=(169.72d)*(1.d-6)   ; convert to meters
c2=(8.53d)*(1.d-6)  ; convert to meters

c3=(3.d/(2.d*double(rho_w)))*((3.d/(4.d*!dpi*rho_w*kappa))^(-1./3.)) ; c3 has units of (kg^(-2./3))*m^2

c4=((3.d/(4.d*!dpi*rho_w*kappa))^(1./3.)) ; c4 has units of kg^(1/3) * m

c6=c4*((fad*gamma_l)^(1./3.))
c5=-2.*eta*c3*((fad*gamma_l)^(2./3.))  ;  2 eta to c5

term1_of_e1=c6*(c5^2)*(zm^(5./3.))
term2_of_e1=c1*c5*(zm^(-1./3.))

;e1=term1_of_e1-term2_of_e1
e1=term1_of_e1+term2_of_e1


;e2=c1*(c5^2)*(zm^(4./3.))
e2=c1*(c5^2)*(zm^(4./3.))

c9=-(c6*c5)-(c4*c3*gamma_l/3.d)

t1=(sqrt(e1^2-((4.d)*e2*c9)))

;print, ((-e1+t1)/((2.d)*e2))^(3.)/1.e6
;print, ((-e1-t1)/((2.d)*e2))^(3.)/1.e6


return, ((-e1+t1)/((2.d)*e2))^(3.)/1.e6 ; Nd in per cubic centimeter.  1e-6 converts number per cubic meter to per cubic centimeter.
end




