pro nd_oe_forward_model, sfc_temp,sfc_press, base_height, nd, fad, alpha, eta, extinction_output, $
z_max_output, lwp_output, lwc_output, dh,tau_at_extinction_output,re_output,z_top,layer_tau


  ;what to predict: zmax, ext, lwp
  ; what is input: nd, fad, alpha, tau_max, eta, dh

;;;;; this routine calculates the observables for the Nd oe algorithm.    
;;; the observables are 
;Zmax:  the distance from base to the maximum in attenuated backscatter
;extinction: derived from the Li et al. (2011) method
; base_height in meters
; sfc_temp in Kelvins
; sfc_press in pascals
;
;alpha: the shape parameter of the DSD
;tau_max: the optical depth that applies to the extinction derived from Li et al. (2011) method
;eta - the multiple scattering factor 
;dh - layer thickness
;outputs are 
;Nd: cloud droplet number concentration
;Fad: the adiabticity of the cloud layer - says how to distribute LWP from base
; effective radius at the cloud layer top
; See notebook 8/18/2022 page 17
; written by Jay Mace

Rd=287.04d
Rv=461.5d
Lv=2.27d6
g=9.81d  ; m/s2
cp=1003.5d ; j/kg/k   approximate between 250K and 300 K
rho_liquid=1.d6 ; grams per cubic meter

plot_flag=-1

;;;;; first get a sounding to use

output_path='/Users/u0029340/Documents/idl_code/Capricorn_SO/lookup_tables/nd_fad_oe_kx/'

height_profile=0. & while max(height_profile) lt 3000. do height_profile=[height_profile,max(height_profile)+2.]
temp=fltarr(n_elements(height_profile)) & press=fltarr(n_elements(height_profile)) & gamma_m=fltarr(n_elements(height_profile)) & cw=fltarr(n_elements(height_profile))
temp[0]=sfc_temp  & press[0]=sfc_press ; kelvins and pa
for k=1,n_elements(height_profile)-1 do begin
  temp[k]=temp[k-1]-(7.*((height_profile[k]-height_profile[k-1])/1000.))
  press[k]=press[k-1]*exp(-(height_profile[k]-height_profile[k-1])*(9.81/(287.04*temp[k])))
  gamma_m[k]=moist_adiabatic_lapse_rate(Temp[k], 1., press[k]*100.)/1000.d   ; k/m
  cw[k]=(press[k]*100./(287.04*Temp[k]))*(cp/lv)*((9.81/1004.)-gamma_m[k])  ; condensation rate kg/m3/m from Grosvenor et al, 2018 equation 14
endfor

cbh_index=where(abs(height_profile-base_height) eq min(abs(height_profile-base_height))) & cbh_index=cbh_index[0]


;what to predict: zmax, ext, lwp
; what is input: nd, fad, alpha, tau_max, eta, dh


cloud_top=height_profile[cbh_index]+dh
cth_index=where(abs((height_profile-height_profile[cbh_index])-dh) eq min(abs((height_profile-height_profile[cbh_index])-dh))) & cth_index=cth_index[0]
cw_mean=mean(cw[cbh_index:cth_index])
adiab_lwp=(cw_mean*1000.)*0.5*(((dh))^2) ; g per square meter

lwc_profile=fltarr(n_elements(height_profile))
tau_liquid_profile=fltarr(n_elements(height_profile))
ext_profile=fltarr(n_elements(height_profile))
re_cld=fltarr(n_elements(height_profile))
lwp_test=0.
for kk=cbh_index+1,cth_index do begin
  lwc_profile[kk]=(fad*(cw_mean*1000.)*(height_profile[kk]-height_profile[cbh_index]))*1.e-6 ; 1.e3 converts cw from kg/m3/m to g/cm3/m. 1.e-6 converts from to g/cm-3
  lwp_test=lwp_test+(lwc_profile[kk]*1.e6)*(height_profile[kk]-height_profile[kk-1])
  D0=((lwc_profile[kk]/nd)*(gamma(alpha+1.)/gamma(alpha+4.))*(6./!pi))^(1./3.)
  N0=nd/(D0*gamma(alpha+1.))
  ext_profile[kk]=(!pi/2.)*N0*(D0^3.)*gamma(alpha+3.) ; units of inverse cm
  tau_liquid_profile[kk]=tau_liquid_profile[kk-1]+(ext_profile[kk]*1.e2*(height_profile[kk]-height_profile[kk-1])) ; 1.e3 converts inverse cm to inverse meters
  re_cld[kk]=(D0/2.)*(alpha+3.)
endfor

;if adiab_lwp*fad[j] gt 10. and adiab_lwp*fad[j] lt 5000. and nd[i] gt 1. and nd[i] lt 600. then begin
  nd_string=strtrim(string(fix(nd),format='(i3)'),2)
  fad_string=strtrim(string(fix(fad*100.),format='(i3)'),2)
  alpha_string=strtrim(string(fix(alpha),format='(i3)'),2)
  eta_string=strtrim(string(fix(eta*100.),format='(i3)'),2)
  dh_string=strtrim(string(fix(dh),format='(i3)'),2)

  fname='nd_oe_kx_sens_calc_nd'+nd_string+'_fad'+fad_string+'_alpha'+alpha_string+'_eta'+eta_string+'_dh'+dh_string
  z_ln_cor=0.
calculate_lidar_atten_backscatter_profile_liquid_cloud, height_profile, temp, press, tau_liquid_profile, re_cld, ext_profile, lwc_profile, adiab_lwp*fad, nd,$
  eta, cth_index, cbh_index,fname, output_path+'graphics/', plot_flag, fad,tau_at_extinction1,extinction1,nd_per_eta,0.,zmax,const,nd_per_ln,B, $
  z_ln_cor, re_top, gamma_l
  
  ;extinction1=(1.5/rho_liquid)*(adiab_lwp*fad/dh)/(re_top*1.e-6)*1000.

;  calculate_lidar_atten_backscatter_profile_liquid_cloud, height, temp, press, tau_accum_below_liq, re_cld, ext_cld, lwc_cld, lwp_cld, nd_cld,$
;    eta, cld_top_index, cld_base_index,domain_name, file_path, plot_flag, fad,tau_at_extinction,extinction,nd_per_eta,best_delta,mean_depth_to_max,const,nd_per_ln,B, $
;    z_ln_cor, re_top, gamma_l
    if n_elements(zmax) eq 0 then return
    
lwp_output=adiab_lwp*fad
z_max_output=zmax
tau_at_extinction_output=tau_at_extinction1
extinction_output=extinction1
;re_output=re_top  ; this is Wood's re coming out of calculate_lidar_atten_backscatter_profile_liquid_cloud
if extinction1 gt 0. then begin
re_output=median(re_cld[where(re_cld gt median(re_cld))])*1.e4
re_output=max(re_cld)*1.e4
; compute the radar refelectivity from z_top and lwc at cloud top.
z_top=((lwc_profile[cth_index]*1.e6)/rho_liquid)*(48./!pi)*((re_top/1.e6)^3)*((gamma(alpha+7.))/((gamma(alpha+4.))*((alpha+3.)^3)))
z_top=((lwc_profile[cth_index]*1.e6)/rho_liquid)*(48./!pi)*((re_output/1.e6)^3)*((gamma(alpha+7.))/((gamma(alpha+4.))*((alpha+3.)^3)))
lwc_output=max(lwc_profile)*1.e6  ; output in g/m3
layer_tau=max(tau_liquid_profile)
endif else begin
  re_output=-9999.
  z_top=-9999.
  lwc_output=-9999.  ; output in g/m3
  layer_tau=-9999.
endelse
;re_output=median(re_cld[where(re_cld gt median(re_cld))])*1.e4

;print, 10.*alog10((1.e18)*z_top)



return
end


