function nd_dlnbeta_calc, dlnbeta_dz,z,fad, eta, gamma_l,alpha

;routine to calculate nd using method on page 21 and 22 of notes 8/18/2022.  Approach is to use the lidar equation with observed vertical rate of change of
; attenuated backscaatter and assumed subadiabatic profile of lwc.  
; inputs
; dlnbeta_dz is the vertical rate of change of the ln(attenuate backscatter) with units of 1/m
; z is the height in meters where that rate of change is valid
; fad is the adiabaticity of the lwc - unitless
; eta is the multiple scattering factor - unitless 
; gamma_l is the condensation rate for adiabatic ascent in g/m3/m
; alpha is the shape factor of a gamma distribution.
; function returns the cloud droplet number concentrations with units of per cubic cm.
; Jay Mace June 2023.

rho_sqrd=1.e12  ; density of water squared in g/m3
; Calculate constant B
blah=((gamma(alpha+3.))^3.)/(((gamma(alpha+4.))^2)*gamma(alpha+1.))
B=(((9.*!pi)/(2.*(rho_sqrd^(1.))))*blah)^(1./3.)

term1=((0.6667/(z))-dlnbeta_dz)

term2=2.*eta*((gamma_l*z*fad)^(2./3.))*B

Nd=((term1/term2)^(3.))*1.e-6

;(1./((z^(5./3.))*2.*eta*((gamma_l*fad)^(2./3.))*B)^3)*1.e-6

;nd2=(z^(-5.))*((1./(2.*eta*((gamma_l*fad)^(2./3.))*B)^3))*1.e-6

return, Nd
end




