function moist_adiabatic_lapse_rate_jay, temp, rh, pressure

;  temp (K)
;  rh (ratio)
;  pressure (Pa)

;  Gravitational acceleration m s-2
g=9.8076  ; m/s2

;  Latent heat of vaporization J kg-1
Hv=2.5e6  ; j/kg

;  Specific gas constant for dry air  J K-1 kg-1
Rd=287.04 ; j/kg/k

;  Specific gas constant for water vapor J K-1 kg-1
Rw=461.5  ; j/kg/k

;  epsilon, Adiabatic ratio of air
eps=Rd/Rw

;  Specific heat of dry air J kg-1 K-1
cp=1003.5  ;j/kg/k

; what is the mixing ratio
;  goff-gratch equation for the estimate of the 
;  saturation water vapor pressure at a given temperature.  
;  e(s) formula
;  result is in hPa=mb
y=373.16/(temp)
;for f=0,n_elements(y)-1 do begin
;ggel=10.0^((-7.90298)*(y[f]-1.0)+(5.02808)*(alog10(y[f]))-(1.3816e-07)*((10.0^((11.344)*(1.-(1./y[f]))))-1.0)+(8.1328e-03)*((10.0^((-3.49149)*(y[f]-1.0)))-1.0)+alog10(1013.246))
ggel=10.0^((-7.90298)*(y-1.0)+(5.02808)*(alog10(y))-(1.3816e-07)*((10.0^((11.344)*(1.-(1./y))))-1.0)+(8.1328e-03)*((10.0^((-3.49149)*(y-1.0)))-1.0)+alog10(1013.246))
;endfor

;  Saturation vapor pressure in Pa
vapsat=ggel*100. ;convert mb to Pa

;  vapor pressure      rh=e/es
e=rh*vapsat   ;Pa

;  mixing ratio Pa
r=eps*e/(pressure-e)

;  Lapse rate for an ascending saturated air parcel
term1=(1.+((Hv*r)/(Rd*Temp)))
term2=cp+(((Hv^2)*r)/(Rw*Temp^2))

return, g*(term1/term2)*1000.     ; wikipedia ;K cm-1  
end





