function moist_adiabatic_lapse_rate, temp, rh, pressure

g=9.8076  ; m/s2
Hv=2.25e6  ; j/kg
Rd=287.04 ; j/kg/k
Rw=461.5  ; j/kg/k
eps=Rd/Rw
cp=1003.5  ;j/kg/k

; what is the mixing ratio
;goff gratch e(s) formula
y=373.16/(temp)
;for f=0,n_elements(y)-1 do begin
;ggel=10.0^((-7.90298)*(y[f]-1.0)+(5.02808)*(alog10(y[f]))-(1.3816e-07)*((10.0^((11.344)*(1.-(1./y[f]))))-1.0)+(8.1328e-03)*((10.0^((-3.49149)*(y[f]-1.0)))-1.0)+alog10(1013.246))
ggel=10.0^((-7.90298)*(y-1.0)+(5.02808)*(alog10(y))-(1.3816e-07)*((10.0^((11.344)*(1.-(1./y))))-1.0)+(8.1328e-03)*((10.0^((-3.49149)*(y-1.0)))-1.0)+alog10(1013.246))
ggel=6.11*exp((Hv/Rw)*((1./273.)-(1./temp)))

;endfor
vapsat=ggel*100.

e=rh*vapsat

r=eps*e/(pressure-e)

term1=(1.+((Hv*r)/(Rd*Temp)))
term2=cp+(((Hv^2)*r)/(Rw*Temp^2))

return, g*(term1/term2)*1000.     ; wikipedia
end





