function lidar_gas_rayleigh_backscatter_extinction_functionuse, p_in, t, lambda

;, p_in, t, lambda
;p_in=101325.d & t=288.d & lambda=0.5d-6

; assumeing that lambda is input in m, p in pa, t in K.


r=8.314472d ;J·K−1·mol−1 N/V=P/RT

Num=((double(p_in)/(double(r)*double(t))))*(6.0221415d23)

;15 °C, 101 325 Pa
N_stp=((double(101325.)/(double(r)*double(273.+15.))))*(6.0221415d23)

;kg m       s2 k  mol      mol/m3
;s2 m2       kg m2 k

m=1.00027827d  ; refractive index of air

;term1=(146.d)-((lambda/1.e6)^(-2))
;term2=(41.d)-((lambda/1.e6)^(-2))
;
;m2=(1.d)+(((6432.8d)+((2949810.d)/term2)+((25540.d)/term2))/1.d8)

; from Bucholtz eq 4.
oneovlambdasq=(1.d/(lambda*1.e6))^2  ; lambda in microns
term1=5791817.d/(238.0185-oneovlambdasq)
term2=167909.d/(57.362-oneovlambdasq)

m=((term1+term2)/(1.e8))+1.d

term1=((128.d)*(!dpi^5))/((3.d)*(lambda^4))
term2=((3.d)/((4.d)*!dpi*N_stp))
term3=((m^2)-(1.d))/((m^2)+(2.d))

sigma_ext=term1*((term2*term3)^2)

sigma_ext2=(32.d)*(!dpi^3)*((m-1.d)^2)/((3.d)*(lambda^4)*(Num^2))
sigma_ext3=1.05*(24.d)*(!dpi^3)*(((m^2)-1.d)^2)/((((m^2)+2.d)^2)*((lambda*100.)^4)*((Num/1.d6)^2))  ; 1.05 is the Fk term in Table 1.

term4=(0.75d)*((1.d)+((cos(!dpi))^2))/((4.d)*(!dpi))

beta_g=sigma_ext*term4

values=[beta_g*Num,sigma_ext*Num]  ; so units go out as 1/(sr m) and 1/m.

if lambda*1.d6 le 0.5 then begin
  A=3.01577d-28
  B=3.55212d
  C=1.35579d
  D=0.11563d
endif else begin
  A=4.01061D-28
  B=3.99668d
  C=1.10298D-3
  D=2.71393D-2
endelse

term5=(B)+(C*(lambda*1.d6))+(D/(lambda*1.d6))
sigma_fit=A*(lambda*1.e6)^(-term5)

; this result is in good agreement with Bucholtz 1995.
;return, values
;print, values[0], values[1]*1.e3,sigma_ext2*Num*1.e3, (sigma_ext3*(num/1.e6))*1.e5, (sigma_fit*(num/1.e6))*1.d5  ; units of 1/km
return, values  ; units returned in 1/m
end

