pro get_cold_prior_reduced, paths, file_prefixes

common cold_cloud_prior_data, Exy_cc,Exy_pp,Exy_pc,dz_w_dt_accret,dVd_w_dt_accret,dz_ka_dt_accret,dVd_ka_dt_accret,dz_ku_dt_accret,dVd_ku_dt_accret,dz_x_dt_accret,dVd_x_dt_accret,Lx_s, $
  Nx_s,alpha_s,Lx_l,Nx_l,alpha_l,am_s,bm_s,aa_s,ba_s,am_l,bm_l,aa_l,ba_l,mass_precip,re_precip,ext_precip,Nt_precip,precip_rate_precip,mass_cloud,re_cloud,ext_cloud,Nt_cloud, $
  precip_rate_cloud,dbz_convol_w,vd_convol_w,sigma_convol_w,ext_coef_w,atten_dbpkm_w_cloud,ext_coef_w_precip,atten_dbpkm_w_precip,dbz_convol_Ka,vd_convol_Ka,sigma_convol_Ka, $
  ext_coef_Ka_cloud,atten_dbpkm_Ka_cloud,ext_coef_Ka_precip,atten_dbpkm_Ka,dbz_convol_Ku,vd_convol_Ku,sigma_convol_Ku,ext_coef_Ku_cloud,atten_dbpkm_Ku_cloud,ext_coef_Ku_precip, $
  atten_dbpkm_Ku_precip,dbz_convol_X,vd_convol_X,sigma_convol_X,ext_coef_X_cloud,atten_dbpkm_X_cloud,ext_coef_X_precip,atten_dbpkm_X_precip,accretion,aggregation, $
  kk_autocon,kk_accret,j_vec,index_end,altitude,lat,lon,temperature,pressure,time,rh,lwc,w,phase_flag,type,dbz_ku_test_cloud,dbz_ku_test_precip


;paths='/Users/u0029340/Documents/data/RICO/rico/'
;file_prefixes='RICO_PSD_Anal_Process_201904'

if n_elements(paths) ne n_elements(file_prefixes) then stop

plot_flag=1

for path=0,n_elements(paths)-1 do begin ; loop over the number of data sets (field programs)

files=file_search(paths[path]+'*'+file_prefixes[path]+'*.cdf')

start_index=n_elements(w)

for j=0,n_elements(files)-1 do begin  ; read in the flight files

  cdfid=ncdf_open(files[j])
  
  Exy_cc_per_vec_id=ncdf_varid(cdfid, 'Exy_cc_per_vec') & ncdf_varget, cdfid, Exy_cc_per_vec_id, Exy_cc_per_vec
  Exy_pp_per_vec_id=ncdf_varid(cdfid, 'Exy_pp_per_vec') & ncdf_varget, cdfid, Exy_pp_per_vec_id, Exy_pp_per_vec
  Exy_pc_per_vec_id=ncdf_varid(cdfid, 'Exy_pc_per_vec') & ncdf_varget, cdfid, Exy_pc_per_vec_id, Exy_pc_per_vec
  dz_w_dt_accret_vec_id=ncdf_varid(cdfid, 'dz_w_dt_accret_vec') & ncdf_varget, cdfid, dz_w_dt_accret_vec_id, dz_w_dt_accret_vec
  dVd_w_dt_accret_vec_id=ncdf_varid(cdfid, 'dVd_w_dt_accret_vec') & ncdf_varget, cdfid, dVd_w_dt_accret_vec_id, dVd_w_dt_accret_vec
  dz_ka_dt_accret_vec_id=ncdf_varid(cdfid, 'dz_ka_dt_accret_vec') & ncdf_varget, cdfid, dz_ka_dt_accret_vec_id, dz_ka_dt_accret_vec
  dVd_ka_dt_accret_vec_id=ncdf_varid(cdfid, 'dVd_ka_dt_accret_vec') & ncdf_varget, cdfid, dVd_ka_dt_accret_vec_id, dVd_ka_dt_accret_vec
  dz_ku_dt_accret_vec_id=ncdf_varid(cdfid, 'dz_ku_dt_accret_vec') & ncdf_varget, cdfid, dz_ku_dt_accret_vec_id, dz_ku_dt_accret_vec
  dVd_ku_dt_accret_vec_id=ncdf_varid(cdfid, 'dVd_ku_dt_accret_vec') & ncdf_varget, cdfid, dVd_ku_dt_accret_vec_id, dVd_ku_dt_accret_vec
  dz_x_dt_accret_vec_id=ncdf_varid(cdfid, 'dz_x_dt_accret_vec') & ncdf_varget, cdfid, dz_x_dt_accret_vec_id, dz_x_dt_accret_vec
  dVd_x_dt_accret_vec_id=ncdf_varid(cdfid, 'dVd_x_dt_accret_vec') & ncdf_varget, cdfid, dVd_x_dt_accret_vec_id, dVd_x_dt_accret_vec

  Lx_s_per_vec_id=ncdf_varid(cdfid, 'Lx_s_per_vec') & ncdf_varget, cdfid, Lx_s_per_vec_id, Lx_s_per_vec
  Nx_s_per_vec_id=ncdf_varid(cdfid, 'Nx_s_per_vec') & ncdf_varget, cdfid, Nx_s_per_vec_id, Nx_s_per_vec
  alpha_s_per_vec_id=ncdf_varid(cdfid, 'alpha_s_per_vec') & ncdf_varget, cdfid, alpha_s_per_vec_id, alpha_s_per_vec
  Lx_l_per_vec_id=ncdf_varid(cdfid, 'Lx_l_per_vec') & ncdf_varget, cdfid, Lx_l_per_vec_id, Lx_l_per_vec
  Nx_l_per_vec_id=ncdf_varid(cdfid, 'Nx_l_per_vec') & ncdf_varget, cdfid, Nx_l_per_vec_id, Nx_l_per_vec
  alpha_l_per_vec_id=ncdf_varid(cdfid, 'alpha_l_per_vec') & ncdf_varget, cdfid, alpha_l_per_vec_id, alpha_l_per_vec
  am_s_per_vec_id=ncdf_varid(cdfid, 'am_s_per_vec') & ncdf_varget, cdfid, am_s_per_vec_id, am_s_per_vec
  bm_s_per_vec_id=ncdf_varid(cdfid, 'bm_s_per_vec') & ncdf_varget, cdfid, bm_s_per_vec_id, bm_s_per_vec
  aa_s_per_vec_id=ncdf_varid(cdfid, 'aa_s_per_vec') & ncdf_varget, cdfid, aa_s_per_vec_id, aa_s_per_vec
  ba_s_per_vec_id=ncdf_varid(cdfid, 'ba_s_per_vec') & ncdf_varget, cdfid, ba_s_per_vec_id, ba_s_per_vec
  am_l_per_vec_id=ncdf_varid(cdfid, 'am_l_per_vec') & ncdf_varget, cdfid, am_l_per_vec_id, am_l_per_vec
  bm_l_per_vec_id=ncdf_varid(cdfid, 'bm_l_per_vec') & ncdf_varget, cdfid, bm_l_per_vec_id, bm_l_per_vec
  aa_l_per_vec_id=ncdf_varid(cdfid, 'aa_l_per_vec') & ncdf_varget, cdfid, aa_l_per_vec_id, aa_l_per_vec
  ba_l_per_vec_id=ncdf_varid(cdfid, 'ba_l_per_vec') & ncdf_varget, cdfid, ba_l_per_vec_id, ba_l_per_vec
  mass_precip_per_vec_id=ncdf_varid(cdfid, 'mass_precip_per_vec') & ncdf_varget, cdfid, mass_precip_per_vec_id, mass_precip_per_vec
  re_precip_per_vec_id=ncdf_varid(cdfid, 're_precip_per_vec') & ncdf_varget, cdfid, re_precip_per_vec_id, re_precip_per_vec
  ext_precip_per_vec_id=ncdf_varid(cdfid, 'ext_precip_per_vec') & ncdf_varget, cdfid, ext_precip_per_vec_id, ext_precip_per_vec
  Nt_precip_per_vec_id=ncdf_varid(cdfid, 'Nt_precip_per_vec') & ncdf_varget, cdfid, Nt_precip_per_vec_id, Nt_precip_per_vec
  precip_rate_precip_per_vec_id=ncdf_varid(cdfid, 'precip_rate_precip_per_vec') & ncdf_varget, cdfid, precip_rate_precip_per_vec_id, precip_rate_precip_per_vec
  mass_cloud_per_vec_id=ncdf_varid(cdfid, 'mass_cloud_per_vec') & ncdf_varget, cdfid,mass_cloud_per_vec_id, mass_cloud_per_vec
  re_cloud_per_vec_id=ncdf_varid(cdfid, 're_cloud_per_vec') & ncdf_varget, cdfid, re_cloud_per_vec_id, re_cloud_per_vec
  ext_cloud_per_vec_id=ncdf_varid(cdfid, 'ext_cloud_per_vec') & ncdf_varget, cdfid, ext_cloud_per_vec_id, ext_cloud_per_vec
  Nt_cloud_per_vec_id=ncdf_varid(cdfid, 'Nt_cloud_per_vec') & ncdf_varget, cdfid, Nt_cloud_per_vec_id, Nt_cloud_per_vec
  precip_rate_cloud_per_vec_id=ncdf_varid(cdfid, 'precip_rate_cloud_per_vec') & ncdf_varget, cdfid, precip_rate_cloud_per_vec_id, precip_rate_cloud_per_vec

  dbz_convol_w_per_vec_id=ncdf_varid(cdfid, 'dbz_convol_w_per_vec') & ncdf_varget, cdfid, dbz_convol_w_per_vec_id, dbz_convol_w_per_vec
  vd_convol_w_per_vec_id=ncdf_varid(cdfid, 'vd_convol_w_per_vec') & ncdf_varget, cdfid, vd_convol_w_per_vec_id, vd_convol_w_per_vec
  sigma_convol_w_per_vec_id=ncdf_varid(cdfid, 'sigma_convol_w_per_vec') & ncdf_varget, cdfid, sigma_convol_w_per_vec_id, sigma_convol_w_per_vec
  ext_coef_w_cloud_per_vec_id=ncdf_varid(cdfid, 'ext_coef_w_cloud_per_vec') & ncdf_varget, cdfid,   ext_coef_w_cloud_per_vec_id, ext_coef_w_cloud_per_vec
  atten_dbpkm_w_cloud_per_vec_id=ncdf_varid(cdfid, 'atten_dbpkm_w_cloud_per_vec') & ncdf_varget, cdfid, atten_dbpkm_w_cloud_per_vec_id, atten_dbpkm_w_cloud_per_vec
  ext_coef_w_precip_per_vec_id=ncdf_varid(cdfid, 'ext_coef_w_precip_per_vec') & ncdf_varget, cdfid,   ext_coef_w_precip_per_vec_id, ext_coef_w_precip_per_vec
  atten_dbpkm_w_precip_per_vec_id=ncdf_varid(cdfid, 'atten_dbpkm_w_precip_per_vec') & ncdf_varget, cdfid, atten_dbpkm_w_precip_per_vec_id, atten_dbpkm_w_precip_per_vec

  dbz_convol_Ka_per_vec_id=ncdf_varid(cdfid, 'dbz_convol_Ka_per_vec') & ncdf_varget, cdfid, dbz_convol_Ka_per_vec_id, dbz_convol_Ka_per_vec
  vd_convol_Ka_per_vec_id=ncdf_varid(cdfid, 'vd_convol_Ka_per_vec') & ncdf_varget, cdfid, vd_convol_Ka_per_vec_id, vd_convol_Ka_per_vec
  sigma_convol_Ka_per_vec_id=ncdf_varid(cdfid, 'sigma_convol_Ka_per_vec') & ncdf_varget, cdfid, sigma_convol_Ka_per_vec_id, sigma_convol_Ka_per_vec
  ext_coef_Ka_cloud_per_vec_id=ncdf_varid(cdfid, 'ext_coef_Ka_cloud_per_vec') & ncdf_varget, cdfid,  ext_coef_Ka_cloud_per_vec_id, ext_coef_Ka_cloud_per_vec
  atten_dbpkm_Ka_cloud_per_vec_id=ncdf_varid(cdfid, 'atten_dbpkm_Ka_cloud_per_vec') & ncdf_varget, cdfid,  atten_dbpkm_Ka_cloud_per_vec_id, atten_dbpkm_Ka_cloud_per_vec
  ext_coef_Ka_precip_per_vec_id=ncdf_varid(cdfid, 'ext_coef_Ka_precip_per_vec') & ncdf_varget, cdfid,  ext_coef_Ka_precip_per_vec_id, ext_coef_Ka_precip_per_vec
  atten_dbpkm_Ka_precip_per_vec_id=ncdf_varid(cdfid, 'atten_dbpkm_Ka_precip_per_vec') & ncdf_varget, cdfid,  atten_dbpkm_Ka_precip_per_vec_id, atten_dbpkm_Ka_precip_per_vec

  dbz_convol_Ku_per_vec_id=ncdf_varid(cdfid, 'dbz_convol_Ku_per_vec') & ncdf_varget, cdfid, dbz_convol_Ku_per_vec_id, dbz_convol_Ku_per_vec
  vd_convol_Ku_per_vec_id=ncdf_varid(cdfid, 'vd_convol_Ku_per_vec') & ncdf_varget, cdfid,     vd_convol_Ku_per_vec_id, vd_convol_Ku_per_vec
  sigma_convol_Ku_per_vec_id=ncdf_varid(cdfid, 'sigma_convol_Ku_per_vec') & ncdf_varget, cdfid, sigma_convol_Ku_per_vec_id, sigma_convol_Ku_per_vec
  ext_coef_Ku_cloud_per_vec_id=ncdf_varid(cdfid, 'ext_coef_Ku_cloud_per_vec') & ncdf_varget, cdfid,  ext_coef_Ku_cloud_per_vec_id, ext_coef_Ku_cloud_per_vec
  atten_dbpkm_Ku_cloud_per_vec_id=ncdf_varid(cdfid, 'atten_dbpkm_Ku_cloud_per_vec') & ncdf_varget, cdfid,  atten_dbpkm_Ku_cloud_per_vec_id, atten_dbpkm_Ku_cloud_per_vec
  ext_coef_Ku_precip_per_vec_id=ncdf_varid(cdfid, 'ext_coef_Ku_precip_per_vec') & ncdf_varget, cdfid,  ext_coef_Ku_precip_per_vec_id, ext_coef_Ku_precip_per_vec
  atten_dbpkm_Ku_precip_per_vec_id=ncdf_varid(cdfid, 'atten_dbpkm_Ku_precip_per_vec') & ncdf_varget, cdfid,  atten_dbpkm_Ku_precip_per_vec_id, atten_dbpkm_Ku_precip_per_vec

  dbz_convol_X_per_vec_id=ncdf_varid(cdfid, 'dbz_convol_X_per_vec') & ncdf_varget, cdfid, dbz_convol_X_per_vec_id, dbz_convol_X_per_vec
  vd_convol_X_per_vec_id=ncdf_varid(cdfid, 'vd_convol_X_per_vec') & ncdf_varget, cdfid, vd_convol_X_per_vec_id, vd_convol_X_per_vec
  sigma_convol_X_per_vec_id=ncdf_varid(cdfid, 'sigma_convol_X_per_vec') & ncdf_varget, cdfid,  sigma_convol_X_per_vec_id, sigma_convol_X_per_vec
  ext_coef_X_cloud_per_vec_id=ncdf_varid(cdfid, 'ext_coef_X_cloud_per_vec') & ncdf_varget, cdfid, ext_coef_X_cloud_per_vec_id, ext_coef_X_cloud_per_vec
  atten_dbpkm_X_cloud_per_vec_id=ncdf_varid(cdfid, 'atten_dbpkm_X_cloud_per_vec') & ncdf_varget, cdfid, atten_dbpkm_X_cloud_per_vec_id, atten_dbpkm_X_cloud_per_vec
  ext_coef_X_precip_per_vec_id=ncdf_varid(cdfid, 'ext_coef_X_precip_per_vec') & ncdf_varget, cdfid, ext_coef_X_precip_per_vec_id, ext_coef_X_precip_per_vec
  atten_dbpkm_X_precip_per_vec_id=ncdf_varid(cdfid, 'atten_dbpkm_X_precip_per_vec') & ncdf_varget, cdfid, atten_dbpkm_X_precip_per_vec_id, atten_dbpkm_X_precip_per_vec
  accretion_per_vec_id=ncdf_varid(cdfid, 'accretion_per_vec') & ncdf_varget, cdfid, accretion_per_vec_id, accretion_per_vec
  aggregation_per_vec_id=ncdf_varid(cdfid, 'aggregation_per_vec') & ncdf_varget, cdfid,aggregation_per_vec_id, aggregation_per_vec
  kk_autocon_per_vec_id=ncdf_varid(cdfid, 'kk_autocon_per_vec') & ncdf_varget, cdfid,  kk_autocon_per_vec_id, kk_autocon_per_vec
  kk_accret_per_vec_id=ncdf_varid(cdfid, 'kk_accret_per_vec') & ncdf_varget, cdfid,   kk_accret_per_vec_id, kk_accret_per_vec
  j_vec_id=ncdf_varid(cdfid, 'j_vec') & ncdf_varget, cdfid, j_vec_id, j_vec_in
  index_end_id=ncdf_varid(cdfid, 'index_end') & ncdf_varget, cdfid, index_end_id, index_end_in
  altitude_vec_vec_id=ncdf_varid(cdfid, 'altitude_vec_vec') & ncdf_varget, cdfid, altitude_vec_vec_id, altitude_vec_vec
  lat_vec_vec_id=ncdf_varid(cdfid, 'lat_vec_vec') & ncdf_varget, cdfid, lat_vec_vec_id, lat_vec_vec
  lon_vec_vec_id=ncdf_varid(cdfid, 'lon_vec_vec') & ncdf_varget, cdfid, lon_vec_vec_id, lon_vec_vec
  temperature_vec_vec_id=ncdf_varid(cdfid, 'temperature_vec_vec') & ncdf_varget, cdfid, temperature_vec_vec_id, temperature_vec_vec
  pressure_vec_vec_id=ncdf_varid(cdfid, 'pressure_vec_vec') & ncdf_varget, cdfid, pressure_vec_vec_id, pressure_vec_vec
  time_vec_vec_id=ncdf_varid(cdfid, 'time_vec_vec') & ncdf_varget, cdfid, time_vec_vec_id, time_vec_vec
  rh_vec_vec_id=ncdf_varid(cdfid, 'rh_vec_vec') & ncdf_varget, cdfid, rh_vec_vec_id, rh_vec_vec
  ;iwc_cvi_vec_vec_id=ncdf_varid(cdfid, 'iwc_cvi_vec_vec') & ncdf_varget, cdfid, iwc_cvi_vec_vec_id, iwc_cvi_vec_vec
  lwc_vec_vec_id=ncdf_varid(cdfid, 'lwc_vec_vec') & ncdf_varget, cdfid, lwc_vec_vec_id, lwc_vec_vec
  w_vec_vec_id=ncdf_varid(cdfid, 'w_vec_vec') & ncdf_varget, cdfid,  w_vec_vec_id, w_vec_vec
  phase_flag_vec_id=ncdf_varid(cdfid, 'phase_flag_vec') & ncdf_varget, cdfid, phase_flag_vec_id, phase_flag_vec
  type_vec_id=ncdf_varid(cdfid, 'type_vec') & ncdf_varget, cdfid, type_vec_id, type_vec
  dbz_test_cloud_vec_id=ncdf_varid(cdfid, 'dbz_ku_test_cloud_vec') & ncdf_varget, cdfid, dbz_test_cloud_vec_id, dbz_test_cloud_vec
  dbz_test_precip_vec_id=ncdf_varid(cdfid, 'dbz_ku_test_precip_vec') & ncdf_varget, cdfid, dbz_test_precip_vec_id, dbz_test_precip_vec
  

if path eq 0 and j eq 0 then begin
  
  Exy_cc=reform(Exy_cc_per_vec)
  Exy_pp=reform(Exy_pp_per_vec)
  Exy_pc=reform(Exy_pc_per_vec)
  dz_w_dt_accret=reform(dz_w_dt_accret_vec)
  dVd_w_dt_accret=reform(dVd_w_dt_accret_vec)
  dz_ka_dt_accret=reform(dz_ka_dt_accret_vec)
  dVd_ka_dt_accret=reform(dVd_ka_dt_accret_vec)
  dz_ku_dt_accret=reform(dz_ku_dt_accret_vec)
  dVd_ku_dt_accret=reform(dVd_ku_dt_accret_vec)
  dz_x_dt_accret=reform(dz_x_dt_accret_vec)
  dVd_x_dt_accret=reform(dVd_x_dt_accret_vec)

  Lx_s=reform(Lx_s_per_vec)
  Nx_s=reform(Nx_s_per_vec)
  alpha_s=reform(alpha_s_per_vec)
  Lx_l=reform( Lx_l_per_vec)
  Nx_l=reform(Nx_l_per_vec)
  alpha_l=reform(alpha_l_per_vec)
  am_s=reform(am_s_per_vec)
  bm_s=reform(bm_s_per_vec)
  aa_s=reform(aa_s_per_vec)
  ba_s=reform(ba_s_per_vec)
  am_l=reform(am_l_per_vec)
  bm_l=reform(bm_l_per_vec)
  ;print, 'precip ice in prior ',n_elements(where(bm_l_per_vec lt 3. and bm_l_per_vec gt 0.)), n_elements(bm_l_per_vec)

  aa_l=reform(aa_l_per_vec)
  ba_l=reform(ba_l_per_vec)
  mass_precip=reform(mass_precip_per_vec)
  re_precip=reform(re_precip_per_vec)
  ext_precip=reform(ext_precip_per_vec)
  Nt_precip=reform(Nt_precip_per_vec)
  precip_rate_precip=reform(precip_rate_precip_per_vec)
  mass_cloud=reform(mass_cloud_per_vec)
  re_cloud=reform(re_cloud_per_vec)
  ext_cloud=reform(ext_cloud_per_vec)
  Nt_cloud=reform(Nt_cloud_per_vec)
  precip_rate_cloud=reform(precip_rate_cloud_per_vec)

  dbz_convol_w=reform(dbz_convol_w_per_vec)
  vd_convol_w=reform(vd_convol_w_per_vec)
  sigma_convol_w=reform(sigma_convol_w_per_vec)
  ext_coef_w=reform(ext_coef_w_cloud_per_vec)
  atten_dbpkm_w_cloud=reform(atten_dbpkm_w_cloud_per_vec)
  ext_coef_w_precip=reform(ext_coef_w_precip_per_vec)
  atten_dbpkm_w_precip=reform(atten_dbpkm_w_precip_per_vec)

  dbz_convol_Ka=reform(dbz_convol_Ka_per_vec)
  vd_convol_Ka=reform(vd_convol_Ka_per_vec)
  sigma_convol_Ka=reform(sigma_convol_Ka_per_vec)
  ext_coef_Ka_cloud=reform(ext_coef_Ka_cloud_per_vec)
  atten_dbpkm_Ka_cloud=reform(atten_dbpkm_Ka_cloud_per_vec)
  ext_coef_Ka_precip=reform(ext_coef_Ka_precip_per_vec)
  atten_dbpkm_Ka=reform(atten_dbpkm_Ka_precip_per_vec)

  dbz_convol_Ku=reform(dbz_convol_Ku_per_vec)
  vd_convol_Ku=reform(vd_convol_Ku_per_vec)
  sigma_convol_Ku=reform(sigma_convol_Ku_per_vec)
  ext_coef_Ku_cloud=reform(ext_coef_Ku_cloud_per_vec)
  atten_dbpkm_Ku_cloud=reform(atten_dbpkm_Ku_cloud_per_vec)
  ext_coef_Ku_precip=reform(ext_coef_Ku_precip_per_vec)
  atten_dbpkm_Ku_precip=reform(atten_dbpkm_Ku_precip_per_vec)

  dbz_convol_X=reform(dbz_convol_X_per_vec)
  vd_convol_X=reform(vd_convol_X_per_vec)
  sigma_convol_X=reform(sigma_convol_X_per_vec)
  ext_coef_X_cloud=reform(ext_coef_X_cloud_per_vec)
  atten_dbpkm_X_cloud=reform(atten_dbpkm_X_cloud_per_vec)
  ext_coef_X_precip=reform(ext_coef_X_precip_per_vec)
  atten_dbpkm_X_precip=reform(atten_dbpkm_X_precip_per_vec)
  accretion=reform(accretion_per_vec)
  aggregation=reform(aggregation_per_vec)
  kk_autocon=reform(kk_autocon_per_vec)
  kk_accret=reform(kk_accret_per_vec)
  j_vec=reform(j_vec_in)
  index_end=reform(index_end_in)
  altitude=reform(altitude_vec_vec)
  lat=reform(lat_vec_vec)
  lon=reform(lon_vec_vec)
  temperature=reform(temperature_vec_vec)
  pressure=reform(pressure_vec_vec)
  time=reform(time_vec_vec)
  rh=reform(rh_vec_vec)
  ;iwc_cvi_vec_vec_id=reform(ncdf_varid(cdfid, 'iwc_cvi_vec_vec') & ncdf_varget, cdfid, iwc_cvi_vec_vec_id, iwc_cvi_vec_vec
  lwc=reform(lwc_vec_vec)
  w=reform(w_vec_vec)
  phase_flag=reform(phase_flag_vec)
  type=reform(type_vec)
  dbz_ku_test_cloud=reform(dbz_test_cloud_vec)
  dbz_ku_test_precip=reform(dbz_test_precip_vec)
  
endif else begin
  
  
  Exy_cc=[Exy_cc,reform(Exy_cc_per_vec)]
  Exy_pp=[Exy_pp,reform(Exy_pp_per_vec)]
  Exy_pc=[Exy_pc,reform(Exy_pc_per_vec)]
  dz_w_dt_accret=[dz_w_dt_accret,reform(dz_w_dt_accret_vec)]
  dVd_w_dt_accret=[dVd_w_dt_accret,reform(dVd_w_dt_accret_vec)]
  dz_ka_dt_accret=[dz_ka_dt_accret,reform(dz_ka_dt_accret_vec)]
  dVd_ka_dt_accret=[dVd_ka_dt_accret,reform(dVd_ka_dt_accret_vec)]
  dz_ku_dt_accret=[dz_ku_dt_accret,reform(dz_ku_dt_accret_vec)]
  dVd_ku_dt_accret=[dVd_ku_dt_accret,reform(dVd_ku_dt_accret_vec)]
  dz_x_dt_accret=[dz_x_dt_accret,reform(dz_x_dt_accret_vec)]
  dVd_x_dt_accret=[dVd_x_dt_accret,reform(dVd_x_dt_accret_vec)]

  Lx_s=[Lx_s,reform(Lx_s_per_vec)]
  Nx_s=[Nx_s,reform(Nx_s_per_vec)]
  alpha_s=[alpha_s,reform(alpha_s_per_vec)]
  Lx_l= [Lx_l,reform(Lx_l_per_vec)]
  Nx_l=[Nx_l,reform(Nx_l_per_vec)]
  alpha_l=[alpha_l,reform( alpha_l_per_vec)]
  am_s=[am_s,reform(am_s_per_vec)]
  bm_s=[bm_s,reform(bm_s_per_vec)]
  aa_s=[aa_s,reform(aa_s_per_vec)]
  ba_s=[ba_s,reform(ba_s_per_vec)]
  am_l=[am_l,reform(am_l_per_vec)]
  bm_l=[bm_l,reform(bm_l_per_vec)]
  
  aa_l=[aa_l,reform(aa_l_per_vec)]
  ba_l=[ba_l,reform(ba_l_per_vec)]
  mass_precip=[mass_precip,reform( mass_precip_per_vec)]
  re_precip=[re_precip,reform( re_precip_per_vec)]
  ext_precip=[ext_precip,reform( ext_precip_per_vec)]
  Nt_precip=[Nt_precip,reform( Nt_precip_per_vec)]
  precip_rate_precip=[precip_rate_precip,reform(precip_rate_precip_per_vec)]
  mass_cloud=[mass_cloud,reform( mass_cloud_per_vec)]
  re_cloud=[re_cloud,reform( re_cloud_per_vec)]
  ext_cloud=[ext_cloud,reform( ext_cloud_per_vec)]
  Nt_cloud=[Nt_cloud,reform( Nt_cloud_per_vec)]
  precip_rate_cloud=[precip_rate_cloud,reform( precip_rate_cloud_per_vec)]

  dbz_convol_w=[dbz_convol_w,reform( dbz_convol_w_per_vec)]
  vd_convol_w=[vd_convol_w,reform( vd_convol_w_per_vec)]
  sigma_convol_w=[sigma_convol_w,reform( sigma_convol_w_per_vec)]
  ext_coef_w=[ext_coef_w,reform( ext_coef_w_cloud_per_vec)]
  atten_dbpkm_w_cloud=[atten_dbpkm_w_cloud,reform( atten_dbpkm_w_cloud_per_vec)]
  ext_coef_w_precip=[ext_coef_w_precip,reform( ext_coef_w_precip_per_vec)]
  atten_dbpkm_w_precip=[atten_dbpkm_w_precip,reform( atten_dbpkm_w_precip_per_vec)]

  dbz_convol_Ka=[dbz_convol_Ka,reform( dbz_convol_Ka_per_vec)]
  vd_convol_Ka=[vd_convol_Ka,reform( vd_convol_Ka_per_vec)]
  sigma_convol_Ka=[sigma_convol_Ka,reform( sigma_convol_Ka_per_vec)]
  ext_coef_Ka_cloud=[ext_coef_Ka_cloud,reform( ext_coef_Ka_cloud_per_vec)]
  atten_dbpkm_Ka_cloud=[atten_dbpkm_Ka_cloud,reform( atten_dbpkm_Ka_cloud_per_vec)]
  ext_coef_Ka_precip=[ext_coef_Ka_precip,reform( ext_coef_Ka_precip_per_vec)]
  atten_dbpkm_Ka=[atten_dbpkm_Ka,reform( atten_dbpkm_Ka_precip_per_vec)]

  dbz_convol_Ku=[dbz_convol_Ku,reform( dbz_convol_Ku_per_vec)]
  vd_convol_Ku=[vd_convol_Ku,reform( vd_convol_Ku_per_vec)]
  sigma_convol_Ku=[sigma_convol_Ku,reform( sigma_convol_Ku_per_vec)]
  ext_coef_Ku_cloud=[ext_coef_Ku_cloud,reform( ext_coef_Ku_cloud_per_vec)]
  atten_dbpkm_Ku_cloud=[atten_dbpkm_Ku_cloud,reform( atten_dbpkm_Ku_cloud_per_vec)]
  ext_coef_Ku_precip=[ext_coef_Ku_precip,reform( ext_coef_Ku_precip_per_vec)]
  atten_dbpkm_Ku_precip=[atten_dbpkm_Ku_precip,reform( atten_dbpkm_Ku_precip_per_vec)]

  dbz_convol_X=[dbz_convol_X,reform( dbz_convol_X_per_vec)]
  vd_convol_X=[vd_convol_X,reform( vd_convol_X_per_vec)]
  sigma_convol_X=[sigma_convol_X,reform( sigma_convol_X_per_vec)]
  ext_coef_X_cloud=[ext_coef_X_cloud,reform( ext_coef_X_cloud_per_vec)]
  atten_dbpkm_X_cloud=[atten_dbpkm_X_cloud,reform( atten_dbpkm_X_cloud_per_vec)]
  ext_coef_X_precip=[ext_coef_X_precip,reform( ext_coef_X_precip_per_vec)]
  atten_dbpkm_X_precip=[atten_dbpkm_X_precip,reform( atten_dbpkm_X_precip_per_vec)]
  accretion=[accretion,reform( accretion_per_vec)]
  aggregation=[aggregation,reform( aggregation_per_vec)]
  kk_autocon=[kk_autocon,reform( kk_autocon_per_vec)]
  kk_accret=[kk_accret,reform( kk_accret_per_vec)]
  j_vec=[j_vec,reform( j_vec_in)]
  index_end=[index_end,reform( index_end_in)]
  altitude=[altitude,reform( altitude_vec_vec)]
  lat=[lat,reform( lat_vec_vec)]
  lon=[lon,reform( lon_vec_vec)]
  temperature=[temperature,reform( temperature_vec_vec)]
  pressure=[pressure,reform( pressure_vec_vec)]
  time=[time,reform( time_vec_vec)]
  rh=[rh,reform( rh_vec_vec)]
  ;iwc_cvi_vec_vec_id=ncdf_varid(cdfid,reform( 'iwc_cvi_vec_vec') & ncdf_varget,reform( cdfid,reform( iwc_cvi_vec_vec_id,reform( iwc_cvi_vec_vec
  lwc=[lwc,reform( lwc_vec_vec)]
  w=[w,reform( w_vec_vec)]
  phase_flag=[phase_flag,reform(phase_flag_vec)]
  type=[type,reform( type_vec)]
  dbz_ku_test_cloud=[dbz_ku_test_cloud,reform( dbz_test_cloud_vec)]
  dbz_ku_test_precip=[dbz_ku_test_precip,reform( dbz_test_precip_vec)]
  
  end_index=n_elements(time)-1
  
endelse

endfor

print, 'precip ice in prior ',n_elements(where(bm_l lt 3. and bm_l gt 0.)), n_elements(bm_l), float(n_elements(where(bm_l lt 3. and bm_l gt 0.)))/float(n_elements(bm_l))

plot_flag=-1
if plot_flag eq 1 then begin
; plot the data

set_plot, 'Z'
device, set_resolution=[2600,2400]
device, set_resolution=[2600,2400]

loadct, 5
!p.background=!d.n_colors-1
!p.charsize=2.0
!p.multi=[0,4,4] ;& cloud_psd_cloud=cloud_psd_cloud_sim[*,jjj] & cloud_psd_precip=cloud_psd_precip_sim[*,jjj]

n_sig=3 & n_bins=15

nt_cloud_vec2=reform(Nt_cloud[start_index:end_index])

log_histo, nt_cloud_vec2, n_sig, n_bins, histo, bins, moments, med

plot, bins, histo/total(histo), color=0,xtitle='log(Nt cloud 1/cm3)',ytitle='Freq',$
  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=10, title='Cloud Number'


iwc_cloud_vec2=reform(mass_cloud[start_index:end_index])

log_histo, iwc_cloud_vec2*1.e6, n_sig, n_bins, histo, bins, moments, med

plot, bins, histo/total(histo), color=0,xtitle='log(lwc g/m3)',ytitle='Freq',$
  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=10, title='cloud mass'

re_cloud_vec2=reform(re_cloud[start_index:end_index])

n_sig=1

lin_histo, re_cloud_vec2*1.e4, n_sig, n_bins, histo, bins, moments, med

plot, bins, histo/total(histo), color=0,xtitle='effective radius (microns)',ytitle='Freq',$
  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=10, title='Cloud Eff. Rad.'

precip_rate=reform(precip_rate_precip[start_index:end_index]) ;where(bm_l_per_vec[0,*] lt 3. and precip_rate_precip_per_vec[0,*] gt 0. )
n_sig=3
log_histo, precip_rate*864000., n_sig, n_bins, histo, bins, moments, med

plot, bins, histo/total(histo), color=0,xtitle='log(precip rate mm/day)',ytitle='Freq',$
  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=10, title='Ice Precip Rate'

temp_vec2=reform(temperature[start_index:end_index])

n_sig=1

lin_histo, temp_vec2, n_sig, n_bins, histo, bins, moments, med

plot, bins, histo/total(histo), color=0,xtitle='Temperature (K)',ytitle='Freq',$
  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=10, title='Temperature'

pressure_vec2=reform(pressure[start_index:end_index])

n_sig=1

lin_histo, pressure_vec2, n_sig, n_bins, histo, bins, moments, med

plot, bins, histo/total(histo), color=0,xtitle='Pressure (mb)',ytitle='Freq',$
  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=10, title='Air Pressure'

rh_vec2=reform(rh[start_index:end_index])

n_sig=1

lin_histo, rh_vec2, n_sig, n_bins, histo, bins, moments, med

plot, bins, histo/total(histo), color=0,xtitle='RH (%)',ytitle='Freq',$
  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=10, title='Rh'

;if n_elements(iwc_cvi_vec_vec) eq 0 then begin
;  iwc_cvi_vec_vec=fltarr(n_elements(j_vec))
;  for j=0,n_elements(j_vec)-1 do begin
;
;    if bm_s_per_vec[0,j] lt 3. then begin
;      iwc_cvi_vec_vec[j]=((Nx_s_per_vec[0,j])*(am_s_per_vec[0,j])*((Lx_s_per_vec[0,j])^((bm_s_per_vec[0,j])+1.))*(gamma((alpha_s_per_vec[0,j])+(bm_s_per_vec[0,j])+1.)))
;    endif
;    if bm_l_per_vec[0,j] lt 3. then begin
;      iwc_cvi_vec_vec[j]=iwc_cvi_vec_vec[j]+((Nx_l_per_vec[0,j])*(am_l_per_vec[0,j])*((Lx_l_per_vec[0,j])^((bm_l_per_vec[0,j])+1.))*(gamma((alpha_l_per_vec[0,j])+(bm_l_per_vec[0,j])+1.)))
;    endif
;  endfor
;
;endif
;if field_program_name ne 'RICO' and field_program_name ne 'IPHEX' then begin
;  iwc_clh=reform(iwc_cvi_vec_vec[where(iwc_cvi_vec_vec gt 0.)])
;  n_sig=3
;  log_histo, iwc_clh*1.e6, n_sig, n_bins, histo, bins, moments, med
;
;  plot, bins, histo/total(histo), color=0,xtitle='log(CLH iwc g/m3)',ytitle='Freq',$
;    thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=10, title='CLH IWC'
;
;
;  accret_ice=reform(accretion_per_vec[0,*])
;  n_sig=3
;  log_histo, accret_ice*3600.e9, n_sig, n_bins, histo, bins, moments, med
;
;  plot, bins, histo/total(histo), color=0,xtitle='log(accretion g/m2 per km per hour)',ytitle='Freq',$
;    thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=10, title='accretion'
;endif
;if field_program_name ne 'TC4' then begin
  lwc_gerb=reform(lwc[where(lwc gt 0.)])*1.e6
  n_sig=3
  log_histo, lwc_gerb, n_sig, n_bins, histo, bins, moments, med

  plot, bins, histo/total(histo), color=0,xtitle='log(Gerber LWC g/m3)',ytitle='Freq',$
    thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=10, title='LWC'
;endif

w_vec2=reform(w[*])

n_sig=1

lin_histo, w*100., n_sig, n_bins, histo, bins, moments, med

plot, bins, histo/total(histo), color=0,xtitle='w (m/s)',ytitle='Freq',$
  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=10, title='vertical motion'


dbz_w_vec2=reform(dbz_convol_w[start_index:end_index])
dbz_Ka_vec2=reform(dbz_convol_Ka[start_index:end_index])
dbz_Ku_vec2=reform(dbz_convol_Ku[start_index:end_index])
dbz_X_vec2=reform(dbz_convol_X[start_index:end_index])

n_sig=1

lin_histo_4, dbz_w_vec2, dbz_ka_vec2, dbz_Ku_vec2, dbz_X_vec2, n_sig, n_bins, histo1, histo2, histo3, histo4, bins, $
  moments1, moments2, moments3, moments4, med1, med2, med3, med4,4

plot, bins, histo1/total(histo1), color=0,xtitle='dBZe',ytitle='Freq',$
  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=10, title='radar reflectivity (w-blk, )'

oplot, bins+1., histo2/total(histo2), color=30, thick=2, psym=10
oplot, bins+2.0, histo3/total(histo3), color=100, thick=2, psym=10
oplot, bins+3., histo4/total(histo4), color=200, thick=4, psym=10

Vd_w_vec2=reform(Vd_convol_w[start_index:end_index])
Vd_Ka_vec2=reform(Vd_convol_Ka[start_index:end_index])  ;where(bm_s_per_vec[0,*] eq 3. and bm_l_per_vec[0,*] lt 3.)
Vd_Ku_vec2=reform(Vd_convol_Ku[start_index:end_index])
Vd_X_vec2=reform(Vd_convol_X[start_index:end_index])

n_sig=1

lin_histo_4, Vd_w_vec2, Vd_ka_vec2, Vd_Ku_vec2, Vd_X_vec2, n_sig, n_bins, histo1, histo2, histo3, histo4, bins, $
  moments1, moments2, moments3, moments4, med1, med2, med3, med4, 4

plot, bins, histo1/total(histo1), color=0,xtitle='Vd (cm/s)',ytitle='Freq',$
  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=10, title='Doppler Vel (w-blk, )'

oplot, bins, histo2/total(histo2), color=30, thick=2, psym=10
oplot, bins, histo3/total(histo3), color=100, thick=2, psym=10
oplot, bins, histo4/total(histo4), color=150, thick=4, psym=10

sigma_w_vec2=reform(sigma_convol_w[start_index:end_index])
sigma_Ka_vec2=reform(sigma_convol_Ka[start_index:end_index])
sigma_Ku_vec2=reform(sigma_convol_Ku[start_index:end_index])
sigma_X_vec2=reform(sigma_convol_X[start_index:end_index])

n_sig=1

write_gif, paths[path]+file_prefix+'_histos.gif', tvrd()

;;;;;;;;;;;;;;; plot vertical profiles

; create a set of basic plots - ice only

;set_plot, 'Z'
;device, set_resolution=[2600,2400]
;
;loadct, 5
;!p.background=!d.n_colors-1
;!p.charsize=2.0
;!p.multi=[0,4,4] ;& cloud_psd_cloud=cloud_psd_cloud_sim[*,jjj] & cloud_psd_precip=cloud_psd_precip_sim[*,jjj]
;
;;n_sig=3 & n_bins=15
;;
;;nt_cloud_vec2=reform(Nt_cloud_per_vec[0,*])
;;
;;log_histo, nt_cloud_vec2, n_sig, n_bins, histo, bins, moments, med
;
;plot, lon_vec_vec, lat_vec_vec, color=0, xtitle='longitude', ytitle='latitude', thick=3, charsize=4.0, $
;  charthick=2, xthick=3, ythick=3, psym=2, title='Horizongal Position', xrange=[-128,-121], yrange=[40.,55.]
;
;plot, time_vec_vec-time_vec_vec[0], altitude_vec_vec, color=0, xtitle='time (s)', ytitle='height (s)', thick=3, charsize=4.0, $
;  charthick=2, xthick=3, ythick=3, psym=2, title='Vertical Position'
;
;
;plot_vector=nt_cloud_per_vec[0,*]
;
;plot, plot_vector[where(plot_vector gt 0.)], altitude_vec_vec[where(plot_vector gt 0.)], color=0,xtitle='Nt cloud (1/cm3)',ytitle='Height (m)',$
;  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=2, title='Cloud Number (1/cm3)', /xlog
;
;
;
;;iwc_cloud_vec2=reform(mass_cloud_per_vec[0,*])
;;
;;log_histo, iwc_cloud_vec2*1.e6, n_sig, n_bins, histo, bins, moments, med
;
;plot_vector=mass_cloud_per_vec[0,*]*1.e9
;
;plot, plot_vector[where(plot_vector gt 0.)], altitude_vec_vec[where(plot_vector gt 0.)], color=0,xtitle='condensed water (mg/m3)',ytitle='Height (m)',$
;  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=2, title='condensed mass', /xlog
;
;;re_cloud_vec2=reform(re_cloud_per_vec[0,*])
;;
;;n_sig=1
;;
;;lin_histo, re_cloud_vec2*1.e4, n_sig, n_bins, histo, bins, moments, med
;
;plot_vector=re_cloud_per_vec[0,*]*1.e4
;
;plot, plot_vector[where(plot_vector gt 0. and re_cloud_per_vec[0,*] ne re_precip_per_vec[0,*])], $
;  altitude_vec_vec[where(plot_vector gt 0. and re_cloud_per_vec[0,*] ne re_precip_per_vec[0,*])], color=0,xtitle='effective radius (microns)',ytitle='Height (m)',$
;  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=2, title='Cloud Eff. Rad.'
;
;
;
;plot_vector=re_precip_per_vec[0,*]*1.e4
;
;plot, plot_vector[where(plot_vector gt 0.)], altitude_vec_vec[where(plot_vector gt 0.)], color=0,xtitle='effective radius (microns)',ytitle='Height (m)',$
;  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=2, title='Precip Eff. Rad.'
;
;;precip_rate=reform(precip_rate_precip_per_vec[0,*]) ;where(bm_l_per_vec[0,*] lt 3. and precip_rate_precip_per_vec[0,*] gt 0. )
;;n_sig=3
;;log_histo, precip_rate*864000., n_sig, n_bins, histo, bins, moments, med
;
;
;plot_vector=precip_rate_precip_per_vec[0,*]*864000.
;
;plot, plot_vector[where(plot_vector gt 0.)], altitude_vec_vec[where(plot_vector gt 0.)], color=0,xtitle='precip rate (mm/day)',ytitle='Height (m)',$
;  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=2, title='Ice Precip Rate', /xlog
;
;
;;temp_vec2=reform(temperature_vec_vec[where(temperature_vec_vec gt 0.)])
;;
;;n_sig=1
;;
;;lin_histo, temp_vec2, n_sig, n_bins, histo, bins, moments, med
;
;plot_vector=temperature_vec_vec
;
;plot, plot_vector[where(plot_vector gt 0.)], altitude_vec_vec[where(plot_vector gt 0.)], color=0,xtitle='Temperature (K)',ytitle='Height (m)',$
;  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=2, title=' Temperature'
;
;;pressure_vec2=reform(pressure_vec_vec[where(temperature_vec_vec gt 0.)])
;;
;;n_sig=1
;;
;;lin_histo, pressure_vec2, n_sig, n_bins, histo, bins, moments, med
;
;plot_vector=pressure_vec_vec
;
;plot, plot_vector[where(plot_vector gt 0.)], altitude_vec_vec[where(plot_vector gt 0.)], color=0,xtitle='Pressure (mb)',ytitle='Height (m)',$
;  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=2, title='Ice cloud Air Pressure'
;
;;rh_vec2=reform(rh_vec_vec[where(temperature_vec_vec gt 0.)])
;;
;;n_sig=1
;;
;;lin_histo, rh_vec2, n_sig, n_bins, histo, bins, moments, med
;
;plot_vector=rh_vec_vec
;
;plot, plot_vector[where(plot_vector gt 0.)], altitude_vec_vec[where(plot_vector gt 0.)], color=0,xtitle='RH (%)',ytitle='Height (m)',$
;  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=2, title='Cloud RH %'
;
;if n_elements(iwc_cvi_vec_vec) eq 0 then begin
;  iwc_cvi_vec_vec=fltarr(n_elements(j_vec))
;  for j=0,n_elements(j_vec)-1 do begin
;
;    if bm_s_per_vec[0,j] lt 3. then begin
;      iwc_cvi_vec_vec[j]=((Nx_s_per_vec[0,j])*(am_s_per_vec[0,j])*((Lx_s_per_vec[0,j])^((bm_s_per_vec[0,j])+1.))*(gamma((alpha_s_per_vec[0,j])+(bm_s_per_vec[0,j])+1.)))
;    endif
;    if bm_l_per_vec[0,j] lt 3. then begin
;      iwc_cvi_vec_vec[j]=iwc_cvi_vec_vec[j]+((Nx_l_per_vec[0,j])*(am_l_per_vec[0,j])*((Lx_l_per_vec[0,j])^((bm_l_per_vec[0,j])+1.))*(gamma((alpha_l_per_vec[0,j])+(bm_l_per_vec[0,j])+1.)))
;    endif
;  endfor
;
;endif
;if field_program_name ne 'RICO' and field_program_name ne 'IPHEX' then begin
;  ;  iwc_clh=reform(iwc_cvi_vec_vec[where(iwc_cvi_vec_vec gt 0.)])
;  ;  n_sig=3
;  ;  log_histo, iwc_clh*1.e6, n_sig, n_bins, histo, bins, moments, med
;
;  plot_vector=iwc_cvi_vec_vec*1.e6
;
;  plot, plot_vector[where(plot_vector gt 0.)], altitude_vec_vec[where(plot_vector gt 0.)], color=0,xtitle=' iwc (g/m3)',ytitle='Height (m)',$
;    thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=2, title=' IWC', /xlog
;
;  ;accret_ice=reform(accretion_per_vec[0,*])
;  ;n_sig=3
;  ;log_histo, accret_ice*3600.e9, n_sig, n_bins, histo, bins, moments, med
;
;  plot_vector=accretion_per_vec[0,*]*3600.e9
;  plot, plot_vector[where(plot_vector gt 0.)], altitude_vec_vec[where(plot_vector gt 0.)], color=0,xtitle='accretion (g/m2 per km per hour)',ytitle='Height (m)',$
;    thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=2, title='accretion', /xlog
;endif
;
;if field_program_name ne 'TC4' then begin
;  ;  lwc_gerb=reform(lwc_vec_vec[where(lwc_vec_vec gt 0.)])*1.e6
;  ;  n_sig=3
;  ;  log_histo, lwc_gerb, n_sig, n_bins, histo, bins, moments, med
;
;  plot_vector=(lwc_vec_vec[where(lwc_vec_vec gt 0.)])
;  plot, plot_vector[where(plot_vector gt 0.)], altitude_vec_vec[where(plot_vector gt 0.)], color=0,xtitle=' LWC (g/m3)',ytitle='Height (m)',$
;    thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=2, title='LWC', /xlog
;endif
;
;;w_vec2=reform(w_vec_vec[*])
;;
;;n_sig=1
;;
;;lin_histo, w_vec2*100., n_sig, n_bins, histo, bins, moments, med
;
;plot_vector=w_vec_vec[*]
;
;plot, plot_vector[where(plot_vector gt -1000.)], altitude_vec_vec[where(plot_vector gt -1000.)], color=0,xtitle='w (cm/s)',ytitle='Height (m)',$
;  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=2, title='vertical motion'
;
;
;dbz_w_vec2=reform(dbz_convol_w_per_vec[0,*])
;dbz_Ka_vec2=reform(dbz_convol_Ka_per_vec[0,*])
;dbz_Ku_vec2=reform(dbz_convol_Ku_per_vec[0,*])
;dbz_X_vec2=reform(dbz_convol_X_per_vec[0,*])
;
;;n_sig=1
;;
;;lin_histo_4, dbz_w_vec2, dbz_ka_vec2, dbz_Ku_vec2, dbz_X_vec2, n_sig, n_bins, histo1, histo2, histo3, histo4, bins, $
;;  moments1, moments2, moments3, moments4, med1, med2, med3, med4,4
;
;plot, dbz_w_vec2[where(dbz_w_vec2 gt -99.)], altitude_vec_vec[where(dbz_w_vec2 gt -99.)], color=0,xtitle='dBZe',ytitle='Height (m)',$
;  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=2, title='radar reflectivity (w-blk, )'
;
;oplot, dbz_ka_vec2[where(dbz_ka_vec2 gt -99.)], altitude_vec_vec[where(dbz_w_vec2 gt -99.)], color=30, thick=2, psym=2
;;oplot, dbz_ku_vec2[where(dbz_ku_vec2 gt -99.)], altitude_vec_vec[where(dbz_w_vec2 gt -99.)], color=100, thick=2, psym=2
;;oplot, bins+3., histo4/total(histo4), color=200, thick=4, psym=10
;
;Vd_w_vec2=reform(Vd_convol_w_per_vec[0,*])
;Vd_Ka_vec2=reform(Vd_convol_Ka_per_vec[0,*])  ;where(bm_s_per_vec[0,*] eq 3. and bm_l_per_vec[0,*] lt 3.)
;Vd_Ku_vec2=reform(Vd_convol_Ku_per_vec[0,*])
;Vd_X_vec2=reform(Vd_convol_X_per_vec[0,*])
;
;;n_sig=1
;;
;;lin_histo_4, Vd_w_vec2, Vd_ka_vec2, Vd_Ku_vec2, Vd_X_vec2, n_sig, n_bins, histo1, histo2, histo3, histo4, bins, $
;;  moments1, moments2, moments3, moments4, med1, med2, med3, med4, 4
;
;plot, Vd_w_vec2[where(dbz_w_vec2 gt -99.)], altitude_vec_vec[where(dbz_w_vec2 gt -99.)], color=0,xtitle='Vd (cm/s)',ytitle='Height (m)',$
;  thick=3, charsize=4.0, charthick=2, xthick=3, ythick=3, psym=2, title='Doppler Vel (w-blk, )'
;
;oplot, Vd_ka_vec2[where(dbz_ka_vec2 gt -99.)], altitude_vec_vec[where(dbz_ka_vec2 gt -99.)], color=30, thick=2, psym=2
;
;
;n_sig=1
;
;
;write_gif, '/Users/u0029340/Documents/idl_code/psd_rs_eval/graphics/'+field_program_name+'_properties_plot1_mixed_vertical'+interval_string+'.gif', tvrd()

endif ; plot_flag

; combine the data sets

endfor

return
end