pro extinction_via_slope_sb,extinction,eta,lidar_bscat_copol_in,lidar_heights_in,$
  sigma_ext,effective_depth,max_index,num_atten,ext_fit,range_gate,profile_num,$
  chsqr,effective_depth_height,lidar_heights_fit,copol_fit, r_atten

extinction=-1.
lidar_dh=lidar_heights_in[2]-lidar_heights_in[1]
num_gates2=fix(0.03/lidar_dh)  ; number of range bins equating to 15 m resolution and 2 ranges bins or 30 m.
num_gates4=fix(0.06/lidar_dh ) ; 4 range bins of 15 m equivalent
num_gates5=fix(0.075/lidar_dh)  ; 5 range bins of 15 m equivalent

; eta is the multiple scattering factor
; lidar_bscat_copol input in 1/km/sr
; lidar_heights input in km
; range gate is in km

;  max_index=the number of gates from cloudbase to the maximum copol
;  effective depth=height above base at which the copol/copol_max falls to exp(-6*eta)
;  extinction=1/(height from copol_max to level of effective depth) 
;  num_atten is the number of gates above max for the signal to attenuate

catch_flag=0
CATCH, Error_status
;This statement begins the error handler:
IF Error_status NE 0 THEN BEGIN
  catch_flag=1
  CATCH, /CANCEL
  return
ENDIF

if catch_flag eq 0 then begin ; put at end

  ;  Restrict this array to positive values
  lidar_bscat_copol=lidar_bscat_copol_in[where(lidar_bscat_copol_in gt 0.)]
  lidar_heights=lidar_heights_in[where(lidar_bscat_copol_in gt 0.)]
  
  ;  Find the max copol level
  ;  Although we are already sending in data starting at max copol so max_index=0
  result=max(lidar_bscat_copol,max_index)
  ;  If the max copol height is more than midway through the cloud, exit
  if lidar_heights[max_index] gt lidar_heights[0]+(lidar_heights[-1]-lidar_heights[0])/2.0 then return

  ;  Go up two gates to get away from signal roll off
  max_index=max_index+num_gates2

  ;  Where is three effective optical depths?
  ;  Loop up until signal decreases to exp(-6.*eta)
  kk=max_index+1
  while lidar_bscat_copol[kk]/lidar_bscat_copol[max_index] gt exp(-6.*eta) and kk lt n_elements(lidar_bscat_copol)-2 do begin 
    kk=kk+1
  endwhile
  ;print,lidar_heights[0],'=lidar_heights0=',lidar_heights[kk],'=lidar_heights[kk]

  ;  Effective depth height
  effective_depth_height=lidar_heights[kk]
  ;  The distance above copol max height at which the copol/copol_max ratio falls to exp(-6*eta)
  effective_depth=lidar_heights[kk]-lidar_heights[max_index]
  ;extinction=1./(lidar_heights[kk]-lidar_heights[max_index])
  ;sigma_ext=0.5*extinction  ; just fix this to 50%

  ;  If there are less than 4 gates, then exit
  if n_elements(lidar_bscat_copol) lt num_gates4 then return

  ;  Error vector
  error_vector=fltarr(n_elements(lidar_bscat_copol[max_index:n_elements(lidar_heights)-1]))
  kk=max_index
  for k=0,n_elements(error_vector)-1 do begin
    if lidar_bscat_copol[kk] ge 0.1 then error_vector[k]=0.1*lidar_bscat_copol[kk]
    if lidar_bscat_copol[kk] lt 0.1 then error_vector[k]=0.25*lidar_bscat_copol[kk]
    if lidar_bscat_copol[kk] lt 0.01 then error_vector[k]=0.5*lidar_bscat_copol[kk]
    if lidar_bscat_copol[kk] lt 0.001 then error_vector[k]=lidar_bscat_copol[kk]
    kk=kk+1
  endfor

  ;  This is the median of the last 6 copol in the array
  noise_sig=median(lidar_bscat_copol[n_elements(lidar_bscat_copol)-6:n_elements(lidar_bscat_copol)-1])+$
    (5.*sqrt(variance(lidar_bscat_copol[n_elements(lidar_bscat_copol)-6:n_elements(lidar_bscat_copol)-1])))
  factor=noise_sig/lidar_bscat_copol[max_index]

  ;  If the next copol up is greater than noise
  ;  Create the data array for applying the linear fit
  if lidar_bscat_copol[max_index]+1 gt factor*lidar_bscat_copol[max_index] then begin ; was 0.1
    ;  Bump max_index up 2 gates 
    ;max_index=max_index+2
    kk=max_index+1
    while lidar_bscat_copol[kk]/lidar_bscat_copol[max_index] gt 0.3 and $
      kk lt n_elements(lidar_bscat_copol)-num_gates2 do kk=kk+1 ; step up until signal starts to drop off
    lidar_heights_fit=lidar_heights[kk]
    copol_fit=alog(lidar_bscat_copol[kk])
    error_vector=abs(0.1*alog(lidar_bscat_copol[kk]))
    kk=kk+1

    while lidar_bscat_copol[kk] gt factor*lidar_bscat_copol[max_index] and $
          kk lt n_elements(lidar_bscat_copol)-num_gates2 do begin ; was 0.05    and n_elements(copol_fit) lt num_gates5
      lidar_heights_fit=[lidar_heights_fit,lidar_heights[kk]]
      copol_fit=[copol_fit,alog(lidar_bscat_copol[kk])]
      error_vector=[error_vector,abs(0.1*alog(lidar_bscat_copol[kk]))]
      
      ; testing this height as the the r2 in the new Nd alg (pg 63 of 8/18/22 notebook)
      if lidar_bscat_copol[kk-1]/lidar_bscat_copol[max_index] gt 0.1 and $
        lidar_bscat_copol[kk]/lidar_bscat_copol[max_index] le 0.1 then r_atten=lidar_heights[kk]
      
      kk=kk+1
      if kk ge n_elements(lidar_bscat_copol)-3 then return
    endwhile
  endif
  catch, /cancel

  catch_flag=0
  CATCH, Error_status
  ;This statement begins the error handler:
  IF Error_status NE 0 THEN BEGIN
    catch_flag=1
    CATCH, /CANCEL
    return
  ENDIF

  if catch_flag eq 0 then begin
    i=linfit(lidar_heights_fit,copol_fit,chisqr=chsqr,yfit=fit_copol,sigma=sig_values)
    ;  Comments about what is in the i vector
    ;slope=i[1]
    ;y_intercept=i[0]  
    ext_fit=i  
  endif ;else begin
  ;ext_fit=[-9999,-9999]  ;ext_fit is initialized before subroutine is called
 
  catch, /cancel

  ;if i[1] lt 0. and chsqr le 0.1 and n_elements(copol_fit) gt 2 then begin
  if i[1] lt 0. and n_elements(copol_fit) gt 2 then begin  
    extinction=i[1]/(-2.*eta)
  
    ;estimate extinction uncertianty
    term1=((-i[1]/(2.*(eta^2)))^2)*((0.15*eta)^2)   ; assuming standard deviation of eta would 15%
    term2=((1./(2.*eta))^2)*sig_values[1]^2

    sigma_ext=sqrt(term1+term2)
  endif
  
  ;if profile_num eq 1140 then begin
  if 0 eq 1 then begin 
    pxdim=1000 & pydim=900
    xl=0.10 & xr=0.96
    yb=0.07 & yt=0.90
    sx=0.06
    sy=0.06
    numplots_x=2
    numplots_y=2
    dx=0.01 & dy=0.01
    position_plots,xl,xr,yb,yt,sx,sy,numplots_x,numplots_y,pos
  
    p0=plot(lidar_bscat_copol[max_index:n_elements(lidar_heights)-1],$
      lidar_heights[max_index:n_elements(lidar_heights)-1],/buffer,$
      dimensions=[pxdim,pydim],position=pos[0,*],/xlog,xtitle='Beta',$
      ytitle='ht',title='slope of lidar signal decay',symbol='o')
    p1=plot([exp(i[0]+(i[1]*lidar_heights[max_index])),exp(i[0]+(i[1]*lidar_heights[n_elements(lidar_heights)-1]))],$
      [lidar_heights[max_index],lidar_heights[n_elements(lidar_heights)-1]],/overplot,color='red',thick=2)  

    p2=plot(lidar_bscat_copol,lidar_heights,/current,position=pos[1,*],$
      xtitle='Beta',ytitle='ht',title='slope of lidar signal decay ',$
      /xstyle,/xlog,symbol='o')
    p3=plot([exp(i[0]+(i[1]*lidar_heights[max_index])),exp(i[0]+(i[1]*lidar_heights[n_elements(lidar_heights)-1]))],$
      [lidar_heights[max_index],lidar_heights[n_elements(lidar_heights)-1]],/overplot,color='red')
    
    if n_elements(copol_fit) ge 2. then begin
      p4=plot(copol_fit,lidar_heights_fit,/current,position=pos[2,*],$
      xtitle='Beta',ytitle='ht',title='slope of lidar signal decay ',$
      /xstyle,symbol='o')
    endif
    p5=plot([i[0]+(i[1]*lidar_heights_fit[0]),i[0]+(i[1]*lidar_heights_fit[-1])],$
      [lidar_heights_fit[0],lidar_heights_fit[-1]],/overplot,color='red')  

    t1=text(0.1,0.95,'extinction is '+strtrim(string(extinction,format='(f8.2)'),2)+' per km')
  
    imagename='extinction_via_slope.'+strcompress(profile_num,/remove_all)+'.png'
    p0.save,'/Users/u0029340/Documents/data/MISO/graphics/lidar_plots/'+imagename
 
  endif
  
endif;  if catch_flag eq 0 then begin ; put at end

;  Range gate is in km - I think this is redundant
num_atten=fix(effective_depth/range_gate)-max_index
if num_atten le 0 then num_atten=1

return 
end

