pro extinction_via_slope, extinction, eta, lidar_bscat_copol_in,lidar_heights_in, sigma_ext,effective_depth,max_index,num_atten,i

extinction=-1.

; eta is the multiple scattering factor
; lidar_bscat_copol input in 1/km/sr
; lidar_heights input in km

catch_flag=0
CATCH, Error_status
;This statement begins the error handler:
IF Error_status NE 0 THEN BEGIN
  catch_flag=1
  CATCH, /CANCEL
  return
ENDIF

if catch_flag eq 0 then begin ; put at end

lidar_bscat_copol=lidar_bscat_copol_in[where(lidar_bscat_copol_in gt 0.)]
lidar_heights=lidar_heights_in[where(lidar_bscat_copol_in gt 0.)]

max_index=where(lidar_bscat_copol eq max(lidar_bscat_copol))
if max_index gt n_elements(lidar_heights_in)/2 then return

kk=max_index[0]+4
while lidar_bscat_copol[kk]/lidar_bscat_copol[max_index[0]] gt exp(-6.*eta) and kk lt n_elements(lidar_bscat_copol)-2  do begin ; where is 3 effective optical depths?
  kk=kk+1
endwhile

effective_depth=lidar_heights[kk]-lidar_heights[0]
extinction=1./(lidar_heights[kk]-lidar_heights[max_index[0]])
sigma_ext=0.5*extinction  ; just fix this to 50%

if n_elements(lidar_bscat_copol) lt 4 then return


error_vector=fltarr(n_elements(lidar_bscat_copol[max_index[0]:n_elements(lidar_heights)-1]))
kk=max_index[0]
for k=0,n_elements(error_vector)-1 do begin
  if lidar_bscat_copol[k] ge 0.1 then error_vector[k]=0.1*lidar_bscat_copol[kk]
  if lidar_bscat_copol[k] lt 0.1 then error_vector[k]=0.25*lidar_bscat_copol[kk]
  if lidar_bscat_copol[k] lt 0.01 then error_vector[k]=0.5*lidar_bscat_copol[kk]
  if lidar_bscat_copol[k] lt 0.001 then error_vector[k]=lidar_bscat_copol[kk]
  kk=kk+1
endfor

noise_sig=median(lidar_bscat_copol[n_elements(lidar_bscat_copol)-6:n_elements(lidar_bscat_copol)-1])+(3.*sqrt(variance(lidar_bscat_copol[n_elements(lidar_bscat_copol)-6:n_elements(lidar_bscat_copol)-1])))
factor=noise_sig/lidar_bscat_copol[max_index[0]]


if lidar_bscat_copol[max_index[0]]+1 gt factor*lidar_bscat_copol[max_index[0]] then begin ; was 0.1
max_index=where(lidar_bscat_copol eq max(lidar_bscat_copol)) & max_index=max_index[0]+2
lidar_heights_fit=lidar_heights[max_index[0]]
copol_fit=alog(lidar_bscat_copol[max_index[0]])
error_vector=abs(0.1*alog(lidar_bscat_copol[max_index[0]]))
kk=max_index[0]+1
while lidar_bscat_copol[kk] gt factor*lidar_bscat_copol[max_index[0]] and kk lt n_elements(lidar_bscat_copol)-2  do begin ; was 0.05
lidar_heights_fit=[lidar_heights_fit,lidar_heights[kk]]
copol_fit=[copol_fit,alog(lidar_bscat_copol[kk])]
error_vector=[error_vector,abs(0.1*alog(lidar_bscat_copol[kk]))]
kk=kk+1
if kk ge n_elements(lidar_bscat_copol)-3 then return

endwhile
endif
catch, /cancel



catch_flag=0
CATCH, Error_status
;This statement begins the error handler:
IF Error_status NE 0 THEN BEGIN
  catch_flag=1
  CATCH, /CANCEL
  return
ENDIF


if catch_flag eq 0 then begin
i=linfit(lidar_heights_fit,copol_fit,measure_errors=abs(error_vector), chisqr=chsqr, $
  yfit=fit_copol,sigma=sig_values)
endif
catch, /cancel

;;;;;;;;;;;;;;;;;  try looping over the the heights removing 1, refitting, then taking the median of those
;start=0
;ii=n_elements(lidar_heights)-1
;if ii gt max_index[0]+2 then begin
;  while ii gt max_index[0]+1 do begin
;    if start eq 0 then begin
;      start=-1
;      b=linfit(lidar_heights[max_index[0]:ii],alog(lidar_bscat_copol[max_index[0]:ii]), chisqr=chisqr, yfit=yfit)
;      i_vec=b[1]
;      chisqr_vec=chisqr
;      rms_vector=sqrt(total((yfit-alog(lidar_bscat_copol[max_index[0]:ii]))^2)/float(n_elements(yfit)))
;      ii=ii-1
;    endif else begin
;      b=linfit(lidar_heights[max_index[0]:ii],alog(lidar_bscat_copol[max_index[0]:ii]), chisqr=chisqr, yfit=yfit)
;      i_vec=[i_vec,b[1]]
;      chisqr_vec=[chisqr_vec,chisqr]
;      rms_vector=[rms_vector,sqrt(total((yfit-alog(lidar_bscat_copol[max_index[0]:ii]))^2)/float(n_elements(yfit)))]
;      ii=ii-1
;    endelse
;  endwhile
;endif
;if n_elements(i_vec) gt 1 then begin
;  i[1]=median(i_vec)
;endif
;
;  
;endif else begin
;  catch_flag=0
;  CATCH, Error_status
;  ;This statement begins the error handler:
;  IF Error_status NE 0 THEN BEGIN
;    catch_flag=1
;    CATCH, /CANCEL
;    return
;  ENDIF
;
;
;  if catch_flag eq 0 then begin  
;  i=linfit(lidar_heights[max_index[0]:n_elements(lidar_heights)-1],alog(lidar_bscat_copol[max_index[0]:n_elements(lidar_heights)-1]),measure_errors=error_vector, chisqr=chsqr, $
;    yfit=fit_copol,sigma=sig_values)
;  endif
;  catch, /cancel
; 
;;;;;;;;;;;;;;;;;  try looping over the the heights removing 1, refitting, then taking the median of those
;start=0
;ii=n_elements(lidar_heights)-1
;if ii gt max_index[0]+2 then begin
;while ii gt max_index[0]+1 do begin
;  if start eq 0 then begin
;    start=-1
;    b=linfit(lidar_heights[max_index[0]:ii],alog(lidar_bscat_copol[max_index[0]:ii]), chisqr=chisqr)
;    i_vec=b[1]
;    chisqr_vec=chisqr
;    ii=ii-1
;  endif else begin
;    b=linfit(lidar_heights[max_index[0]:ii],alog(lidar_bscat_copol[max_index[0]:ii]), chisqr=chisqr)
;    i_vec=[i_vec,b[1]]
;    chisqr_vec=[chisqr_vec,chisqr]
;    ii=ii-1
;  endelse
;endwhile
;endif
;if n_elements(i_vec) gt 1 then begin
;  i[1]=median(i_vec)
;endif
;  
;  ;if lidar_bscat_copol[max_index[0]]+1 gt 0.1*lidar_bscat_copol[max_index[0]] then begin
;endelse

;num_atten=n_elements(copol_fit)


;i=linfit(lidar_heights[max_index[0]:n_elements(lidar_heights)-1],alog(lidar_bscat_copol[max_index[0]:n_elements(lidar_heights)-1]),measure_errors=error_vector, chisqr=chsqr, $
;  yfit=fit_copol,sigma=sig_values)
;  
;linfit(lidar_heights[max_index[0]:max_index[0]+6],alog(lidar_bscat_copol[max_index[0]:max_index[0]+6]))  

if i[1] lt 0. then begin
extinction=i[1]/(-2.*eta)

;estimate extinction uncertianty

term1=((-i[1]/(2.*(eta^2)))^2)*((0.15*eta)^2)   ; assuming standard deviation of eta would 15%
term2=((1./(2.*eta))^2)*sig_values[1]^2

sigma_ext=sqrt(term1+term2)

;kk=max_index[0]+1
;while lidar_bscat_copol[kk]/lidar_bscat_copol[max_index[0]] gt exp(-6.*extinction) and kk lt n_elements(lidar_bscat_copol)-2  do begin ; where is 3 effective optical depths?
;  kk=kk+1
;endwhile
;
;;effective_depth=lidar_heights[kk]-lidar_heights[0]
;effective_depth=alog(0.002)/(-extinction)

endif

;fname='/Volumes/External_Data/Capricorn_SO/graphics/slope_test.gif'
;;
;p0=plot(lidar_bscat_copol[max_index[0]:n_elements(lidar_heights)-1],lidar_heights[max_index[0]:n_elements(lidar_heights)-1], /xlog, color=0,xtitle='Beta',ytitle='ht',thick=2, xthick=5, ythick=5, $
;  title='slope of lidar signal decay ')
;  p0=plot([exp(i[0]+(i[1]*lidar_heights[max_index[0]])),exp(i[0]+(i[1]*lidar_heights[n_elements(lidar_heights)-1]))],  [lidar_heights[max_index[0]],lidar_heights[n_elements(lidar_heights)-1]], /overplot, color=20,thick=2)  
;fname='/Volumes/External_Data/Capricorn_SO/graphics/slope_test.png'
;p0.save,fname,height=600

;set_plot, 'Z'
;loadct, 5 & gamma_ct, 1.0 & !p.charsize=3. & !p.background=!d.n_colors
;;top_top_y=0.93 & dy=0.1 & top_y=0.95 & bot_y=top_y-dy & sep_y=0.05
;;sx=0.12 & sy=0.06 & xl=0.1 & xr=0.9 & yt=0.95 & yb=0.1
;;!p.thick=3. & numplots_x=2 & numplots_y=2
;;position_plots,xl,xr,yb,yt,sx,sy,numplots_x,numplots_y,pos
;;cbpos=pos & cbpos[*,0]=cbpos[*,2]+0.08 & cbpos[*,2]=cbpos[*,0]+0.012
;!p.multi=[0,4,4]
;;
;pnum=2 ;& pos_vector=pos[pnum,*]
;plot, lidar_bscat_copol, lidar_heights, color=0,xtitle='Beta',ytitle='ht',$
;  thick=5, charsize=3.0, charthick=3, xthick=5, ythick=5, psym=2, symsize=1., $
;  title='slope of lidar signal decay ';, xstyle=1, /xlog;, xrange=[min(lidar_hrfrac), max(lidar_hrfrac)]
;
;;oplot, [i[0]+(i[1]*lidar_heights[max_index[0]]),i[0]+(i[1]*lidar_heights[n_elements(lidar_heights)-1])],  [lidar_heights[max_index[0]],lidar_heights[n_elements(lidar_heights)-1]], psym=1, color=130, symsize=0.5
;
;;txt_string='extinction is '+strtrim(string(extinction,format='(f6.3)'),2)+' per km'
;
;;xyouts, lidar_bscat_copol[1], lidar_heights[max_index+2], txt_string, color=0, charsize=3., charthick=7, /normal
;
;fname='/Volumes/External_Data/Capricorn_SO/graphics/slope_test.gif'

;write_gif, fname, tvrd()

endif;  if catch_flag eq 0 then begin ; put at end


num_atten=fix(effective_depth/0.015)-max_index
if num_atten le 0 then num_atten=1

return 
end

