pro eval_large_scale_cloud_controlling_factors

file_path='/Users/u0029340/Documents/data/ena/large-scale/data4histo/'
output_path='/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/'

; do pre first
distance_min=500. ; km
 
file='shiptrack_full_data_pre_daily.nc4'

cdfid=ncdf_open(file_path+file)
x_id=ncdf_varid(cdfid, 'time') & ncdf_varget, cdfid, x_id, time_pre
x_id=ncdf_varid(cdfid, 'lat') & ncdf_varget, cdfid, x_id, lat_pre
x_id=ncdf_varid(cdfid, 'lon') & ncdf_varget, cdfid, x_id, lon_pre
x_id=ncdf_varid(cdfid, 'eis') & ncdf_varget, cdfid, x_id, eis_pre
x_id=ncdf_varid(cdfid, 't_adv') & ncdf_varget, cdfid, x_id, t_adv_pre
x_id=ncdf_varid(cdfid, 'omega') & ncdf_varget, cdfid, x_id, omega_pre
x_id=ncdf_varid(cdfid, 'rh_m') & ncdf_varget, cdfid, x_id, rh_m_pre
x_id=ncdf_varid(cdfid, 'sfc_wind') & ncdf_varget, cdfid, x_id, sfc_wind_pre
ncdf_close, cdfid

caldat, time_pre, mm_pre, dd_pre, yy_pre, hh_pre, min_pre, sec_pre

;39° 5′ 29.76″ N, 28° 1′ 32.52″ W

lat_ena=39.+(5./60.)+(29.76/(60.*60.))
lon_ena=-28.+(1./60.)+(32.52/(60.*60.))

count=0
for j=0,n_elements(lat_pre)-1 do begin
  for jj=0,n_elements(lon_pre)-1 do begin
    ; is the distance less than min
    distance=map_2points(lon_ena, lat_ena, lon_pre[jj],lat_pre[jj],/meters)/1000.
    print, j,jj,distance
if distance lt distance_min then begin
  for k=0,n_elements(time_pre)-1 do begin
    
    if mm_pre[k] ge 5. and mm_pre[k] le 9 then begin
  
  if count eq 0 then begin
    count=1
    eis_pre_vector=eis_pre[jj,j,k]
    t_adv_pre_vector=t_adv_pre[jj,j,k]
    omega_pre_vector=omega_pre[jj,j,k]
    rh_m_pre_vector=rh_m_pre[jj,j,k]
    sfc_wind_pre_vector=sfc_wind_pre[jj,j,k]
  endif else begin
    eis_pre_vector=[eis_pre_vector,eis_pre[jj,j,k]]
    t_adv_pre_vector=[t_adv_pre_vector, t_adv_pre[jj,j,k]]
    omega_pre_vector=[omega_pre_vector, omega_pre[jj,j,k]]
    rh_m_pre_vector=[rh_m_pre_vector, rh_m_pre[jj,j,k]]
    sfc_wind_pre_vector=[sfc_wind_pre_vector, sfc_wind_pre[jj,j,k]]
  endelse
  
    endif
  
  endfor  ;for k=0,n_elements(time_pre)-1 do begin

endif ;if distance lt distance_min then begin
    
  endfor
endfor


; do pre first
distance_min=500. ; km

file='shiptrack_full_data_post_daily.nc4'

cdfid=ncdf_open(file_path+file)
x_id=ncdf_varid(cdfid, 'time') & ncdf_varget, cdfid, x_id, time_post
x_id=ncdf_varid(cdfid, 'lat') & ncdf_varget, cdfid, x_id, lat_post
x_id=ncdf_varid(cdfid, 'lon') & ncdf_varget, cdfid, x_id, lon_post
x_id=ncdf_varid(cdfid, 'eis') & ncdf_varget, cdfid, x_id, eis_post
x_id=ncdf_varid(cdfid, 't_adv') & ncdf_varget, cdfid, x_id, t_adv_post
x_id=ncdf_varid(cdfid, 'omega') & ncdf_varget, cdfid, x_id, omega_post
x_id=ncdf_varid(cdfid, 'rh_m') & ncdf_varget, cdfid, x_id, rh_m_post
x_id=ncdf_varid(cdfid, 'sfc_wind') & ncdf_varget, cdfid, x_id, sfc_wind_post
ncdf_close, cdfid

caldat, time_post, mm_post, dd_post, yy_post, hh_post, min_post, sec_post


;39° 5′ 29.76″ N, 28° 1′ 32.52″ W

lat_ena=39.+(5./60.)+(29.76/(60.*60.))
lon_ena=-28.+(1./60.)+(32.52/(60.*60.))

count=0
for j=0,n_elements(lat_post)-1 do begin
  for jj=0,n_elements(lon_post)-1 do begin
    ; is the distance less than min
    distance=map_2points(lon_ena, lat_ena, lon_post[jj],lat_post[jj],/meters)/1000.
    print, j,jj,distance
    if distance lt distance_min then begin
      for k=0,n_elements(time_post)-1 do begin

        if mm_post[k] ge 5. and mm_post[k] le 9 then begin

        if count eq 0 then begin
          count=1
          eis_post_vector=eis_post[jj,j,k]
          t_adv_post_vector=t_adv_post[jj,j,k]
          omega_post_vector=omega_post[jj,j,k]
          rh_m_post_vector=rh_m_post[jj,j,k]
          sfc_wind_post_vector=sfc_wind_post[jj,j,k]
        endif else begin
          eis_post_vector=[eis_post_vector,eis_post[jj,j,k]]
          t_adv_post_vector=[t_adv_post_vector, t_adv_post[jj,j,k]]
          omega_post_vector=[omega_post_vector, omega_post[jj,j,k]]
          rh_m_post_vector=[rh_m_post_vector, rh_m_post[jj,j,k]]
          sfc_wind_post_vector=[sfc_wind_post_vector, sfc_wind_post[jj,j,k]]
        endelse
        
        endif

      endfor  ;for k=0,n_elements(time_post)-1 do begin

    endif ;if distance lt distance_min then begin

  endfor
endfor

eis_post_vector=eis_post_vector[where(finite(eis_post_vector) eq 1)]
eis_pre_vector=eis_pre_vector[where(finite(eis_pre_vector) eq 1)]
t_adv_pre_vector=t_adv_pre_vector[where(finite(t_adv_pre_vector) eq 1)]
t_adv_post_vector=t_adv_post_vector[where(finite(t_adv_post_vector) eq 1)]
omega_pre_vector=omega_pre_vector[where(finite(omega_pre_vector) eq 1)]
omega_post_vector=omega_post_vector[where(finite(omega_post_vector) eq 1)]
rh_m_pre_vector=rh_m_pre_vector[where(finite(rh_m_pre_vector) eq 1)]
rh_m_post_vector=rh_m_post_vector[where(finite(rh_m_post_vector) eq 1)]
sfc_wind_pre_vector=sfc_wind_pre_vector[where(finite(sfc_wind_pre_vector) eq 1)]
sfc_wind_post_vector=sfc_wind_post_vector[where(finite(sfc_wind_post_vector) eq 1)]

kstwo_nin, eis_pre_vector, eis_post_vector[where(eis_post_vector ne 0.0)], d_eis, prob_eis, n_elements(time_post)
print, 'eis ', distance_min, d_eis, prob_eis

kstwo_nin, t_adv_pre_vector[where(finite(t_adv_pre_vector) eq 1)], t_adv_post_vector[where(finite(t_adv_post_vector) eq 1)], d_tadv, prob_tadv, n_elements(time_post)
print, 't adv ', distance_min, d_tadv, prob_tadv

kstwo_nin, omega_pre_vector[where(finite(omega_pre_vector) eq 1)], omega_post_vector[where(finite(omega_post_vector) eq 1)], d_omega, prob_omega, n_elements(time_post)
print, 'omega ', distance_min, d_omega, prob_omega

kstwo_nin, rh_m_pre_vector[where(finite(rh_m_pre_vector) eq 1)], rh_m_post_vector[where(finite(rh_m_post_vector) eq 1)], d_rh, prob_rh, n_elements(time_post)
print, 'rh_m ', distance_min, d_rh, prob_rh

kstwo_nin, sfc_wind_pre_vector[where(finite(sfc_wind_pre_vector) eq 1)], sfc_wind_post_vector[where(finite(sfc_wind_post_vector) eq 1)], d_wind, prob_wind, n_elements(time_post)
print, 'sfc_wind ', distance_min, d_wind, prob_wind



lin_histo_2, t_adv_pre_vector, t_adv_post_vector[where(t_adv_post_vector ne 0.0)], 2, 20, t_adv_pre_histo1, t_adv_post_histo2, t_adv_bins, $
  t_adv_pre_moments1, t_adv_post_moments2, t_adv_pre_med1, t_adv_post_med2, num

  lin_histo_2, eis_pre_vector, eis_post_vector, 2, 20, eis_pre_histo1, eis_post_histo2, eis_bins, $
    eis_pre_moments1, eis_post_moments2, eis_pre_med1, eis_post_med2, num

  lin_histo_2, omega_pre_vector, omega_post_vector[where(omega_post_vector ne 0.0)], 2, 20, omega_pre_histo1, omega_post_histo2, omega_bins, $
    omega_pre_moments1, omega_post_moments2, omega_pre_med1, omega_post_med2, num

 lin_histo_2, rh_m_pre_vector, rh_m_post_vector[where(rh_m_post_vector ne 0.0)], 2, 20, rh_m_pre_histo1, rh_m_post_histo2, rh_m_bins, $
    rh_m_pre_moments1, rh_m_post_moments2, rh_m_pre_med1, rh_m_post_med2, num

  lin_histo_2, sfc_wind_pre_vector, sfc_wind_post_vector[where(sfc_wind_post_vector ne 0.0)], 2, 20, sfc_wind_pre_histo1, sfc_wind_post_histo2, sfc_wind_bins, $
    sfc_wind_pre_moments1, sfc_wind_post_moments2, sfc_wind_pre_med1, sfc_wind_post_med2, num
    
  ;;;;;;;;;  write temp advection data
;  cdfid=ncdf_create(output_path+'temp_advection_vectors.cdf',/clobber)
;  event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(t_adv_pre_vector))
;  event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(t_adv_post_vector[where(t_adv_post_vector ne 0.0)]))
;  ccn_pre_id=ncdf_vardef(cdfid, 't_adv_pre',[event_pre_did],/float)
;  ncdf_attput, cdfid, ccn_pre_id, 'long_name', 'temp advection pre 2020'
;  ncdf_attput, cdfid, ccn_pre_id, 'units', 'Kelvins per Day'
;  ccn_post_id=ncdf_vardef(cdfid, 't_adv_post',[event_post_did],/float)
;  ncdf_attput, cdfid, ccn_post_id, 'long_name', 'temp advection Post 2020'
;  ncdf_attput, cdfid, ccn_post_id, 'units', 'Kelvins per Day'
;  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
;  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
;  ncdf_attput, cdfid, d_id, 'units', 'unitless'
;  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
;  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
;  ncdf_attput, cdfid, prob_id, 'units', 'unitless'
;
;  ncdf_control, cdfid, /endef
;  ncdf_varput, cdfid, ccn_pre_id, t_adv_pre_vector*86400.
;  ncdf_varput, cdfid, ccn_post_id, t_adv_post_vector[where(t_adv_post_vector ne 0.0)]*86400.
;  ncdf_varput, cdfid, d_id, d_tadv
;  ncdf_varput, cdfid, prob_id, prob_tadv
;  ncdf_close, cdfid
; 
;
;  
;  ;;;;;;;;;  write eis data
;  cdfid=ncdf_create(output_path+'eis_vectors.cdf',/clobber)
;  event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(eis_pre_vector))
;  event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(eis_post_vector))
;  ccn_pre_id=ncdf_vardef(cdfid, 'eis_pre',[event_pre_did],/float)
;  ncdf_attput, cdfid, ccn_pre_id, 'long_name', 'Estimated Invesion Strength pre 2020'
;  ncdf_attput, cdfid, ccn_pre_id, 'units', 'degrees C'
;  ccn_post_id=ncdf_vardef(cdfid, 'eis_post',[event_post_did],/float)
;  ncdf_attput, cdfid, ccn_post_id, 'long_name', 'Estimated Inversion Strength Post 2020'
;  ncdf_attput, cdfid, ccn_post_id, 'units', 'degrees C'
;  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
;  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
;  ncdf_attput, cdfid, d_id, 'units', 'unitless'
;  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
;  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
;  ncdf_attput, cdfid, prob_id, 'units', 'unitless'
;  ncdf_control, cdfid, /endef
;  ncdf_varput, cdfid, ccn_pre_id, eis_pre_vector
;  ncdf_varput, cdfid, ccn_post_id, eis_post_vector
;  ncdf_varput, cdfid, d_id, d_eis
;  ncdf_varput, cdfid, prob_id, prob_eis
;    ncdf_close, cdfid
;
;  ;;;;;;;;;  write omega data
;  cdfid=ncdf_create(output_path+'omega_vectors.cdf',/clobber)
;  event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(omega_pre_vector))
;  event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(omega_post_vector[where(omega_post_vector ne 0.0)]))
;  ccn_pre_id=ncdf_vardef(cdfid, 'omega_pre',[event_pre_did],/float)
;  ncdf_attput, cdfid, ccn_pre_id, 'long_name', 'pressure vertical velocity pre 2020'
;  ncdf_attput, cdfid, ccn_pre_id, 'units', 'Pascals per second'
;  ccn_post_id=ncdf_vardef(cdfid, 'omega_post',[event_post_did],/float)
;  ncdf_attput, cdfid, ccn_post_id, 'long_name', 'pressure vertical velocity Post 2020'
;  ncdf_attput, cdfid, ccn_post_id, 'units', 'Pascals per second'
;  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
;  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
;  ncdf_attput, cdfid, d_id, 'units', 'unitless'
;  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
;  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
;  ncdf_attput, cdfid, prob_id, 'units', 'unitless'
;  ncdf_control, cdfid, /endef
;  ncdf_varput, cdfid, ccn_pre_id, omega_pre_vector
;  ncdf_varput, cdfid, ccn_post_id, omega_post_vector[where(omega_post_vector ne 0.0)]
;  ncdf_varput, cdfid, d_id, d_omega
;  ncdf_varput, cdfid, prob_id, prob_omega
;  ncdf_close, cdfid
;  
;  ;;;;;;;;;  write rh_m data
;  cdfid=ncdf_create(output_path+'rh_m_vectors.cdf',/clobber)
;  event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(rh_m_pre_vector))
;  event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(rh_m_post_vector[where(rh_m_post_vector ne 0.0)]))
;  ccn_pre_id=ncdf_vardef(cdfid, 'rh_m_pre',[event_pre_did],/float)
;  ncdf_attput, cdfid, ccn_pre_id, 'long_name', 'mid troposphere relative humidity pre 2020'
;  ncdf_attput, cdfid, ccn_pre_id, 'units', 'fraction'
;  ccn_post_id=ncdf_vardef(cdfid, 'rh_m_post',[event_post_did],/float)
;  ncdf_attput, cdfid, ccn_post_id, 'long_name', 'mid troposphere relative humidity Post 2020'
;  ncdf_attput, cdfid, ccn_post_id, 'units', 'fraction'
;  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
;  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
;  ncdf_attput, cdfid, d_id, 'units', 'unitless'
;  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
;  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
;  ncdf_attput, cdfid, prob_id, 'units', 'unitless'
;  ncdf_control, cdfid, /endef
;  ncdf_varput, cdfid, ccn_pre_id, rh_m_pre_vector
;  ncdf_varput, cdfid, ccn_post_id, rh_m_post_vector[where(rh_m_post_vector ne 0.0)]
;  ncdf_varput, cdfid, d_id, d_rh
;  ncdf_varput, cdfid, prob_id, prob_rh
;  ncdf_close, cdfid
;  
;  ;;;;;;;;;  write sfc wind data
;  cdfid=ncdf_create(output_path+'sfc_wind_vectors.cdf',/clobber)
;  event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(sfc_wind_pre_vector))
;  event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(sfc_wind_post_vector[where(sfc_wind_post_vector ne 0.0)]))
;  ccn_pre_id=ncdf_vardef(cdfid, 'sfc_wind_pre',[event_pre_did],/float)
;  ncdf_attput, cdfid, ccn_pre_id, 'long_name', 'surface wind pre 2020'
;  ncdf_attput, cdfid, ccn_pre_id, 'units', 'meters per second'
;  ccn_post_id=ncdf_vardef(cdfid, 'sfc_wind_post',[event_post_did],/float)
;  ncdf_attput, cdfid, ccn_post_id, 'long_name', 'surface wind Post 2020'
;  ncdf_attput, cdfid, ccn_post_id, 'units', 'meters per second'
;  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
;  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
;  ncdf_attput, cdfid, d_id, 'units', 'unitless'
;  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
;  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
;  ncdf_attput, cdfid, prob_id, 'units', 'unitless'
;  ncdf_control, cdfid, /endef
;  ncdf_varput, cdfid, ccn_pre_id, sfc_wind_pre_vector
;  ncdf_varput, cdfid, ccn_post_id, sfc_wind_post_vector[where(sfc_wind_post_vector ne 0.0)]
;  ncdf_varput, cdfid, d_id, d_wind
;  ncdf_varput, cdfid, prob_id, prob_wind
;  ncdf_close, cdfid

  set_plot, 'Z'
  loadct, 5 & gamma_ct, 1.0 & set_plot, 'Z' & device, set_resolution=[3000,2000] & !p.charsize=3.75 & !p.font=-1 & !p.background=!d.n_colors-1
  top_top_y=0.93 & dy=0.1 & top_y=0.95 & bot_y=top_y-dy & sep_y=0.05
  sx=0.12 & sy=0.06 & xl=0.1 & xr=0.9 & yt=0.95 & yb=0.1
  !p.thick=3. & numplots_x=3 & numplots_y=3
  position_plots,xl,xr,yb,yt,sx,sy,numplots_x,numplots_y,pos
  cbpos=pos & cbpos[*,0]=cbpos[*,2]+0.08 & cbpos[*,2]=cbpos[*,0]+0.012
  !p.multi=[0,4,4]

  pnum=8

  plot, t_adv_bins*86400., t_adv_pre_histo1/float(total(t_adv_pre_histo1)), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='Temp Adv (K/day)', ytitle='Frequency', title='Temp Adv (K/day) Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.75, charthick=4 ;max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])

  oplot, t_adv_bins*86400.,t_adv_post_histo2/float(total(t_adv_post_histo2)), psym=10, color=100

  xyouts, mean(t_adv_bins*86400.), median(t_adv_pre_histo1/float(total(t_adv_pre_histo1))), $
    strtrim(string(prob_tadv, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data
    
  cdfid=ncdf_create(output_path+'temp_advection_histo.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(t_adv_bins*86400.))
  bins_id=ncdf_vardef(cdfid, 'Temp_Adv_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'temp advection bins'
  ncdf_attput, cdfid, bins_id, 'units', 'kelvins per day'
  pre_id=ncdf_vardef(cdfid, 'temp_adv_pre_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of temp advection of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'temp_adv_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of temp advection of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
  ncdf_attput, cdfid, d_id, 'units', 'unitless'
  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
  ncdf_attput, cdfid, prob_id, 'units', 'unitless'

  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, t_adv_bins*86400.
  ncdf_varput, cdfid, pre_id, t_adv_pre_histo1/float(total(t_adv_pre_histo1))
  ncdf_varput, cdfid, post_id, t_adv_post_histo2/float(total(t_adv_post_histo2))
  ncdf_varput, cdfid, d_id, d_tadv
  ncdf_varput, cdfid, prob_id, prob_tadv
  ncdf_close, cdfid

  pnum=7

  plot, eis_bins, eis_pre_histo1/float(total(eis_pre_histo1)), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='Estimated Inversion Strength (K)', ytitle='Frequency', title='EIS (K) Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.75, charthick=4 ;max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])

  oplot, eis_bins,eis_post_histo2/float(total(eis_post_histo2)), psym=10, color=100

  xyouts, mean(eis_bins), median(eis_pre_histo1/float(total(eis_pre_histo1))), $
    strtrim(string(prob_eis, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data
    
  cdfid=ncdf_create(output_path+'eis_histo.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(eis_bins))
  bins_id=ncdf_vardef(cdfid, 'EIS_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'EIS bins'
  ncdf_attput, cdfid, bins_id, 'units', 'Kelvins'
  pre_id=ncdf_vardef(cdfid, 'eis_pre_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of eis of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'eis_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of eis of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
  ncdf_attput, cdfid, d_id, 'units', 'unitless'
  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
  ncdf_attput, cdfid, prob_id, 'units', 'unitless'

  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, eis_bins
  ncdf_varput, cdfid, pre_id, eis_pre_histo1/float(total(eis_pre_histo1))
  ncdf_varput, cdfid, post_id, eis_post_histo2/float(total(eis_post_histo2))
  ncdf_varput, cdfid, d_id, d_eis
  ncdf_varput, cdfid, prob_id, prob_eis
  ncdf_close, cdfid
    

  pnum=6

  plot, omega_bins*86400/100., omega_pre_histo1/float(total(omega_pre_histo1)), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='omega (mb/day)', ytitle='Frequency', title='omega (mb/day) Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.75, charthick=4 ;max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])

  oplot, omega_bins*86400/100.,omega_post_histo2/float(total(omega_post_histo2)), psym=10, color=100

  xyouts, mean(omega_bins*86400/100.), median(omega_pre_histo1/float(total(omega_pre_histo1))), $
    strtrim(string(prob_omega, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data
    
  cdfid=ncdf_create(output_path+'omega_histo.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(omega_bins*86400/100.))
  bins_id=ncdf_vardef(cdfid, 'omega_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'omega bins'
  ncdf_attput, cdfid, bins_id, 'units', 'mb per day'
  pre_id=ncdf_vardef(cdfid, 'omega_pre_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of omega of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'omega_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of omega of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
  ncdf_attput, cdfid, d_id, 'units', 'unitless'
  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
  ncdf_attput, cdfid, prob_id, 'units', 'unitless'

  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, omega_bins*86400/100.
  ncdf_varput, cdfid, pre_id, omega_pre_histo1/float(total(omega_pre_histo1))
  ncdf_varput, cdfid, post_id, omega_post_histo2/float(total(omega_post_histo2))
  ncdf_varput, cdfid, d_id, d_omega
  ncdf_varput, cdfid, prob_id, prob_omega
  ncdf_close, cdfid
    

  pnum=5

  plot, rh_m_bins, rh_m_pre_histo1/float(total(rh_m_pre_histo1)), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='Mie Trop RH (Fraction)', ytitle='Frequency', title='Mid Trop RH Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.75, charthick=4 ;max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])

  oplot, rh_m_bins,rh_m_post_histo2/float(total(rh_m_post_histo2)), psym=10, color=100

  xyouts, mean(rh_m_bins), median(rh_m_pre_histo1/float(total(rh_m_pre_histo1))), $
    strtrim(string(prob_rh, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data
    
  cdfid=ncdf_create(output_path+'rh_histo.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(rh_m_bins))
  bins_id=ncdf_vardef(cdfid, 'rh_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'rh bins'
  ncdf_attput, cdfid, bins_id, 'units', 'percent'
  pre_id=ncdf_vardef(cdfid, 'rh_pre_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of rh of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'rh_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of rh of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
  ncdf_attput, cdfid, d_id, 'units', 'unitless'
  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
  ncdf_attput, cdfid, prob_id, 'units', 'unitless'

  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, rh_m_bins
  ncdf_varput, cdfid, pre_id, rh_m_pre_histo1/float(total(rh_m_pre_histo1))
  ncdf_varput, cdfid, post_id, rh_m_post_histo2/float(total(rh_m_post_histo2))
  ncdf_varput, cdfid, d_id, d_rh
  ncdf_varput, cdfid, prob_id, prob_rh
  ncdf_close, cdfid


  pnum=3

  plot, sfc_wind_bins, sfc_wind_pre_histo1/float(total(sfc_wind_pre_histo1)), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='Surface Wind (m/s)', ytitle='Frequency', title='Surface Wind (m/s) Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.75, charthick=4 ;max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])

  oplot, sfc_wind_bins,sfc_wind_post_histo2/float(total(sfc_wind_post_histo2)), psym=10, color=100

  xyouts, mean(sfc_wind_bins), median(sfc_wind_pre_histo1/float(total(sfc_wind_pre_histo1))), $
    strtrim(string(prob_wind, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data
    
  cdfid=ncdf_create(output_path+'wind_histo.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(sfc_wind_bins))
  bins_id=ncdf_vardef(cdfid, 'sfc_wind_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'surface wind bins'
  ncdf_attput, cdfid, bins_id, 'units', 'meters per second'
  pre_id=ncdf_vardef(cdfid, 'sfc_wind_pre_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of surface wind of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'sfc_wind_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of surface wind of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
  ncdf_attput, cdfid, d_id, 'units', 'unitless'
  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
  ncdf_attput, cdfid, prob_id, 'units', 'unitless'

  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, sfc_wind_bins
  ncdf_varput, cdfid, pre_id, sfc_wind_pre_histo1/float(total(sfc_wind_pre_histo1))
  ncdf_varput, cdfid, post_id, sfc_wind_post_histo2/float(total(sfc_wind_post_histo2))
  ncdf_varput, cdfid, d_id, d_wind
  ncdf_varput, cdfid, prob_id, prob_wind
  ncdf_close, cdfid
    

  
  write_gif, output_path+'large-scale_repro.gif', tvrd()


stop
end




