pro ena_ks_test_modis

  output_path='/Users/u0029340/Documents/text/ENA_IMO2020_Paper/Figures/'


data_file='/Users/u0029340/Documents/text/ENA_IMO2020_Paper/ena.MOYD.range_ring_vectors.201605-202309.029_048lat.-39_-16lon.cdf'
cdfid=ncdf_open(data_file)
;x_id=ncdf_varid(cdfid, 'lwp_0100km_pre') & ncdf_varget, cdfid, x_id, lwp_0250km_pre
;x_id=ncdf_varid(cdfid, 'lwp_0100km_post') & ncdf_varget, cdfid, x_id, lwp_0250km_post
;x_id=ncdf_varid(cdfid, 'nd_0100km_pre') & ncdf_varget, cdfid, x_id, nd_0250km_pre
;x_id=ncdf_varid(cdfid, 'nd_0100km_post') & ncdf_varget, cdfid, x_id, nd_0250km_post
;x_id=ncdf_varid(cdfid, 're_0100km_pre') & ncdf_varget, cdfid, x_id, re_0250km_pre
;x_id=ncdf_varid(cdfid, 're_0100km_post') & ncdf_varget, cdfid, x_id, re_0250km_post
;x_id=ncdf_varid(cdfid, 'tau_0100km_pre') & ncdf_varget, cdfid, x_id, tau_0250km_pre
;x_id=ncdf_varid(cdfid, 'tau_0100km_post') & ncdf_varget, cdfid, x_id, tau_0250km_post
;x_id=ncdf_varid(cdfid, 'alb_0100km_pre') & ncdf_varget, cdfid, x_id, alb_0250km_pre
;x_id=ncdf_varid(cdfid, 'alb_0100km_post') & ncdf_varget, cdfid, x_id, alb_0250km_post
;x_id=ncdf_varid(cdfid, 'temp_0100km_pre') & ncdf_varget, cdfid, x_id, temp_0250km_pre
;x_id=ncdf_varid(cdfid, 'temp_0100km_post') & ncdf_varget, cdfid, x_id, temp_0250km_post

x_id=ncdf_varid(cdfid, 'lwp_0250km_pre') & ncdf_varget, cdfid, x_id, lwp_0250km_pre
x_id=ncdf_varid(cdfid, 'lwp_0250km_post') & ncdf_varget, cdfid, x_id, lwp_0250km_post
x_id=ncdf_varid(cdfid, 'nd_0250km_pre') & ncdf_varget, cdfid, x_id, nd_0250km_pre
x_id=ncdf_varid(cdfid, 'nd_0250km_post') & ncdf_varget, cdfid, x_id, nd_0250km_post
x_id=ncdf_varid(cdfid, 're_0250km_pre') & ncdf_varget, cdfid, x_id, re_0250km_pre
x_id=ncdf_varid(cdfid, 're_0250km_post') & ncdf_varget, cdfid, x_id, re_0250km_post
x_id=ncdf_varid(cdfid, 'tau_0250km_pre') & ncdf_varget, cdfid, x_id, tau_0250km_pre
x_id=ncdf_varid(cdfid, 'tau_0250km_post') & ncdf_varget, cdfid, x_id, tau_0250km_post
x_id=ncdf_varid(cdfid, 'alb_0250km_post') & ncdf_varget, cdfid, x_id, alb_0250km_post
x_id=ncdf_varid(cdfid, 'alb_0250km_pre') & ncdf_varget, cdfid, x_id, alb_0250km_pre
x_id=ncdf_varid(cdfid, 'temp_0250km_pre') & ncdf_varget, cdfid, x_id, temp_0250km_pre
x_id=ncdf_varid(cdfid, 'temp_0250km_post') & ncdf_varget, cdfid, x_id, temp_0250km_post
ncdf_close, cdfid

;kstwo_nin, lwp_0100km_pre, lwp_0100km_post, d, prob, 250
;print, 'lwp 100 ', d, prob
;
;kstwo_nin, nd_0100km_pre, nd_0100km_post, d, prob, 250
;print, 'nd 100 ', d, prob
;
;kstwo_nin, re_0100km_pre, re_0100km_post, d, prob, 250
;print, 're 100 ', d, prob
;
;kstwo_nin, tau_0100km_pre, tau_0100km_post, d, prob, 250
;print, 'tau 100 ', d, prob
;
;kstwo_nin, alb_0100km_pre, alb_0100km_post, d, prob, 250
;print, 'alb 100 ', d, prob

n_days=200

kstwo_nin, lwp_0250km_pre, lwp_0250km_post, d_lwp_250, prob_lwp_250, n_days
print, 'lwp 250 ', d_lwp_250, prob_lwp_250

kstwo_nin, nd_0250km_pre, nd_0250km_post, d_nd_250, prob_nd_250, n_days
print, 'nd 250 ', d_nd_250, prob_nd_250

kstwo_nin, re_0250km_pre, re_0250km_post, d_re_250, prob_re_250, n_days
print, 're 250 ', d_re_250, prob_re_250

kstwo_nin, tau_0250km_pre, tau_0250km_post, d_tau_250, prob_tau_250, n_days
print, 'tau 250 ', d_tau_250, prob_tau_250

kstwo_nin, alb_0250km_pre, alb_0250km_post, d_alb_250, prob_alb_250, n_days
print, 'alb 250 ', d_alb_250, prob_alb_250

lin_histo_2, lwp_0250km_pre, lwp_0250km_post, 2, 20, lwp_0250km_pre_histo1, lwp_0250km_post_post_histo2, lwp_bins, $
  lwp_0250km_pre_moments1, lwp_0250km_post_moments2, lwp_0250km_pre_moments1_med1, lwp_0250km_post_med2, num

  lin_histo_2, nd_0250km_pre, nd_0250km_post, 3, 30, nd_0250km_pre_histo1, nd_0250km_post_post_histo2, nd_bins, $
    nd_0250km_pre_moments1, nd_0250km_post_moments2, nd_0250km_pre_moments1_med1, nd_0250km_post_med2, num


  lin_histo_2, alb_0250km_pre, alb_0250km_post, 2, 20, alb_0250km_pre_histo1, alb_0250km_post_post_histo2, alb_bins, $
    alb_0250km_pre_moments1, alb_0250km_post_moments2, alb_0250km_pre_moments1_med1, alb_0250km_post_med2, num

  lin_histo_2, re_0250km_pre, re_0250km_post, 3, 20, re_0250km_pre_histo1, re_0250km_post_post_histo2, re_bins, $
    re_0250km_pre_moments1, re_0250km_post_moments2, re_0250km_pre_moments1_med1, re_0250km_post_med2, num
    
    lin_histo_2, tau_0250km_pre, tau_0250km_post, 3, 15, optical_depth_pre_histo1, optical_depth_post_histo2, optical_depth_bins, $
    optical_depth_pre_moments1, optical_depth_post_moments2, optical_depth_pre_med1, optical_depth_post_med2, num


  set_plot, 'Z'
  loadct, 5 & gamma_ct, 1.0 & set_plot, 'Z' & device, set_resolution=[3000,2000] & !p.charsize=3.25 & !p.font=-1 & !p.background=!d.n_colors-1
  top_top_y=0.93 & dy=0.1 & top_y=0.95 & bot_y=top_y-dy & sep_y=0.05
  sx=0.12 & sy=0.06 & xl=0.1 & xr=0.9 & yt=0.95 & yb=0.1
  !p.thick=3. & numplots_x=3 & numplots_y=3
  position_plots,xl,xr,yb,yt,sx,sy,numplots_x,numplots_y,pos
  cbpos=pos & cbpos[*,0]=cbpos[*,2]+0.08 & cbpos[*,2]=cbpos[*,0]+0.012
  !p.multi=[0,4,4]

  pnum=8

  plot, nd_bins, nd_0250km_pre_histo1/float(total(nd_0250km_pre_histo1)), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='Nd per cc', ytitle='Frequency', title='MODIS Nd Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.25, charthick=4, xrange=[-100.,400.],yrange=[0.,0.15] ;max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])

  oplot, nd_bins,nd_0250km_post_post_histo2/float(total(nd_0250km_post_post_histo2)), psym=10, color=100

  xyouts, mean(nd_bins[where(lwp_bins ge 0.)]), median(nd_0250km_pre_histo1/float(total(nd_0250km_pre_histo1))), $
    strtrim(string(prob_nd_250, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data
  
  cdfid=ncdf_create(output_path+'nd_modis_histo.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(nd_bins))
  bins_id=ncdf_vardef(cdfid, 'Nd_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'nd bins'
  ncdf_attput, cdfid, bins_id, 'units', 'number per cubic centimeter'
  pre_id=ncdf_vardef(cdfid, 'Nd_pre_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of nd of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'Nd_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of nd of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
  ncdf_attput, cdfid, d_id, 'units', 'unitless'
  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
  ncdf_attput, cdfid, prob_id, 'units', 'unitless'

  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, nd_bins
  ncdf_varput, cdfid, pre_id, nd_0250km_pre_histo1/float(total(nd_0250km_pre_histo1))
  ncdf_varput, cdfid, post_id,nd_0250km_post_post_histo2/float(total(nd_0250km_post_post_histo2))
  ncdf_varput, cdfid, d_id, d_nd_250
  ncdf_varput, cdfid, prob_id, prob_nd_250
  ncdf_close, cdfid

  pnum=7

  plot, re_bins[where(re_bins ge 0. and re_bins lt 25.)], re_0250km_pre_histo1[where(re_bins ge 0. and re_bins lt 25.)]/float(total(re_0250km_pre_histo1[where(re_bins ge 0. and re_bins lt 25.)])), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='re (microns)', ytitle='Frequency', title='MODIS re Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.25, charthick=4, yrange=[0.,max([re_0250km_pre_histo1/float(total(re_0250km_pre_histo1)),re_0250km_post_post_histo2/float(total(re_0250km_post_post_histo2))])]

  oplot, re_bins[where(re_bins ge 0. and re_bins lt 25.)],re_0250km_post_post_histo2[where(re_bins ge 0. and re_bins lt 25.)]/float(total(re_0250km_post_post_histo2[where(re_bins ge 0. and re_bins lt 25.)])), psym=10, color=100

  xyouts, mean(re_bins[where(re_bins ge 0. and re_bins lt 25.)]), median(re_0250km_pre_histo1[where(re_bins ge 0. and re_bins lt 25.)]/float(total(re_0250km_pre_histo1[where(re_bins ge 0. and re_bins lt 25.)]))), $
    strtrim(string(prob_re_250, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data


  cdfid=ncdf_create(output_path+'re_modis_histo.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(re_bins[where(re_bins ge 0. and re_bins lt 25.)]))
  bins_id=ncdf_vardef(cdfid, 're_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 're bins'
  ncdf_attput, cdfid, bins_id, 'units', 'microns'
  pre_id=ncdf_vardef(cdfid, 're_pre_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of re of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 're_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of re of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
  ncdf_attput, cdfid, d_id, 'units', 'unitless'
  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
  ncdf_attput, cdfid, prob_id, 'units', 'unitless'

  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, re_bins[where(re_bins ge 0. and re_bins lt 25.)]
  ncdf_varput, cdfid, pre_id, re_0250km_pre_histo1[where(re_bins ge 0. and re_bins lt 25.)]/float(total(re_0250km_pre_histo1[where(re_bins ge 0. and re_bins lt 25.)]))
  ncdf_varput, cdfid, post_id,re_0250km_post_post_histo2[where(re_bins ge 0. and re_bins lt 25.)]/float(total(re_0250km_post_post_histo2[where(re_bins ge 0. and re_bins lt 25.)]))
  ncdf_varput, cdfid, d_id, d_re_250
  ncdf_varput, cdfid, prob_id, prob_re_250
  ncdf_close, cdfid


  pnum=4
  
  

  plot, alb_bins[where(alb_bins ge 0.)], alb_0250km_pre_histo1[where(alb_bins ge 0.)]/float(total(alb_0250km_pre_histo1[where(alb_bins ge 0.)])), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='albedo ', ytitle='Frequency', title='CERES Albedo Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.25, charthick=4, yrange=[0.,0.25]

  oplot, alb_bins[where(alb_bins ge 0.)],alb_0250km_post_post_histo2[where(alb_bins ge 0.)]/float(total(alb_0250km_post_post_histo2[where(alb_bins ge 0.)])), psym=10, color=100

  xyouts, mean(alb_bins[where(alb_bins ge 0.)]), median(alb_0250km_pre_histo1[where(alb_bins ge 0.)]/float(total(alb_0250km_pre_histo1[where(alb_bins ge 0.)]))), $
    strtrim(string(prob_alb_250, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data

  cdfid=ncdf_create(output_path+'albedo_modis_histo.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(alb_bins[where(alb_bins ge 0.)]))
  bins_id=ncdf_vardef(cdfid, 'albedo_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'albedo bins'
  ncdf_attput, cdfid, bins_id, 'units', 'unitess'
  pre_id=ncdf_vardef(cdfid, 'albedo_pre_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of albedo of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'albedo_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of albedo of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
  ncdf_attput, cdfid, d_id, 'units', 'unitless'
  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
  ncdf_attput, cdfid, prob_id, 'units', 'unitless'

  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, alb_bins[where(alb_bins ge 0.)]
  ncdf_varput, cdfid, pre_id, alb_0250km_pre_histo1[where(alb_bins ge 0.)]/float(total(alb_0250km_pre_histo1[where(alb_bins ge 0.)]))
  ncdf_varput, cdfid, post_id,alb_0250km_post_post_histo2[where(alb_bins ge 0.)]/float(total(alb_0250km_post_post_histo2[where(alb_bins ge 0.)]))
  ncdf_varput, cdfid, d_id, d_alb_250
  ncdf_varput, cdfid, prob_id, prob_alb_250
  ncdf_close, cdfid


  pnum=1

  plot, lwp_bins[where(lwp_bins ge 0.)], lwp_0250km_pre_histo1[where(lwp_bins ge 0.)]/float(total(lwp_0250km_pre_histo1[where(lwp_bins ge 0.)])), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='LWP g/m2', ytitle='Frequency', title='MODIS LWP Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.25, charthick=4, yrange=[0.,max([lwp_0250km_pre_histo1/float(total(lwp_0250km_pre_histo1)),lwp_0250km_post_post_histo2/float(total(lwp_0250km_post_post_histo2))])]

  oplot, lwp_bins[where(lwp_bins ge 0.)],lwp_0250km_post_post_histo2[where(lwp_bins ge 0.)]/float(total(lwp_0250km_post_post_histo2[where(lwp_bins ge 0.)])), psym=10, color=100

  xyouts, mean(lwp_bins[where(lwp_bins ge 0.)]), median(lwp_0250km_pre_histo1[where(lwp_bins ge 0.)]/float(total(lwp_0250km_pre_histo1[where(lwp_bins ge 0.)]))), $
    strtrim(string(prob_lwp_250, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data

  cdfid=ncdf_create(output_path+'lwp_modis_histo.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(lwp_bins[where(lwp_bins ge 0.)]))
  bins_id=ncdf_vardef(cdfid, 'lwp_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'lwp bins'
  ncdf_attput, cdfid, bins_id, 'units', 'grams per sq meter'
  pre_id=ncdf_vardef(cdfid, 'lwp_pre_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of lwp of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'lwp_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of lwp of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
  ncdf_attput, cdfid, d_id, 'units', 'unitless'
  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
  ncdf_attput, cdfid, prob_id, 'units', 'unitless'

  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, lwp_bins[where(lwp_bins ge 0.)]
  ncdf_varput, cdfid, pre_id, lwp_0250km_pre_histo1[where(lwp_bins ge 0.)]/float(total(lwp_0250km_pre_histo1[where(lwp_bins ge 0.)]))
  ncdf_varput, cdfid, post_id,lwp_0250km_post_post_histo2[where(lwp_bins ge 0.)]/float(total(lwp_0250km_post_post_histo2[where(lwp_bins ge 0.)]))
  ncdf_varput, cdfid, d_id, d_lwp_250
  ncdf_varput, cdfid, prob_id, prob_lwp_250
  ncdf_close, cdfid

  pnum=5

  plot, optical_depth_bins[where(optical_depth_bins ge 0.)], optical_depth_pre_histo1[where(optical_depth_bins ge 0.)]/float(total(optical_depth_pre_histo1[where(optical_depth_bins ge 0.)])), color=0,$
    pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='optical depth ', ytitle='Frequency', title='MODIS Optical Depth Pre 2020 (black), Post 2020 (red) ',  $
    charsize=3.25, charthick=4, yrange=[0.,max(optical_depth_pre_histo1[where(optical_depth_bins ge 0.)]/float(total(optical_depth_pre_histo1[where(optical_depth_bins ge 0.)])))]

  oplot, optical_depth_bins[where(optical_depth_bins ge 0.)],optical_depth_post_histo2[where(optical_depth_bins ge 0.)]/float(total(optical_depth_post_histo2[where(optical_depth_bins ge 0.)])), psym=10, color=100

  xyouts, mean(optical_depth_bins[where(optical_depth_bins ge 0.)]), median(optical_depth_pre_histo1[where(optical_depth_bins ge 0.)]/float(total(optical_depth_pre_histo1[where(optical_depth_bins ge 0.)]))), $
    strtrim(string(prob_tau_250, format='(f4.2)'),2), color=0, charsize=3., charthick=4., /data

  cdfid=ncdf_create(output_path+'optical_depth_modis_histo.cdf',/clobber)
  event_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(optical_depth_bins[where(optical_depth_bins ge 0.)]))
  bins_id=ncdf_vardef(cdfid, 'optical_depth_Bins',[event_did],/float)
  ncdf_attput, cdfid, bins_id, 'long_name', 'optical depth bins'
  ncdf_attput, cdfid, bins_id, 'units', 'unitless'
  pre_id=ncdf_vardef(cdfid, 'optical_depth_pre_histo1',[event_did],/float)
  ncdf_attput, cdfid, pre_id, 'long_name', 'Counts of optical depth of the Pre Fuel Change Period'
  ncdf_attput, cdfid, pre_id, 'units', 'counts'
  post_id=ncdf_vardef(cdfid, 'optical_depth_post_histo2',[event_did],/float)
  ncdf_attput, cdfid, post_id, 'long_name', 'Counts of optical depth of the Post Fuel Change Period'
  ncdf_attput, cdfid, post_id, 'units', 'counts'
  d_id=ncdf_vardef(cdfid, 'ks_statistic_d',/float)
  ncdf_attput, cdfid, d_id, 'long_name', 'ks_statistic_d'
  ncdf_attput, cdfid, d_id, 'units', 'unitless'
  prob_id=ncdf_vardef(cdfid, 'prob_reject_null',/float)
  ncdf_attput, cdfid, prob_id, 'long_name', 'Probability that distributions are drawn from same sample'
  ncdf_attput, cdfid, prob_id, 'units', 'unitless'

  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, bins_id, optical_depth_bins[where(optical_depth_bins ge 0.)]
  ncdf_varput, cdfid, pre_id, optical_depth_pre_histo1[where(optical_depth_bins ge 0.)]/float(total(optical_depth_pre_histo1[where(optical_depth_bins ge 0.)]))
  ncdf_varput, cdfid, post_id,optical_depth_post_histo2[where(optical_depth_bins ge 0.)]/float(total(optical_depth_post_histo2[where(optical_depth_bins ge 0.)]))
  ncdf_varput, cdfid, d_id, d_tau_250
  ncdf_varput, cdfid, prob_id, prob_tau_250
  ncdf_close, cdfid

  write_gif, output_path+'MODIS_CERES_comp_PRE_POST.gif',tvrd()

stop
end


;  lwp_0250km_pre(lwp_0250km_pre) ;
;  lwp_0250km_post(lwp_0250km_post) ;
;  nd_0250km_pre(nd_0250km_pre) ;
;  nd_0250km_post(nd_0250km_post) ;
;  re_0250km_pre(re_0250km_pre) ;
;  re_0250km_post(re_0250km_post) ;
;  tau_0250km_pre(tau_0250km_pre) ;
;  tau_0250km_post(tau_0250km_post) ;
;  alb_0250km_pre(alb_0250km_pre) ;
;  alb_0250km_post(alb_0250km_post) ;
;  temp_0250km_pre(temp_0250km_pre) ;
;  temp_0250km_post(temp_0250km_post) ;
;  lwp_0500km_pre(lwp_0500km_pre) ;
;  lwp_0500km_post(lwp_0500km_post) ;
;  nd_0500km_pre(nd_0500km_pre) ;
;  nd_0500km_post(nd_0500km_post) ;
;  re_0500km_pre(re_0500km_pre) ;
;  re_0500km_post(re_0500km_post) ;
;  tau_0500km_pre(tau_0500km_pre) ;
;  tau_0500km_post(tau_0500km_post) ;
;  alb_0500km_pre(alb_0500km_pre) ;
;  alb_0500km_post(alb_0500km_post) ;
;  temp_0500km_pre(temp_0500km_pre) ;
;  temp_0500km_post(temp_0500km_post) ;
;  lwp_1000km_pre(lwp_1000km_pre) ;
;  lwp_1000km_post(lwp_1000km_post) ;
;  nd_1000km_pre(nd_1000km_pre) ;
;  nd_1000km_post(nd_1000km_post) ;
;  re_1000km_pre(re_1000km_pre) ;
;  re_1000km_post(re_1000km_post) ;
;  tau_1000km_pre(tau_1000km_pre) ;
;  tau_1000km_post(tau_1000km_post) ;
;  alb_1000km_pre(alb_1000km_pre) ;
;  alb_1000km_post(alb_1000km_post) ;
;  temp_1000km_pre(temp_1000km_pre) ;
;  temp_1000km_post(temp_1000km_post) ;