pro ena_ks_test

;Small values of PROB show that the
;  cumulative distribution function of DATA1 is significantly
;  different from DATA2

  ;;;;;;;;;  write nd data
  cdfid=ncdf_open('/Users/u0029340/Documents/data/ena/graphics/albedo.cdf')
  x_id=ncdf_varid(cdfid, 'albedo_pre') & ncdf_varget, cdfid, x_id, albedo_pre
  x_id=ncdf_varid(cdfid, 'albedo_post') & ncdf_varget, cdfid, x_id, albedo_post
  ncdf_close, cdfid
  kstwo_nin, albedo_pre, albedo_post, d, prob, 250
  
  print, 'albdeo ', d, prob
  
  ;;;;;;;;;  write nd data
  ;cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/ccn.cdf',/clobber)

  cdfid=ncdf_open('/Users/u0029340/Documents/data/ena/graphics/ccn.cdf')
  x_id=ncdf_varid(cdfid, 'ccn_pre') & ncdf_varget, cdfid, x_id, ccn_pre
  x_id=ncdf_varid(cdfid, 'ccn_post') & ncdf_varget, cdfid, x_id, ccn_post
  ncdf_close, cdfid

  kstwo_nin, ccn_pre, ccn_post, d, prob, 250

  print, 'ccn ', d, prob
  
  ;;;;;;;;;  write nd data
  cdfid=ncdf_open('/Users/u0029340/Documents/data/ena/graphics/optical_depth.cdf')
  x_id=ncdf_varid(cdfid, 'optical_depth_pre') & ncdf_varget, cdfid, x_id, albedo_pre
  x_id=ncdf_varid(cdfid, 'optical_depth_post') & ncdf_varget, cdfid, x_id, albedo_post
  ncdf_close, cdfid

  kstwo_nin, albedo_pre, albedo_post, d, prob, 250

  print, 'optical depth ', d, prob

  ;;;;;;;;;  write nd data
  cdfid=ncdf_open('/Users/u0029340/Documents/data/ena/graphics/rain_rate.cdf')
  x_id=ncdf_varid(cdfid, 'rain_rate_pre') & ncdf_varget, cdfid, x_id, rain_rate_pre
  x_id=ncdf_varid(cdfid, 'rain_rate_post') & ncdf_varget, cdfid, x_id, rain_rate_post
  ncdf_close, cdfid

  kstwo_nin, rain_rate_pre, rain_rate_post, d, prob, 250

  print, 'rain rate ', d, prob

  ;;;;;;;;;  write nd data
  cdfid=ncdf_open('/Users/u0029340/Documents/data/ena/graphics/re_oe.cdf')
  x_id=ncdf_varid(cdfid, 're_top_oe_pre') & ncdf_varget, cdfid, x_id, albedo_pre
  x_id=ncdf_varid(cdfid, 're_top_oe_post') & ncdf_varget, cdfid, x_id, albedo_post
  ncdf_close, cdfid

  kstwo_nin, albedo_pre, albedo_post, d, prob, 250

  print, 're_oe ', d, prob

  ;;;;;;;;;  write nd data
  cdfid=ncdf_open('/Users/u0029340/Documents/data/ena/graphics/nd_oe.cdf')
  x_id=ncdf_varid(cdfid, 'nd_oe_pre') & ncdf_varget, cdfid, x_id, nd_pre
  x_id=ncdf_varid(cdfid, 'nd_oe_post') & ncdf_varget, cdfid, x_id, nd_post
  ncdf_close, cdfid

  kstwo_nin, nd_pre, nd_post, d, prob, 250

  print, 'nd_oe ', d, prob

  ;;;;;;;;;  write nd data
  cdfid=ncdf_open('/Users/u0029340/Documents/data/ena/graphics/lwp_oe.cdf')
  x_id=ncdf_varid(cdfid, 'lwp_oe_pre') & ncdf_varget, cdfid, x_id, lwp_pre
  x_id=ncdf_varid(cdfid, 'lwp_oe_post') & ncdf_varget, cdfid, x_id, lwp_post
  ncdf_close, cdfid

  kstwo_nin, lwp_pre, lwp_post, d, prob, 250

  print, 'lwp_oe ', d, prob
  
  ;;;;;;;;;  write nd data
  cdfid=ncdf_open('/Users/u0029340/Documents/data/ena/graphics/wind_speed_during_clds.cdf')
  x_id=ncdf_varid(cdfid, 'w_spd_cld_pre') & ncdf_varget, cdfid, x_id, albedo_pre
  x_id=ncdf_varid(cdfid, 'w_spd_cld_post') & ncdf_varget, cdfid, x_id, albedo_post
  ncdf_close, cdfid

  kstwo_nin, albedo_pre, albedo_post, d, prob, 250

  print, 'wind speed ', d, prob

  ;;;;;;;;;  write nd data
  cdfid=ncdf_open('/Users/u0029340/Documents/data/ena/graphics/pwv.cdf')
  x_id=ncdf_varid(cdfid, 'pwv_pre') & ncdf_varget, cdfid, x_id, albedo_pre
  x_id=ncdf_varid(cdfid, 'pwv_post') & ncdf_varget, cdfid, x_id, albedo_post
  ncdf_close, cdfid

  kstwo_nin, albedo_pre, albedo_post, d, prob, 250

  print, 'pwv ', d, prob
  
  lin_histo_2_logplot, rain_rate_pre[where(rain_rate_pre gt 0.0)], rain_rate_post[where(rain_rate_post gt 0.0)], 3, 40, rain_pre_histo1, rain_post_histo2, rain_bins, $
    rain_pre_moments1, rain_post_moments2, rain_pre_med1, rain_post_med2, num, 1.e-5, 50., 1.2

rain_cdf_pre=fltarr(n_elements(rain_bins))
rain_cdf_post=fltarr(n_elements(rain_bins))

for j=0,n_elements(rain_bins)-1 do begin
  rain_cdf_pre[j]=float(total(rain_pre_histo1[0:j]))
  rain_cdf_post[j]=float(total(rain_post_histo2[0:j]))
endfor

set_plot, 'Z'
loadct, 5 & gamma_ct, 1.0 & set_plot, 'Z' & device, set_resolution=[3000,2000] & !p.charsize=3.75 & !p.font=-1 & !p.background=!d.n_colors-1
top_top_y=0.93 & dy=0.1 & top_y=0.95 & bot_y=top_y-dy & sep_y=0.05
sx=0.12 & sy=0.06 & xl=0.1 & xr=0.9 & yt=0.95 & yb=0.1
!p.thick=3. & numplots_x=3 & numplots_y=3
position_plots,xl,xr,yb,yt,sx,sy,numplots_x,numplots_y,pos
cbpos=pos & cbpos[*,0]=cbpos[*,2]+0.08 & cbpos[*,2]=cbpos[*,0]+0.012
!p.multi=[0,4,4]

pnum=8

plot, rain_bins, rain_cdf_pre/float(total(rain_pre_histo1)), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='Drizzle Rate (mm/day)', ytitle='Cumulative Frequency', title='Drizzle Rate (mm/day) Pre 2020 (black), Post 2020 (red) ',  $
  charsize=4., charthick=3,/xlog;max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])

oplot, rain_bins, rain_cdf_post/float(total(rain_post_histo2)), psym=10, color=100

pnum=6

plot, rain_bins, rain_cdf_pre/float(total(rain_pre_histo1)), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='Drizzle Rate (mm/day)', ytitle='Cumulative Frequency', title='Drizzle Rate (mm/day) Pre 2020 (black), Post 2020 (red) ',  $
  charsize=4., charthick=3,/xlog, /ylog;max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])

oplot, rain_bins, rain_cdf_post/float(total(rain_post_histo2)), psym=10, color=100


write_gif, '/Users/u0029340/Documents/data/ena/graphics/rain_cdf_PRE_POST.gif',tvrd()

 
stop
  end
  

;  event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(albedo_pre[conditions_cloud_pre]))
;  event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(albedo_post[conditions_cloud_post]))
;  albedo_pre_id=ncdf_vardef(cdfid, 'albedo_pre',[event_pre_did],/float)
;  ncdf_attput, cdfid, albedo_pre_id, 'long_name', 'albedo Pre 2020'
;  ncdf_attput, cdfid, albedo_pre_id, 'units', 'unitless'
;  albedo_post_id=ncdf_vardef(cdfid, 'albedo_post',[event_post_did],/float)
;  ncdf_attput, cdfid, albedo_post_id, 'long_name', 'albedo Post 2020'
;  ncdf_attput, cdfid, albedo_post_id, 'units', 'unitless'
;  ncdf_control, cdfid, /endef
;  ncdf_varput, cdfid, albedo_pre_id, albedo_pre[conditions_cloud_pre]
;  ncdf_varput, cdfid, albedo_post_id, albedo_post[conditions_cloud_post]
;  ncdf_close, cdfid
  
  