pro dlnbeta_dz_fit_submaxz_sb, beta_b,z,slope, y_intercept, chsqr, fit_copol, sig_values, i_max, i_down

; fit the dln(beta)_dz below the maximum in attenuated backscatter.
; beta_b is attenuated backscatter in per meter per steradian from cloud base to cloud top
; z_in is height in meters of the beta_b values
; slope is the slope dln(beta)_dz.  returns -9999 when the fit can't be done
; y_intercept is the ln(beta) at z=0. returns -9999 when the fit can't be done
; chsqr is the chi squared goodness of fit 
; yfit_copol is the fitted values of the ln(Beta_b)
; sig_values is the 1 sigma uncertainty of the linear fit parameters 
; i_max is the vertical index of the top value of the fit 
; i_down is the vertical index of the bottom fitted value
; written by Jay Mace, June 2023.
; 
; 
; 
;where is the maximum in beta?

;  Calculate the log of beta
lnbeta_b=beta_b
;  Put negative numbers to really small numbers
r=where(beta_b le 0,c)
if c gt 0 then lnbeta_b[r]=1e-9
;  Take the log
;lnbeta_b=alog(beta_b[where(beta_b gt 0.)])
lnbeta_b=alog(lnbeta_b)
;z=z_in[where(beta_b gt 0.)]

;  index of maximum backscatter
i_max=where(lnbeta_b eq max(lnbeta_b))

; come down 1 range bin from max backscatter
i_max=i_max-1
;  come down 2 range bins from max backscatter
i_down=i_max-1

; go down at least 30 meters or the bottom of the cloud 
;print,'i_down ',i_down,'i_max ',i_max
dh=0.03  ;30 for meters
while z[i_max]-z[i_down] le dh and i_down gt 0 do begin  
  i_down=i_down-1
endwhile
i_down=i_down+1

while beta_b[i_down]/beta_b[i_max] gt 0.5 and (i_max-i_down)*(z[i_max]-z[i_max-1]) lt 0.1 do i_down=i_down-1
i_top=i_down
while beta_b[i_down]/beta_b[i_max] gt 0.1 and (i_max-i_down)*(z[i_max]-z[i_max-1]) lt 0.2 do i_down=i_down-1
i_bot=i_down
;print,'i_down ',i_down,'i_max ',i_max

if i_max-i_down ge 1 then begin
;  y=lnbeta_b[i_down:i_max]
;  x=z[i_down:i_max]
;  error_vector=abs(0.01*lnbeta_b[i_down:i_max])
  
  y=lnbeta_b[i_bot:i_top]
  x=z[i_bot:i_top]
  error_vector=abs(0.01*lnbeta_b[i_bot:i_top])

if n_elements(x) gt 1 and n_elements(y) gt 1 then begin
  result=linfit(x,y,measure_errors=abs(error_vector), chisqr=chsqr, $
    yfit=fit_copol,sigma=sig_values)
endif else begin
  slope=-9999.
  y_intercept=-9999.
  return
endelse

endif else begin  ; if i_max ge 3 then begin
  slope=-9999.
  y_intercept=-9999.
  return
endelse

slope=result[1]
y_intercept=result[0]

return
end