pro compare_ena_ccn_mwr_cloud

; purpose is to compare CCN stats at ENA prior to and after IMO2020 marine fuels change to see if CCN changes.

; get the pre 2020 files. 
; 
jday1=julday(1,1,1970,0,0,0)

sfc_met_dir='/Users/u0029340/Documents/data/ena/enaaosmetC1.a1/'
ccn1_dir='/Users/u0029340/Documents/data/ena/enaaosccn1colavgC1.b1/'
mwr_path='/Users/u0029340/Documents/data/ena/enamwr3cC1.b1/'
ccn2_dir='/Users/u0029340/Documents/data/ena/enaaosccn2colaavgC1.b1/'
cloud_dir='/Users/u0029340/Documents/data/ena/cloud_precip_0p2/'


months=['201605','201606','201607','201608','201609',$
  '201705','201706','201707','201708','201709',$
  '201805','201806','201807','201808','201809']
  
;  months=['201606','201607','201608','201609',$
;    '201706','201707','201708','201709',$
;    '201806','201807','201808','201809']
    
;    ;months=['201606','201607','201608','201609'];,$
;;months=['201706','201707','201708','201709'];,$
;months=['201806','201807','201808','201809']
;
; 
;;  months=['201606','201607','201608',$
;;    '201706','201707','201708',$
;;    '201806','201807','201808']
 

  
;  get the pre surface met data
  
  for jj=1,n_elements(months)-1 do begin
    
    
    ;;;;; get cloud data
    cloud_files=file_search(cloud_dir+'/*/nd_retrieval.ena.'+months[jj]+'*.avg.30sec.15m.retavg_05min.cdf', count=count)
    for j=0,count-1 do begin
      cdfid=ncdf_open(cloud_files[j])
      x_id=ncdf_varid(cdfid, 'lwp_oe') & ncdf_varget,cdfid,x_id, lwp_oe1
      x_id=ncdf_varid(cdfid, 'fad_oe') & ncdf_varget,cdfid,x_id, fad_oe1
     x_id=ncdf_varid(cdfid, 'm_test_output') & ncdf_varget,cdfid,x_id, m_test_output1
      x_id=ncdf_varid(cdfid, 'nd_oe') & ncdf_varget,cdfid,x_id, nd_oe1
      x_id=ncdf_varid(cdfid, 're_top_oe') & ncdf_varget,cdfid,x_id, re_top_oe1
      x_id=ncdf_varid(cdfid, 'ccn_array') & ncdf_varget,cdfid,x_id, ccn_array1
      x_id=ncdf_varid(cdfid, 'julian_day') & ncdf_varget,cdfid,x_id, julian_day1
      ncdf_close, cdfid
      
      optical_depth1=fltarr(n_elements(lwp_oe1))
      albedo1=fltarr(n_elements(lwp_oe1))
      for jjj=0, n_elements(lwp_oe1)-1 do begin
        if lwp_oe1[jjj] gt 0. then begin
          ;optical_depth1[jjj]=1.5*(lwp_post[jjj])/(re_top_oe_post[jjj])
          ccm3_radiative_param_shortwave, 0.55, lwp_oe1[jjj]*fad_oe1[jjj], re_top_oe1[jjj], tau, omega, g  ; reference Slingo 1989.
          optical_depth1[jjj]=tau
          albedo1[jjj]=((1.-g)*tau)/(2.+((1.-g)*tau)) ; reference Platnick and Twomey (1994)
        endif
      endfor

    
;    if max(lwp_oe1) gt 0. then begin
;    if n_elements(lwp_oe_pre) eq 0 then begin
;      lwp_oe_pre=lwp_oe1[where(lwp_oe1 gt 0.)]*fad_oe1[where(lwp_oe1 gt 0.)]
;      m_test_output_pre=m_test_output1[where(lwp_oe1 gt 0.)]
;      nd_oe_pre=nd_oe1[where(lwp_oe1 gt 0.)]
;      re_top_oe_pre=re_top_oe1[where(lwp_oe1 gt 0.)]
;      ccn_array_oe_pre=ccn_array1[where(lwp_oe1 gt 0.)]
;      albedo_pre=albedo1[where(lwp_oe1 gt 0.)]
;      optical_depth_pre=optical_depth1[where(lwp_oe1 gt 0.)]
;    endif else begin
;      lwp_oe_pre=[lwp_oe_pre,lwp_oe1[where(lwp_oe1 gt 0.)]*fad_oe1[where(lwp_oe1 gt 0.)]]
;      m_test_output_pre=[m_test_output_pre,m_test_output1[where(lwp_oe1 gt 0.)]]
;      nd_oe_pre=[nd_oe_pre, nd_oe1[where(lwp_oe1 gt 0.)]]
;      re_top_oe_pre=[re_top_oe_pre, re_top_oe1[where(lwp_oe1 gt 0.)]]
;      ccn_array_oe_pre=[ccn_array_oe_pre,ccn_array1[where(lwp_oe1 gt 0.)]]
;      albedo_pre=[albedo_pre,albedo1[where(lwp_oe1 gt 0.)]]
;      optical_depth_pre=[optical_depth_pre, optical_depth1[where(lwp_oe1 gt 0.)]]
;    endelse
;    endif
;    
;    if max(lwp_oe1) gt 0. then begin
      if n_elements(lwp_oe_pre) eq 0 then begin
        lwp_oe_pre=lwp_oe1*fad_oe1
        m_test_output_pre=m_test_output1
        nd_oe_pre=nd_oe1
        re_top_oe_pre=re_top_oe1
        ccn_array_oe_pre=ccn_array1
        albedo_pre=albedo1
        optical_depth_pre=optical_depth1
      endif else begin
        lwp_oe_pre=[lwp_oe_pre,lwp_oe1*fad_oe1]
        m_test_output_pre=[m_test_output_pre,m_test_output1]
        nd_oe_pre=[nd_oe_pre, nd_oe1]
        re_top_oe_pre=[re_top_oe_pre, re_top_oe1]
        ccn_array_oe_pre=[ccn_array_oe_pre,ccn_array1]
        albedo_pre=[albedo_pre,albedo1]
        optical_depth_pre=[optical_depth_pre, optical_depth1]
      endelse
;    endif

    endfor


;;;; get drizzle data
cloud_files=file_search(cloud_dir+'/*/nd_retrieval.ena.'+months[jj]+'*.avg.30sec.15m.cdf', count=count)
for j=0,count-1 do begin
  cdfid=ncdf_open(cloud_files[j])
  x_id=ncdf_varid(cdfid, 'rain_rate') & ncdf_varget,cdfid,x_id, rain_rate1
  x_id=ncdf_varid(cdfid, 'dbz_avg_subcloud') & ncdf_varget,cdfid,x_id, dbz_avg_subcloud1
  x_id=ncdf_varid(cdfid, 'low_cloud_flag') & ncdf_varget,cdfid,x_id, low_cloud_flag1
  x_id=ncdf_varid(cdfid, 'julian_day') & ncdf_varget,cdfid,x_id, julian_day1

  ncdf_close, cdfid

;if max(dbz_avg_subcloud1) gt 0. then begin
;  if n_elements(rain_rate_pre) eq 0 then begin
;    rain_rate_pre=rain_rate1[where(rain_rate1 gt 0.)]
;    dbz_avg_subcloud_pre=dbz_avg_subcloud1[where(dbz_avg_subcloud1 gt 0.)]
;    low_cloud_flag_pre=low_cloud_flag1
;    julian_day_ret_pre=julian_day1[where(lwp_oe1 gt 0.)]
;  endif else begin
;    rain_rate_pre=[rain_rate_pre,rain_rate1[where(rain_rate1 gt 0.)]]
;    dbz_avg_subcloud_pre=[dbz_avg_subcloud_pre,dbz_avg_subcloud1[where(dbz_avg_subcloud1 gt 0.)]]
;    low_cloud_flag_pre=[low_cloud_flag_pre,low_cloud_flag1]
;    julian_day_ret_pre=[julian_day_ret_pre,julian_day1[where(lwp_oe1 gt 0.)]]
;  endelse
;endif

;if max(dbz_avg_subcloud1) gt 0. then begin
  if n_elements(rain_rate_pre) eq 0 then begin
    rain_rate_pre=rain_rate1
    dbz_avg_subcloud_pre=dbz_avg_subcloud1
    low_cloud_flag_pre=low_cloud_flag1
    julian_day_ret_pre=julian_day1
  endif else begin
    rain_rate_pre=[rain_rate_pre,rain_rate1]
    dbz_avg_subcloud_pre=[dbz_avg_subcloud_pre,dbz_avg_subcloud1]
    low_cloud_flag_pre=[low_cloud_flag_pre,low_cloud_flag1]
    julian_day_ret_pre=[julian_day_ret_pre,julian_day1]
  endelse
;endif

endfor



smet_files=file_search(sfc_met_dir+'enaaosmetC1.a1.'+months[jj]+'*.*', count=count)


for j=0,count-1 do begin
  
  cdfid=ncdf_open(smet_files[j])
  ;cdfid=ncdf_open(radar_path+radar_file,/nowrite)

  x_id=ncdf_varid(cdfid, 'base_time') & ncdf_varget,cdfid,x_id,base_time
  x_id=ncdf_varid(cdfid, 'time_offset') & ncdf_varget,cdfid,x_id,time_offset
  x_id=ncdf_varid(cdfid, 'wind_speed') 
  if x_id gt 0. then begin
  ncdf_varget,cdfid,x_id,wind_speed1
  x_id=ncdf_varid(cdfid, 'wind_direction') & ncdf_varget,cdfid,x_id,wind_dir1
  endif else begin
    x_id=ncdf_varid(cdfid, 'WindDirection') & ncdf_varget,cdfid,x_id,wind_dir1
    x_id=ncdf_varid(cdfid, 'WindSpeed') & ncdf_varget,cdfid,x_id,wind_speed1
  endelse
  ncdf_close, cdfid
  
  ; subsample the met data
  for kk=0,n_elements(time_offset),25 do begin
    if kk lt n_elements(time_offset)-1 then begin
    if kk eq 0 then begin
    time_offset_temp=time_offset[kk]
    wind_dir_temp=wind_dir1[kk]
    wind_speed_temp=wind_speed1[kk]
    endif else begin
      time_offset_temp=[time_offset_temp,time_offset[kk]]
      wind_dir_temp=[wind_dir_temp,wind_dir1[kk]]
      wind_speed_temp=[wind_speed_temp,wind_speed1[kk]]
    endelse
    endif
  endfor
  time_offset=time_offset_temp
  wind_dir1=wind_dir_temp
  wind_speed1=wind_speed_temp

julday1=jday1+((double(base_time)+time_offset)/86400.d)

if n_elements(julday_smet) eq 0 then begin
  julday_smet=julday1
  wind_speed=wind_speed1
  wind_dir=wind_dir1
endif else begin
  julday_smet=[julday_smet,julday1]
  wind_speed=[wind_speed, wind_speed1]
  wind_dir=[wind_dir, wind_dir1]
endelse
  
endfor

endfor  ; for jj=0,n_elements(months)-1 do begin

; get the pre mwr data
for jj=0,n_elements(months)-1 do begin

  mwr_files=file_search(mwr_path+'enamwr3cC1.b1.'+months[jj]+'*.*', count=count)

  for j=0,count-1 do begin

    cdfid=ncdf_open(mwr_files[j])
    ;cdfid=ncdf_open(radar_path+radar_file,/nowrite)

    x_id=ncdf_varid(cdfid, 'base_time') & ncdf_varget,cdfid,x_id,base_time
    x_id=ncdf_varid(cdfid, 'time_offset') & ncdf_varget,cdfid,x_id,time_offset
    x_id=ncdf_varid(cdfid, 'lwp') & ncdf_varget,cdfid,x_id,lwp1
    x_id=ncdf_varid(cdfid, 'lwp_err') & ncdf_varget,cdfid,x_id,lwp_err1
    x_id=ncdf_varid(cdfid, 'pwv') & ncdf_varget,cdfid,x_id,pwv1
    x_id=ncdf_varid(cdfid, 'pwv_err') & ncdf_varget,cdfid,x_id,pwv_err1
    x_id=ncdf_varid(cdfid, 'infrared_temperature') & ncdf_varget,cdfid,x_id,infrared_temperature1
    x_id=ncdf_varid(cdfid, 'rain_flag') & ncdf_varget,cdfid,x_id,rain_flag1
    x_id=ncdf_varid(cdfid, 'lat') & ncdf_varget,cdfid,x_id,lat
    x_id=ncdf_varid(cdfid, 'lon') & ncdf_varget,cdfid,x_id,lon
    ncdf_close, cdfid

    ;;;; create hourly means.  time res is ~3 seconds.
    kk=0l & first_flag=1
    while kk+450l lt n_elements(time_offset)-1 do begin
;      i=where(lwp1[kk:kk+450]*1.e3 gt 20. and rain_flag1[kk:kk+450] eq 0 and $
;        (infrared_temperature1[kk:kk+450]) gt 273.)
        i=where(rain_flag1[kk:kk+450] eq 0)
      if first_flag eq 1 then begin
        first_flag=0
        if n_elements(i) gt 10 then begin
          i=lwp1[kk+i]
          d=where(i gt 0., count)
          if count gt 0. then begin
            lwp11=mean(i[where(i gt 0.)])
          endif else begin
            lwp11=0.
          endelse
          ;lwp11=mean(i[where(i gt 0.)])
          pwv11=mean(pwv1[kk+i])
          time_offset11=mean(time_offset[kk+i])
          irt11=mean(infrared_temperature1[kk+i])
        endif else begin
          lwp11=0.0
          pwv11=0.0
          time_offset11=0.0
          irt11=0.0
        endelse
      endif else begin; if first_flag eq 1 then begin
        if n_elements(i) gt 10 then begin
          i=lwp1[kk+i]
          d=where(i gt 0., count)
          if count gt 0. then begin
          lwp11=[lwp11,mean(i[where(i gt 0.)])]
          endif else begin
          lwp11=[lwp11,0.]
          endelse
          ;lwp11=[lwp11,mean(lwp1[kk+i])]
          pwv11=[pwv11, mean(pwv1[kk+i])]
          time_offset11=[time_offset11, mean(time_offset[kk+i])]
          irt11=[irt11, mean(infrared_temperature1[kk+i])]
        endif else begin
          lwp11=[lwp11, 0.0]
          pwv11=[pwv11, 0.0]
          time_offset11=[time_offset11, 0.0]
          irt11=[irt11, 0.0]
        endelse

      endelse
      kk=kk+450l
    endwhile

    julday11=jday1+((double(base_time)+time_offset11)/86400.d)

    if n_elements(julday_mwr_pre) eq 0 then begin
      julday_mwr_pre=julday11
      lwp_pre=lwp11
      ;lwp_err_pre=lwp_err11
      pwv_pre=pwv11
      ;pwv_err_pre=pwv_err11
      irt_pre=irt11
      ;rain_flag_pre=rain_flag11
    endif else begin
      julday_mwr_pre=[julday_mwr_pre,julday11]
      lwp_pre=[lwp_pre,lwp11]
      ;lwp_err_pre=[lwp_err_pre, lwp_err1]
      pwv_pre=[pwv_pre, pwv11]
      ;pwv_err_pre=[pwv_err_pre, pwv_err1]
      irt_pre=[irt_pre, irt11]
      ;rain_flag_pre=[rain_flag_pre, rain_flag1]
    endelse

  endfor

endfor  ; for jj=0,n_elements(months)-1 do begin
  
  lwp_pre=lwp_pre*1.e3  ; convert to g/m2
  
  w_dir_mwr_pre=fltarr(n_elements(julday_mwr_pre))
w_spd_mwr_pre=fltarr(n_elements(julday_mwr_pre))
for j=0,n_elements(julday_mwr_pre)-1 do begin
  i=where(abs(julday_mwr_pre[j]-julday_smet) eq min(abs(julday_mwr_pre[j]-julday_smet))) & i=i[0]
  if (abs(julday_mwr_pre[j]-julday_smet[i]))*86400.d lt 1200.d then begin
    w_dir_mwr_pre[j]=wind_dir[i]
    w_spd_mwr_pre[j]=wind_speed[i]
  endif else begin
    w_spd_mwr_pre[j]=0.
    w_dir_mwr_pre[j]=180.
  endelse

endfor

w_dir_cld_pre=fltarr(n_elements(julian_day_ret_pre))
w_spd_cld_pre=fltarr(n_elements(julian_day_ret_pre))
for j=0,n_elements(julian_day_ret_pre)-1 do begin
  i=where(abs(julian_day_ret_pre[j]-julday_smet) eq min(abs(julian_day_ret_pre[j]-julday_smet))) & i=i[0]
  if (julian_day_ret_pre[j]-julday_smet[i])*86400.d lt 300.d then begin
    w_dir_cld_pre[j]=wind_dir[i]
    w_spd_cld_pre[j]=wind_speed[i]
  endif else begin
    w_spd_cld_pre[j]=0.
    w_dir_cld_pre[j]=180.
  endelse

endfor


;get ccn data pre 2020

for jj=0,n_elements(months)-1 do begin

ccn1_files=file_search(ccn1_dir+'enaaosccn1colavgC1.b1.'+months[jj]+'*.nc', count=count)

for j=0,count-1 do begin
cdfid=ncdf_open(ccn1_files[j])
;cdfid=ncdf_open(radar_path+radar_file,/nowrite)

x_id=ncdf_varid(cdfid, 'base_time') & ncdf_varget,cdfid,x_id,base_time
x_id=ncdf_varid(cdfid, 'time_offset') & ncdf_varget,cdfid,x_id,time_offset
x_id=ncdf_varid(cdfid, 'supersaturation_calculated') & ncdf_varget,cdfid,x_id,ss_calc1
x_id=ncdf_varid(cdfid, 'aerosol_number_concentration') & ncdf_varget,cdfid,x_id,cn1
x_id=ncdf_varid(cdfid, 'N_CCN') & ncdf_varget,cdfid,x_id,N_CCN1
x_id=ncdf_varid(cdfid, 'qc_N_CCN') & ncdf_varget,cdfid,x_id,qc_N_CCN1
ncdf_close, cdfid

print, months[jj], n_elements(N_CCN1)

julday1=jday1+((double(base_time)+time_offset)/86400.d)

ccn_ss_regression, julday1, ss_calc1, N_CCN1,qc_N_CCN1, cn1,    0.2,   ccn_out, julday_out, cn_out, qc_out
                   ;julday1, ss_calc1, N_CCN1,qc_N_CCN1, cn_in, ss_in, ccn_out, julday_out,cn_out, qc_out

ss_out=fltarr(n_elements(julday_out)) & ss_out[*]=0.3

if n_elements(julday_pre) eq 0 then begin
  julday_pre=julday_out
  ss_calc_pre=ss_out
  cn_pre=cn_out
  ccn_pre=ccn_out
  qc_ccn_pre=qc_out
endif else begin
  julday_pre=[julday_pre,julday_out]
  ss_calc_pre=[ss_calc_pre,ss_out]
  cn_pre=[cn_pre,cn_out]
  ccn_pre=[ccn_pre,ccn_out]
  qc_ccn_pre=[qc_ccn_pre,qc_out]
endelse

endfor  ; for j=0,count-1 do begin
  
endfor  ; for jj=0,n_elements(months)-1 do begin
  
  w_dir_pre=fltarr(n_elements(julday_pre))
  w_spd_pre=fltarr(n_elements(julday_pre))
for j=0,n_elements(julday_pre)-1 do begin
  i=where(abs(julday_pre[j]-julday_smet) eq min(abs(julday_pre[j]-julday_smet))) & i=i[0]
  if (abs(julday_pre[j]-julday_smet[i]))*86400.d lt 1200.d then begin
    w_dir_pre[j]=wind_dir[i]
    w_spd_pre[j]=wind_speed[i]
  endif else begin
    w_spd_pre[j]=0.
    w_dir_pre[j]=180.
  endelse
  
  
endfor

;;;;; calculate the optical and albedo
;optical_depth_pre=fltarr(n_elements(julian_day_ret_pre))
;albedo_pre=fltarr(n_elements(julian_day_ret_pre))
;
;for jj=0, n_elements(julian_day_ret_pre)-1 do begin
;  
;if re_top_oe_pre[jj] gt 0. and re_top_oe_pre[jj] lt 50. then begin
;  
;i=where(abs(julian_day_ret_pre[jj]-julday_mwr_pre) eq min(abs(julian_day_ret_pre[jj]-julday_mwr_pre)))  & i=i[0]
;if lwp_pre[i] gt 0. and lwp_pre[i] lt 500. and abs(julian_day_ret_pre[jj]-julday_mwr_pre[i])*86400.d lt 1000. then begin
;  
;  optical_depth_pre[jj]=1.5*(lwp_pre[i])/(re_top_oe_pre[jj])
;  ccm3_radiative_param_shortwave, 0.55, lwp_pre[i], re_top_oe_pre[jj], tau, omega, g  ; reference Slingo 1989.
;  albedo_pre[jj]=((1.-g)*tau)/(2.+((1.-g)*tau)) ; reference Platnick and Twomey (1994)
; 
;endif else begin
;  print, abs(julian_day_ret_pre[jj]-julday_mwr_pre[i])
;endelse
;endif  
; endfor

;;;; get the mwr retrievals
  
  
;;;;;;;;;;; now get data from after 2020



;months=['202106','202107','202108','202109',$
;  '202205','202206','202207','202208','202209',$
;  '202305','202306','202307','202308','202309']
  
  months=['202106','202107','202108','202109',$
    '202206','202207','202208','202209',$
    '202306','202307','202308','202309']
    
;    months=['202106','202107','202108','202109'];,$
;months=['202206','202207','202208','202209'];,$
;months=['202306','202307','202308','202309']


;  months=['202106','202107','202108','202109',$
;    '202205','202206','202207','202208','202209']

;  months=['202107','202108',$
;    '202206','202207','202208',$
;    '202306','202307','202308']


for jj=0,n_elements(months)-1 do begin
  
  
  ;;;;; get cloud data
  cloud_files=file_search(cloud_dir+'/*/nd_retrieval.ena.'+months[jj]+'*.avg.30sec.15m.retavg_05min.cdf', count=count)
  for j=0,count-1 do begin
    cdfid=ncdf_open(cloud_files[j])
    x_id=ncdf_varid(cdfid, 'lwp_oe') & ncdf_varget,cdfid,x_id, lwp_oe1
    x_id=ncdf_varid(cdfid, 'fad_oe') & ncdf_varget,cdfid,x_id, fad_oe1
    x_id=ncdf_varid(cdfid, 'm_test_output') & ncdf_varget,cdfid,x_id, m_test_output1
    x_id=ncdf_varid(cdfid, 'nd_oe') & ncdf_varget,cdfid,x_id, nd_oe1
    x_id=ncdf_varid(cdfid, 're_top_oe') & ncdf_varget,cdfid,x_id, re_top_oe1
    x_id=ncdf_varid(cdfid, 'ccn_array') & ncdf_varget,cdfid,x_id, ccn_array1
    ncdf_close, cdfid
    
    
    optical_depth1=fltarr(n_elements(lwp_oe1))
    albedo1=fltarr(n_elements(lwp_oe1))
    for jjj=0, n_elements(lwp_oe1)-1 do begin
      if lwp_oe1[jjj] gt 0. then begin
          ;optical_depth1[jjj]=1.5*(lwp_post[jjj])/(re_top_oe_post[jjj])
          ccm3_radiative_param_shortwave, 0.55, lwp_oe1[jjj]*fad_oe1[jjj], re_top_oe1[jjj], tau, omega, g  ; reference Slingo 1989.
          optical_depth1[jjj]=tau
          albedo1[jjj]=((1.-g)*tau)/(2.+((1.-g)*tau)) ; reference Platnick and Twomey (1994)
      endif
    endfor
  

;  if max(lwp_oe1) gt 0. then begin
;    if n_elements(lwp_oe_post) eq 0 then begin
;      lwp_oe_post=lwp_oe1[where(lwp_oe1 gt 0.)]*fad_oe1[where(lwp_oe1 gt 0.)]
;      m_test_output_post=m_test_output1[where(lwp_oe1 gt 0.)]
;      nd_oe_post=nd_oe1[where(lwp_oe1 gt 0.)]
;      re_top_oe_post=re_top_oe1[where(lwp_oe1 gt 0.)]
;      ccn_array_oe_post=ccn_array1[where(lwp_oe1 gt 0.)]
;      albedo_post=albedo1[where(lwp_oe1 gt 0.)]
;      optical_depth_post=optical_depth1[where(lwp_oe1 gt 0.)]
;    endif else begin
;      lwp_oe_post=[lwp_oe_post,lwp_oe1[where(lwp_oe1 gt 0.)]*fad_oe1[where(lwp_oe1 gt 0.)]]
;      m_test_output_post=[m_test_output_post,m_test_output1[where(lwp_oe1 gt 0.)]]
;      nd_oe_post=[nd_oe_post, nd_oe1[where(lwp_oe1 gt 0.)]]
;      re_top_oe_post=[re_top_oe_post, re_top_oe1[where(lwp_oe1 gt 0.)]]
;      ccn_array_oe_post=[ccn_array_oe_post,ccn_array1[where(lwp_oe1 gt 0.)]]
;      albedo_post=[albedo_post,albedo1[where(lwp_oe1 gt 0.)]]
;      optical_depth_post=[optical_depth_post, optical_depth1[where(lwp_oe1 gt 0.)]]
;    endelse
;  endif
;  endfor
  
;  if max(lwp_oe1) gt 0. then begin
    if n_elements(lwp_oe_post) eq 0 then begin
      lwp_oe_post=lwp_oe1*fad_oe1
      m_test_output_post=m_test_output1
      nd_oe_post=nd_oe1
      re_top_oe_post=re_top_oe1
      ccn_array_oe_post=ccn_array1
      albedo_post=albedo1
      optical_depth_post=optical_depth1
    endif else begin
      lwp_oe_post=[lwp_oe_post,lwp_oe1]
      m_test_output_post=[m_test_output_post,m_test_output1]
      nd_oe_post=[nd_oe_post, nd_oe1]
      re_top_oe_post=[re_top_oe_post, re_top_oe1]
      ccn_array_oe_post=[ccn_array_oe_post,ccn_array1]
      albedo_post=[albedo_post,albedo1]
      optical_depth_post=[optical_depth_post, optical_depth1]
    endelse
;  endif
endfor


 ;;;; get drizzle data
cloud_files=file_search(cloud_dir+'/*/nd_retrieval.ena.'+months[jj]+'*.avg.30sec.15m.cdf', count=count)
for j=0,count-1 do begin
  cdfid=ncdf_open(cloud_files[j])
  x_id=ncdf_varid(cdfid, 'rain_rate') & ncdf_varget,cdfid,x_id, rain_rate1
  x_id=ncdf_varid(cdfid, 'dbz_avg_subcloud') & ncdf_varget,cdfid,x_id, dbz_avg_subcloud1
  x_id=ncdf_varid(cdfid, 'low_cloud_flag') & ncdf_varget,cdfid,x_id, low_cloud_flag1
  x_id=ncdf_varid(cdfid, 'julian_day') & ncdf_varget,cdfid,x_id, julian_day1
  ncdf_close, cdfid

;if max(dbz_avg_subcloud1) gt 0. then begin
;  if n_elements(rain_rate_post) eq 0 then begin
;    rain_rate_post=rain_rate1[where(rain_rate1 gt 0.)]
;    dbz_avg_subcloud_post=dbz_avg_subcloud1[where(dbz_avg_subcloud1 gt 0.)]
;    low_cloud_flag_post=low_cloud_flag1
;    julian_day_ret_post=julian_day1[where(lwp_oe1 gt 0.)]
;
;  endif else begin
;    rain_rate_post=[rain_rate_post,rain_rate1[where(rain_rate1 gt 0.)]]
;    dbz_avg_subcloud_post=[dbz_avg_subcloud_post,dbz_avg_subcloud1[where(dbz_avg_subcloud1 gt 0.)]]
;    low_cloud_flag_post=[low_cloud_flag_post,low_cloud_flag1]
;    julian_day_ret_post=[julian_day_ret_post,julian_day1[where(lwp_oe1 gt 0.)]]
;
;  endelse
;endif

;if max(dbz_avg_subcloud1) gt 0. then begin
  if n_elements(rain_rate_post) eq 0 then begin
    rain_rate_post=rain_rate1
    dbz_avg_subcloud_post=dbz_avg_subcloud1
    low_cloud_flag_post=low_cloud_flag1
    julian_day_ret_post=julian_day1

  endif else begin
    rain_rate_post=[rain_rate_post,rain_rate1]
    dbz_avg_subcloud_post=[dbz_avg_subcloud_post,dbz_avg_subcloud1]
    low_cloud_flag_post=[low_cloud_flag_post,low_cloud_flag1]
    julian_day_ret_post=[julian_day_ret_post,julian_day1]

  endelse
;endif


endfor


  ccn1_files=file_search(ccn2_dir+'enaaosccn2colaavgC1.b1.'+months[jj]+'*.nc', count=count)

  for j=0,count-1 do begin
    cdfid=ncdf_open(ccn1_files[j])
    ;cdfid=ncdf_open(radar_path+radar_file,/nowrite)

    x_id=ncdf_varid(cdfid, 'base_time') & ncdf_varget,cdfid,x_id,base_time
    x_id=ncdf_varid(cdfid, 'time_offset') & ncdf_varget,cdfid,x_id,time_offset
    x_id=ncdf_varid(cdfid, 'supersaturation_calculated') & ncdf_varget,cdfid,x_id,ss_calc1
    x_id=ncdf_varid(cdfid, 'aerosol_number_concentration') & ncdf_varget,cdfid,x_id,cn1
    x_id=ncdf_varid(cdfid, 'N_CCN') & ncdf_varget,cdfid,x_id,N_CCN1
    x_id=ncdf_varid(cdfid, 'qc_N_CCN') & ncdf_varget,cdfid,x_id,qc_N_CCN1
    ncdf_close, cdfid
    
    print, months[jj], n_elements(N_CCN1)


    julday1=jday1+((double(base_time)+time_offset)/86400.d)
    
ccn_ss_regression, julday1, ss_calc1, N_CCN1,qc_N_CCN1, cn1,    0.2,   ccn_out, julday_out, cn_out, qc_out

ss_out=fltarr(n_elements(julday_out)) & ss_out[*]=0.3

    if n_elements(julday_post) eq 0 then begin
      julday_post=julday_out
      ss_calc_post=ss_out
      cn_post=cn_out
      ccn_post=ccn_out
      qc_ccn_post=qc_out
    endif else begin
      julday_post=[julday_post,julday_out]
      ss_calc_post=[ss_calc_post,ss_out]
      cn_post=[cn_post,cn_out]
      ccn_post=[ccn_post,ccn_out]
      qc_ccn_post=[qc_ccn_post,qc_out]
    endelse

  endfor  ; for j=0,count-1 do begin

endfor  ; for jj=0,n_elements(months)-1 do begin
  
  f=0
for jj=0,n_elements(months)-1 do begin

  smet_files=file_search(sfc_met_dir+'enaaosmetC1.a1.'+months[jj]+'*.*', count=count)

  for j=0,count-1 do begin

    cdfid=ncdf_open(smet_files[j])
    ;cdfid=ncdf_open(radar_path+radar_file,/nowrite)

    x_id=ncdf_varid(cdfid, 'base_time') & ncdf_varget,cdfid,x_id,base_time
    x_id=ncdf_varid(cdfid, 'time_offset') & ncdf_varget,cdfid,x_id,time_offset
    x_id=ncdf_varid(cdfid, 'wind_speed') & ncdf_varget,cdfid,x_id,wind_speed1
    x_id=ncdf_varid(cdfid, 'wind_direction') & ncdf_varget,cdfid,x_id,wind_dir1
    ncdf_close, cdfid
    
    ; subsample the met data
    for kk=0,n_elements(time_offset),25 do begin
      if kk lt n_elements(time_offset)-1 then begin
        if kk eq 0 then begin
          time_offset_temp=time_offset[kk]
          wind_dir_temp=wind_dir1[kk]
          wind_speed_temp=wind_speed1[kk]
        endif else begin
          time_offset_temp=[time_offset_temp,time_offset[kk]]
          wind_dir_temp=[wind_dir_temp,wind_dir1[kk]]
          wind_speed_temp=[wind_speed_temp,wind_speed1[kk]]
        endelse
      endif
    endfor
    time_offset=time_offset_temp
    wind_dir1=wind_dir_temp
    wind_speed1=wind_speed_temp


    julday1=jday1+((double(base_time)+time_offset)/86400.d)

    if f eq 0 then begin
      f=1
      julday_smet=julday1
      wind_speed=wind_speed1
      wind_dir=wind_dir1
    endif else begin
      julday_smet=[julday_smet,julday1]
      wind_speed=[wind_speed, wind_speed1]
      wind_dir=[wind_dir, wind_dir1]
    endelse

  endfor

endfor  ; for jj=0,n_elements(months)-1 do begin
  
  w_dir_post=fltarr(n_elements(julday_post))
w_spd_post=fltarr(n_elements(julday_post))
for j=0,n_elements(julday_post)-1 do begin
  i=where(abs(julday_post[j]-julday_smet) eq min(abs(julday_post[j]-julday_smet))) & i=i[0]
  if (julday_post[j]-julday_smet[i])*86400.d lt 300.d then begin
    w_dir_post[j]=wind_dir[i]
    w_spd_post[j]=wind_speed[i]
  endif else begin
    w_spd_post[j]=0.
    w_dir_post[j]=180.
  endelse

endfor


w_dir_cld_post=fltarr(n_elements(julian_day_ret_post))
w_spd_cld_post=fltarr(n_elements(julian_day_ret_post))
for j=0,n_elements(julian_day_ret_post)-1 do begin
  i=where(abs(julian_day_ret_post[j]-julday_smet) eq min(abs(julian_day_ret_post[j]-julday_smet))) & i=i[0]
  if (julian_day_ret_post[j]-julday_smet[i])*86400.d lt 300.d then begin
    w_dir_cld_post[j]=wind_dir[i]
    w_spd_cld_post[j]=wind_speed[i]
  endif else begin
    w_spd_cld_post[j]=0.
    w_dir_cld_post[j]=180.
  endelse

endfor



; get the pre mwr data
for jj=0,n_elements(months)-1 do begin

  mwr_files=file_search(mwr_path+'enamwr3cC1.b1.'+months[jj]+'*.*', count=count)

  for j=0,count-1 do begin

    cdfid=ncdf_open(mwr_files[j])
    ;cdfid=ncdf_open(radar_path+radar_file,/nowrite)

    x_id=ncdf_varid(cdfid, 'base_time') & ncdf_varget,cdfid,x_id,base_time
    x_id=ncdf_varid(cdfid, 'time_offset') & ncdf_varget,cdfid,x_id,time_offset
    x_id=ncdf_varid(cdfid, 'lwp') & ncdf_varget,cdfid,x_id,lwp1
    x_id=ncdf_varid(cdfid, 'lwp_err') & ncdf_varget,cdfid,x_id,lwp_err1
    x_id=ncdf_varid(cdfid, 'pwv') & ncdf_varget,cdfid,x_id,pwv1
    x_id=ncdf_varid(cdfid, 'pwv_err') & ncdf_varget,cdfid,x_id,pwv_err1
    x_id=ncdf_varid(cdfid, 'infrared_temperature') & ncdf_varget,cdfid,x_id,infrared_temperature1
    x_id=ncdf_varid(cdfid, 'rain_flag') & ncdf_varget,cdfid,x_id,rain_flag1
    x_id=ncdf_varid(cdfid, 'lat') & ncdf_varget,cdfid,x_id,lat
    x_id=ncdf_varid(cdfid, 'lon') & ncdf_varget,cdfid,x_id,lon
    ncdf_close, cdfid

    ;;;; create hourly means.  time res is ~3 seconds.
;    kk=0l & first_flag=1
;    while kk+450l lt n_elements(time_offset)-1 do begin
;      i=where(lwp1[kk:kk+450]*1.e4 gt 20. and lwp1[kk:kk+450] lt 0.1 and rain_flag1[kk:kk+450] eq 0 and $
;        infrared_temperature1[kk:kk+450] gt 273. and infrared_temperature1[kk:kk+450] lt 300.)
;      if first_flag eq 1 then begin
;        first_flag=0
;        if n_elements(i) gt 10 then begin
;          lwp11=mean(lwp1[kk+i])
;          pwv11=mean(pwv1[kk+i])
;          time_offset11=mean(time_offset[kk+i])
;          irt11=mean(infrared_temperature1[kk+i])
;        endif else begin
;          lwp11=0.0
;          pwv11=0.0
;          time_offset11=0.0
;          irt11=0.0
;        endelse
;      endif else begin; if first_flag eq 1 then begin
;        if n_elements(i) gt 10 then begin
;          lwp11=[lwp11,mean(lwp1[kk+i])]
;          pwv11=[pwv11, mean(pwv1[kk+i])]
;          time_offset11=[time_offset11, mean(time_offset[kk+i])]
;          irt11=[irt11, mean(infrared_temperature1[kk+i])]
;        endif else begin
;          lwp11=[lwp11, 0.0]
;          pwv11=[pwv11, 0.0]
;          time_offset11=[time_offset11, 0.0]
;          irt11=[irt11, 0.0]
;        endelse
;
;      endelse
;      kk=kk+450l
;    endwhile
    
    kk=0l & first_flag=1
    while kk+450l lt n_elements(time_offset)-1 do begin
      ;      i=where(lwp1[kk:kk+450]*1.e3 gt 20. and rain_flag1[kk:kk+450] eq 0 and $
      ;        (infrared_temperature1[kk:kk+450]) gt 273.)
      i=where(rain_flag1[kk:kk+450] eq 0)
      if first_flag eq 1 then begin
        first_flag=0
        if n_elements(i) gt 10 then begin
          i=lwp1[kk+i]
          d=where(i gt 0., count)
          if count gt 0. then begin
            lwp11=mean(i[where(i gt 0.)])
          endif else begin
            lwp11=0.
          endelse
          ;lwp11=mean(i[where(i gt 0.)])
          pwv11=mean(pwv1[kk+i])
          time_offset11=mean(time_offset[kk+i])
          irt11=mean(infrared_temperature1[kk+i])
        endif else begin
          lwp11=0.0
          pwv11=0.0
          time_offset11=0.0
          irt11=0.0
        endelse
      endif else begin; if first_flag eq 1 then begin
        if n_elements(i) gt 10 then begin
          i=lwp1[kk+i]
          d=where(i gt 0., count)
          if count gt 0. then begin
            lwp11=[lwp11,mean(i[where(i gt 0.)])]
          endif else begin
            lwp11=[lwp11,0.]
          endelse
          ;lwp11=[lwp11,mean(lwp1[kk+i])]
          pwv11=[pwv11, mean(pwv1[kk+i])]
          time_offset11=[time_offset11, mean(time_offset[kk+i])]
          irt11=[irt11, mean(infrared_temperature1[kk+i])]
        endif else begin
          lwp11=[lwp11, 0.0]
          pwv11=[pwv11, 0.0]
          time_offset11=[time_offset11, 0.0]
          irt11=[irt11, 0.0]
        endelse

      endelse
      kk=kk+450l
    endwhile

    julday11=jday1+((double(base_time)+time_offset11)/86400.d)

    if n_elements(julday_mwr_post) eq 0 then begin
      julday_mwr_post=julday11
      lwp_post=lwp11
      ;lwp_err_post=lwp_err11
      pwv_post=pwv11
      ;pwv_err_post=pwv_err11
      irt_post=irt11
      ;rain_flag_post=rain_flag11
    endif else begin
      julday_mwr_post=[julday_mwr_post,julday11]
      lwp_post=[lwp_post,lwp11]
      ;lwp_err_post=[lwp_err_post, lwp_err1]
      pwv_post=[pwv_post, pwv11]
      ;pwv_err_post=[pwv_err_post, pwv_err1]
      irt_post=[irt_post, irt11]
      ;rain_flag_post=[rain_flag_post, rain_flag1]
    endelse

  endfor

endfor  ; for jj=0,n_elements(months)-1 do begin
  
  lwp_post=lwp_post*1.e3  ; convert to g/m2


w_dir_mwr_post=fltarr(n_elements(julday_mwr_post))
w_spd_mwr_post=fltarr(n_elements(julday_mwr_post))
for j=0,n_elements(julday_mwr_post)-1 do begin
  i=where(abs(julday_mwr_post[j]-julday_smet) eq min(abs(julday_mwr_post[j]-julday_smet))) & i=i[0]
  if (abs(julday_mwr_post[j]-julday_smet[i]))*86400.d lt 1200.d then begin
    w_dir_mwr_post[j]=wind_dir[i]
    w_spd_mwr_post[j]=wind_speed[i]
  endif else begin
    w_spd_mwr_post[j]=0.
    w_dir_mwr_post[j]=180.
  endelse

endfor

;;;;; calculate the optical and albedo
;optical_depth_post=fltarr(n_elements(julian_day_ret_post))
;albedo_post=fltarr(n_elements(julian_day_ret_post))
;
;for jj=0, n_elements(julian_day_ret_post)-1 do begin
;
;  if re_top_oe_post[jj] gt 0. and re_top_oe_post[jj] lt 50. then begin
;
;    i=where(abs(julian_day_ret_post[jj]-julday_mwr_post) eq min(abs(julian_day_ret_post[jj]-julday_mwr_post)))  & i=i[0]
;    if lwp_post[i] gt 0. and lwp_post[i] lt 500. and abs(julian_day_ret_post[jj]-julday_mwr_post[i])*86400.d lt 1000. then begin
;
;      optical_depth_post[jj]=1.5*(lwp_post[i])/(re_top_oe_post[jj])
;      ccm3_radiative_param_shortwave, 0.55, lwp_post[i], re_top_oe_post[jj], tau, omega, g  ; reference Slingo 1989.
;      albedo_post[jj]=((1.-g)*tau)/(2.+((1.-g)*tau)) ; reference Platnick and Twomey (1994)
;
;    endif else begin
;      print, abs(julian_day_ret_post[jj]-julday_mwr_post[i])
;    endelse
;  endif
;endfor

i=where(w_dir_pre gt 330 and w_dir_pre lt 360.)
w_dir_pre[i]=30.
i=where(w_dir_post gt 330 and w_dir_post lt 360.)
w_dir_post[i]=30.

i=where(w_dir_pre gt 220. and w_dir_pre lt 250.)
w_dir_pre[i]=30.
i=where(w_dir_post gt 220. and w_dir_post lt 250.)
w_dir_post[i]=30.
  
  conditions_vec_pre=where(w_spd_pre gt 2.5 and w_dir_pre gt 0. and w_dir_pre lt 70.)
  conditions_vec_post=where(w_spd_post gt 2.5 and w_dir_post gt 0. and w_dir_post lt 70. and cn_post gt 0.)
  
  conditions_cn_pre=where(cn_pre lt 1000. and cn_pre gt 0. and w_spd_pre gt 5. and w_dir_pre gt 0. and w_dir_pre lt 70. and cn_pre gt 0.)
  conditions_cn_post=where(cn_post lt 1000. and cn_post gt 0. and w_spd_post gt 5. and w_dir_post gt 0. and w_dir_post lt 70. and cn_post gt 0.)
  
  conditions_lwp_pre=where(lwp_pre lt 300. and lwp_pre gt 20. and w_spd_mwr_pre gt 5. and w_dir_mwr_pre gt 0. and w_dir_mwr_pre lt 70.)
  conditions_lwp_post=where(lwp_post lt 300. and lwp_post gt 20. and w_spd_mwr_post gt 5. and w_dir_mwr_post gt 0. and w_dir_mwr_post lt 70.)
  
;  lwp_oe_post=lwp_oe1[where(lwp_oe1 gt 0.)]
;  m_test_output_post=m_test_output1[where(lwp_oe1 gt 0.)]
;  nd_oe_post=nd_oe1[where(lwp_oe1 gt 0.)]
;  re_top_oe_post=re_top_oe1[where(lwp_oe1 gt 0.)]

;  conditions_cloud_pre=where(m_test_output_pre lt 0.001 and m_test_output_pre gt 0. and nd_oe_pre gt 10. and nd_oe_pre lt 1000. and re_top_oe_pre gt 5. and re_top_oe_pre lt 25. and lwp_oe_pre gt 20. and lwp_oe_pre lt 150.)
;  conditions_cloud_post=where(m_test_output_post lt 0.001 and m_test_output_post gt 0. and nd_oe_post gt 10. and nd_oe_post lt 1000. and re_top_oe_post gt 5. and re_top_oe_post lt 25. and lwp_oe_post gt 20. and lwp_oe_post lt 150.)

  conditions_cloud_pre=where(m_test_output_pre lt 1. and nd_oe_pre gt 10. and nd_oe_pre lt 1.e6 and m_test_output_pre gt 0. and lwp_oe_pre gt 20. and lwp_oe_pre lt 150. and finite(re_top_oe_pre) eq 1)
  conditions_cloud_post=where(m_test_output_post lt 1. and nd_oe_post gt 10. and nd_oe_post lt 1.e6 and m_test_output_post gt 0. and lwp_oe_post gt 20. and lwp_oe_post lt 150. and finite(re_top_oe_post) eq 1)

  conditions_cloud_precip_pre=where(m_test_output_pre lt 1. and nd_oe_pre gt 10. and nd_oe_pre lt 1.e6 and m_test_output_pre gt 0. and lwp_oe_pre gt 20. and lwp_oe_pre lt 150. and finite(re_top_oe_pre) eq 1 and rain_rate_pre gt 0.0)
  conditions_cloud_precip_post=where(m_test_output_post lt 1. and nd_oe_post gt 10. and nd_oe_post lt 1.e6 and m_test_output_post gt 0. and lwp_oe_post gt 20. and lwp_oe_post lt 150. and finite(re_top_oe_post) eq 1 and rain_rate_post gt 0.0)

;  conditions_precip_pre2=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 300. and rain_rate_pre gt 0.001 and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
;  conditions_precip_post2=where(lwp_oe_post gt 20. and lwp_oe_post lt 300. and rain_rate_post gt 0.001 and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)
;
;  conditions_precip_0p01_pre2=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 300. and rain_rate_pre gt 0.01 and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
;  conditions_precip_0p01_post2=where(lwp_oe_post gt 20. and lwp_oe_post lt 300. and rain_rate_post gt 0.01 and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)
;
;  conditions_precip_0p1_pre2=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 300. and rain_rate_pre gt 0.1 and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
;  conditions_precip_0p1_post2=where(lwp_oe_post gt 20. and lwp_oe_post lt 300. and rain_rate_post gt 0.1 and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)
;
;  conditions_precip_1p0_pre2=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 300. and rain_rate_pre gt 1. and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
;  conditions_precip_1p0_post2=where(lwp_oe_post gt 20. and lwp_oe_post lt 300. and rain_rate_post gt 1. and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)
;
;  conditions_pre2=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 300. and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
;  conditions_post2=where(lwp_oe_post gt 20. and lwp_oe_post lt 300. and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)
;  
  
  conditions_precip_pre2=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 1.e6 and rain_rate_pre gt 0.0 and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
  conditions_precip_post2=where(lwp_oe_post gt 20. and lwp_oe_post lt 1.e6 and rain_rate_post gt 0.0 and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)

  conditions_precip_0p001_pre2=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 1.e6 and rain_rate_pre gt 0.001 and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
  conditions_precip_0p001_post2=where(lwp_oe_post gt 20. and lwp_oe_post lt 1.e6 and rain_rate_post gt 0.001 and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)

  conditions_precip_0p01_pre2=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 1.e6 and rain_rate_pre gt 0.01 and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
  conditions_precip_0p01_post2=where(lwp_oe_post gt 20. and lwp_oe_post lt 1.e6 and rain_rate_post gt 0.01 and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)

  conditions_precip_0p1_pre2=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 1.e6 and rain_rate_pre gt 0.1 and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
  conditions_precip_0p1_post2=where(lwp_oe_post gt 20. and lwp_oe_post lt 1.e6 and rain_rate_post gt 0.1 and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)

  conditions_precip_1p0_pre2=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 1.e6 and rain_rate_pre gt 1. and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
  conditions_precip_1p0_post2=where(lwp_oe_post gt 20. and lwp_oe_post lt 1.e6 and rain_rate_post gt 1. and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)

  conditions_pre222=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 1.e6 and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
  conditions_post222=where(lwp_oe_post gt 20. and lwp_oe_post lt 1.e6 and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)

  conditions_pre2_all=where(lwp_oe_pre gt 20. and lwp_oe_pre lt 1.e6 and w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
  conditions_post2_all=where(lwp_oe_post gt 20. and lwp_oe_post lt 1.e6 and w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)
  
  conditions_pre22_all=where(w_spd_cld_pre gt 5. and w_dir_cld_pre gt 0. and w_dir_cld_pre lt 70.)
  conditions_post22_all=where(w_spd_cld_post gt 5. and w_dir_cld_post gt 0. and w_dir_cld_post lt 70.)


print, ' Cloud occurrence ',float(n_elements(conditions_pre222))/float(n_elements(conditions_pre22_all)), float(n_elements(conditions_post222))/float(n_elements(conditions_post22_all))
print, ' Precip occurrence ',float(n_elements(conditions_precip_pre2))/float(n_elements(conditions_pre2_all)), float(n_elements(conditions_precip_post2))/float(n_elements(conditions_post2_all))
print, ' Precip occurrence (>0.001) ',float(n_elements(conditions_precip_0p001_pre2))/float(n_elements(conditions_pre2)), float(n_elements(conditions_precip_0p001_post2))/float(n_elements(conditions_post2))
print, ' Precip occurrence (>0.01) ',float(n_elements(conditions_precip_0p01_pre2))/float(n_elements(conditions_pre2)), float(n_elements(conditions_precip_0p01_post2))/float(n_elements(conditions_post2))
print, ' Precip occurrence (>0.1) ',float(n_elements(conditions_precip_0p1_pre2))/float(n_elements(conditions_pre2)), float(n_elements(conditions_precip_0p1_post2))/float(n_elements(conditions_post2))
print, ' Precip occurrence (>1.) ',float(n_elements(conditions_precip_1p0_pre2))/float(n_elements(conditions_pre2)), float(n_elements(conditions_precip_1p0_post2))/float(n_elements(conditions_post2))

;;;; how many days in each perid?
n_days_pre=0
jday_min=min(julian_day_ret_pre) & jday_max=max(julian_day_ret_pre)
jday_int=long(julian_day_ret_pre)
jday_int_min=long(jday_min) & jday_int_max=long(jday_max)
for i=jday_int_min,jday_int_max do begin
  d=where(i eq jday_int, count)
  if count gt 0 then n_days_pre=n_days_pre+1
endfor

n_days_post=0
jday_min=min(julian_day_ret_post) & jday_max=max(julian_day_ret_post)
jday_int=long(julian_day_ret_post)
jday_int_min=long(jday_min) & jday_int_max=long(jday_max)
for i=jday_int_min,jday_int_max do begin
  d=where(i eq jday_int, count)
  if count gt 0 then n_days_post=n_days_post+1
endfor

print, 'number of days pre and post ', n_days_pre, n_days_post


  xx=w_spd_cld_pre[conditions_cloud_pre] & yy=w_spd_cld_post[conditions_cloud_post]
  print, 'wind sped median ',median(xx[where(xx gt 0.)]), median(yy[where(yy gt 0.)])
  print, 'wind speed mean ',mean(xx[where(xx gt 0.)]), mean(yy[where(yy gt 0.)])
  print, 'wind speed sdv ',stddev(xx[where(xx gt 0.)]), stddev(yy[where(yy gt 0.)])

  print, 'ccn median ',median(ccn_pre[conditions_vec_pre]), median(ccn_post[conditions_vec_post])
  print, 'ccn mean ',mean(ccn_pre[conditions_vec_pre]), mean(ccn_post[conditions_vec_post])
  print, 'ccn sdv ',stddev(ccn_pre[conditions_vec_pre]), stddev(ccn_post[conditions_vec_post])

  
;  print, 'cn median ',median(cn_pre[conditions_cn_pre]), median(cn_post[conditions_cn_post])
;  print, 'cn mean ',mean(cn_pre[conditions_cn_pre]), mean(cn_post[conditions_cn_post])
  
  print, 'lwp median ',median(lwp_oe_pre[conditions_cloud_pre]), median(lwp_oe_post[conditions_cloud_post])
  print, 'lwp mean ',mean(lwp_oe_pre[conditions_cloud_pre]), mean(lwp_oe_post[conditions_cloud_post])
  print, 'lwp std ',stddev(lwp_oe_pre[conditions_cloud_pre]), stddev(lwp_oe_post[conditions_cloud_post])

  print, 'pwv median ',median(pwv_pre[conditions_lwp_pre]), median(pwv_post[conditions_lwp_post])
  print, 'pwv mean ',mean(pwv_pre[conditions_lwp_pre]), mean(pwv_post[conditions_lwp_post])
  print, 'pwv std ',stddev(pwv_pre[conditions_lwp_pre]), stddev(pwv_post[conditions_lwp_post])


  print, 'ccn_array_oe median ',median(ccn_array_oe_pre[conditions_cloud_pre]), median(ccn_array_oe_post[conditions_cloud_post])
  print, 'ccn_array_oe mean ',mean(ccn_array_oe_pre[conditions_cloud_pre]), mean(ccn_array_oe_post[conditions_cloud_post])


  print, 'nd median ',median(nd_oe_pre[conditions_cloud_pre]), median(nd_oe_post[conditions_cloud_post])
  print, 'nd mean ',mean(nd_oe_pre[conditions_cloud_pre]), mean(nd_oe_post[conditions_cloud_post])
  print, 'nd sdv ',stddev(nd_oe_pre[conditions_cloud_pre]), stddev(nd_oe_post[conditions_cloud_post])
  
  print, 're median ',median(re_top_oe_pre[conditions_cloud_pre]), median(re_top_oe_post[conditions_cloud_post])
  print, 're mean ',mean(re_top_oe_pre[conditions_cloud_pre]), mean(re_top_oe_post[conditions_cloud_post])
  print, 're sdv ',stddev(re_top_oe_pre[conditions_cloud_pre]), stddev(re_top_oe_post[conditions_cloud_post])
  
  ;print, 'lwp_oe_pre ',median(lwp_oe_pre[conditions_cloud_pre]), median(lwp_oe_post[conditions_cloud_post])
  
  print, 'rain rate median ',median(rain_rate_pre[where(rain_rate_pre gt 0.)]), median(rain_rate_post[where(rain_rate_post gt 0.)])
  print, 'rain rate mean ', mean(rain_rate_pre[where(rain_rate_pre gt 0.)]), mean(rain_rate_post[where(rain_rate_post gt 0.)])
  print, 'rain rate std ', stddev(rain_rate_pre[where(rain_rate_pre gt 0.)]), stddev(rain_rate_post[where(rain_rate_post gt 0.)])

;  print, 'fraction precip pre ', float(n_elements(rain_rate_pre[where(rain_rate_pre gt 0.001)]))/float(total(low_cloud_flag_pre))
;  print, 'fraction precip post ', float(n_elements(rain_rate_post[where(rain_rate_post gt 0.001)]))/float(total(low_cloud_flag_post))
 
;  print, 'fraction precip pre ', float(n_elements(conditions_cloud_precip_pre))/float(n_elements(conditions_cloud_pre))
;  print, 'fraction precip post ', float(n_elements(conditions_cloud_precip_post))/float(n_elements(conditions_cloud_post))
 
;  print, 'fraction precip pre ', float(n_elements(conditions_precip_pre2))/float(n_elements(conditions_pre2))
;  print, 'fraction precip post ', float(n_elements(conditions_precip_post2))/float(n_elements(conditions_pre2))
; 
;  print, 'Cloud Occurrrence pre ', float(n_elements(conditions_lwp_pre))/float(n_elements(conditions_vec_pre))
;  print, 'Cloud Occurrence post ',float(n_elements(conditions_lwp_post))/float(n_elements(conditions_vec_post))
  
  
;  conditions_cloud_pre_tau=where(optical_depth_post gt 0. and optical_depth_post lt 100. and m_test_output_pre lt 0.001 and m_test_output_pre gt 0. and nd_oe_pre gt 10. and nd_oe_pre lt 500. and re_top_oe_pre gt 5. and re_top_oe_pre lt 15.)
;  conditions_cloud_post_tau=where(optical_depth_post gt 0. and optical_depth_post lt 100. and m_test_output_post lt 0.001 and m_test_output_post gt 0. and nd_oe_post gt 10. and nd_oe_post lt 500. and re_top_oe_post gt 5. and re_top_oe_post lt 15.)

  print, 'optical depth median ', median(optical_depth_pre[conditions_cloud_pre]),median(optical_depth_post[conditions_cloud_post])
  print, 'optical depth mean ', mean(optical_depth_pre[conditions_cloud_pre]),mean(optical_depth_post[conditions_cloud_post])
  print, 'optical depth sdv ', stddev(optical_depth_pre[conditions_cloud_pre]),stddev(optical_depth_post[conditions_cloud_post])

  print, 'albedo median ', median(albedo_pre[conditions_cloud_pre]),median(albedo_post[conditions_cloud_post])
  print, 'albedo mean ', mean(albedo_pre[conditions_cloud_pre]),mean(albedo_post[conditions_cloud_post])
  print, 'albedo sdv ', stddev(albedo_pre[conditions_cloud_pre]),stddev(albedo_post[conditions_cloud_post])
  
  
;  lwp_oe_pre=lwp_oe1*fad_oe1
;  m_test_output_pre=m_test_output1
;  nd_oe_pre=nd_oe1
;  re_top_oe_pre=re_top_oe1
;  ccn_array_oe_pre=ccn_array1
;  albedo_pre=albedo1
;  optical_depth_pre=optical_depth1
;rain_rate_pre=rain_rate1
;dbz_avg_subcloud_pre=dbz_avg_subcloud1
;low_cloud_flag_pre=low_cloud_flag1
;julian_day_ret_pre=julian_day1
;    w_dir_cld_pre[j]=wind_dir[i]
;    w_spd_cld_pre[j]=wind_speed[i]

cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/ena_cld_pre.cdf',/clobber)
event_did=ncdf_dimdef(cdfid, 'events', n_elements(lwp_oe_pre))
lwp_id=ncdf_vardef(cdfid, 'lwp',[event_did],/float)
m_test_id=ncdf_vardef(cdfid, 'm_test',[event_did],/float)
nd_id=ncdf_vardef(cdfid, 'nd',[event_did],/float)
re_id=ncdf_vardef(cdfid, 're',[event_did],/float)
ccn_id=ncdf_vardef(cdfid, 'ccn',[event_did],/float)
albedo_id=ncdf_vardef(cdfid, 'albedo',[event_did],/float)
tau_id=ncdf_vardef(cdfid, 'tau',[event_did],/float)

rain_rate_id=ncdf_vardef(cdfid, 'rain_rate',[event_did],/float)
dbz_id=ncdf_vardef(cdfid, 'dbz',[event_did],/float)
low_cld_flag_id=ncdf_vardef(cdfid, 'low_cld_flag',[event_did],/float)
julian_day_id=ncdf_vardef(cdfid, 'julian_day',[event_did],/double)
w_dir_id=ncdf_vardef(cdfid, 'w_dir',[event_did],/float)
w_spd_id=ncdf_vardef(cdfid, 'w_spd',[event_did],/float)
ncdf_control, cdfid, /endef
ncdf_varput, cdfid, lwp_id, lwp_oe_pre
ncdf_varput, cdfid, m_test_id, m_test_output_pre
ncdf_varput, cdfid, nd_id, nd_oe_pre
ncdf_varput, cdfid, re_id, re_top_oe_pre
ncdf_varput, cdfid, ccn_id, ccn_array_oe_pre
ncdf_varput, cdfid, albedo_id, albedo_pre
ncdf_varput, cdfid, tau_id, optical_depth_pre
ncdf_varput, cdfid, rain_rate_id, rain_rate_pre
ncdf_varput, cdfid, dbz_id, dbz_avg_subcloud_pre
ncdf_varput, cdfid, low_cld_flag_id, low_cloud_flag_pre
ncdf_varput, cdfid, julian_day_id, julian_day_ret_pre
ncdf_varput, cdfid, w_dir_id, w_dir_cld_pre
ncdf_varput, cdfid, w_spd_id, w_spd_cld_pre
ncdf_close, cdfid

cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/ena_cld_post.cdf',/clobber)
event_did=ncdf_dimdef(cdfid, 'events', n_elements(lwp_oe_post))
lwp_id=ncdf_vardef(cdfid, 'lwp',[event_did],/float)
m_test_id=ncdf_vardef(cdfid, 'm_test',[event_did],/float)
nd_id=ncdf_vardef(cdfid, 'nd',[event_did],/float)
re_id=ncdf_vardef(cdfid, 're',[event_did],/float)
ccn_id=ncdf_vardef(cdfid, 'ccn',[event_did],/float)
tau_id=ncdf_vardef(cdfid, 'tau',[event_did],/float)
albedo_id=ncdf_vardef(cdfid, 'albedo',[event_did],/float)
rain_rate_id=ncdf_vardef(cdfid, 'rain_rate',[event_did],/float)
dbz_id=ncdf_vardef(cdfid, 'dbz',[event_did],/float)
low_cld_flag_id=ncdf_vardef(cdfid, 'low_cld_flag',[event_did],/float)
julian_day_id=ncdf_vardef(cdfid, 'julian_day',[event_did],/double)
w_dir_id=ncdf_vardef(cdfid, 'w_dir',[event_did],/float)
w_spd_id=ncdf_vardef(cdfid, 'w_spd',[event_did],/float)
ncdf_control, cdfid, /endef
ncdf_varput, cdfid, lwp_id, lwp_oe_post
ncdf_varput, cdfid, m_test_id, m_test_output_post
ncdf_varput, cdfid, nd_id, nd_oe_post
ncdf_varput, cdfid, re_id, re_top_oe_post
ncdf_varput, cdfid, ccn_id, ccn_array_oe_post
ncdf_varput, cdfid, albedo_id, albedo_post
ncdf_varput, cdfid, tau_id, optical_depth_post
ncdf_varput, cdfid, rain_rate_id, rain_rate_post
ncdf_varput, cdfid, dbz_id, dbz_avg_subcloud_post
ncdf_varput, cdfid, low_cld_flag_id, low_cloud_flag_post
ncdf_varput, cdfid, julian_day_id, julian_day_ret_post
ncdf_varput, cdfid, w_dir_id, w_dir_cld_post
ncdf_varput, cdfid, w_spd_id, w_spd_cld_post
ncdf_close, cdfid

;julday_mwr_pre=julday11
;lwp_pre=lwp11
;pwv_pre=pwv11
;irt_pre=irt11
;lwp_pre=lwp_pre*1.e3  ; convert to g/m2
;w_dir_mwr_pre[j]=wind_dir[i]
;w_spd_mwr_pre[j]=wind_speed[i]

cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/ena_lwp_pre.cdf',/clobber)
event_did=ncdf_dimdef(cdfid, 'events', n_elements(julday_mwr_pre))
lwp_id=ncdf_vardef(cdfid, 'lwp',[event_did],/float)
julday_id=ncdf_vardef(cdfid, 'julday',[event_did],/double)
pwv_id=ncdf_vardef(cdfid, 'pwv',[event_did],/float)
irt_id=ncdf_vardef(cdfid, 'irt',[event_did],/float)
w_dir_id=ncdf_vardef(cdfid, 'w_dir_mwr',[event_did],/float)
w_spd_id=ncdf_vardef(cdfid, 'w_spd_mwr',[event_did],/float)
ncdf_control, cdfid, /endef
ncdf_varput, cdfid, julday_id, julday_mwr_pre
ncdf_varput, cdfid, lwp_id, lwp_pre
ncdf_varput, cdfid, pwv_id, pwv_pre
ncdf_varput, cdfid, irt_id, irt_pre
ncdf_varput, cdfid, w_dir_id, w_dir_mwr_pre
ncdf_varput, cdfid, w_spd_id, w_spd_mwr_pre
ncdf_close, cdfid

cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/ena_lwp_post.cdf',/clobber)
event_did=ncdf_dimdef(cdfid, 'events', n_elements(julday_mwr_post))
julday_id=ncdf_vardef(cdfid, 'julday',[event_did],/double)
lwp_id=ncdf_vardef(cdfid, 'lwp',[event_did],/float)
pwv_id=ncdf_vardef(cdfid, 'pwv',[event_did],/float)
irt_id=ncdf_vardef(cdfid, 'irt',[event_did],/float)
w_dir_id=ncdf_vardef(cdfid, 'w_dir_mwr',[event_did],/float)
w_spd_id=ncdf_vardef(cdfid, 'w_spd_mwr',[event_did],/float)
ncdf_control, cdfid, /endef
ncdf_varput, cdfid, julday_id, julday_mwr_post
ncdf_varput, cdfid, lwp_id, lwp_post
ncdf_varput, cdfid, pwv_id, pwv_post
ncdf_varput, cdfid, irt_id, irt_post
ncdf_varput, cdfid, w_dir_id, w_dir_mwr_post
ncdf_varput, cdfid, w_spd_id, w_spd_mwr_post
ncdf_close, cdfid


;julday_pre=[julday_pre,julday_out]
;ss_calc_pre=[ss_calc_pre,ss_out]
;cn_pre=[cn_pre,cn_out]
;ccn_pre=[ccn_pre,ccn_out]
;qc_ccn_pre=[qc_ccn_pre,qc_out]
;endelse
;
;endfor  ; for j=0,count-1 do begin
;
;endfor  ; for jj=0,n_elements(months)-1 do begin
;
;w_dir_pre=fltarr(n_elements(julday_pre))
;w_spd_pre=fltarr(n_elements(julday_pre))
;for j=0,n_elements(julday_pre)-1 do begin
;  i=where(abs(julday_pre[j]-julday_smet) eq min(abs(julday_pre[j]-julday_smet))) & i=i[0]
;  if (abs(julday_pre[j]-julday_smet[i]))*86400.d lt 1200.d then begin
;    w_dir_pre[j]=wind_dir[i]
;    w_spd_pre[j]=wind_speed[i]

cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/ena_ccn_pre.cdf',/clobber)
event_did=ncdf_dimdef(cdfid, 'events', n_elements(julday_pre))
ss_calc_id=ncdf_vardef(cdfid, 'ss_calc',[event_did],/float)
cn_calc_id=ncdf_vardef(cdfid, 'cn_calc',[event_did],/float)
ccn_calc_id=ncdf_vardef(cdfid, 'ccn_calc',[event_did],/float)
wdir_id=ncdf_vardef(cdfid, 'wdir',[event_did],/float)
wspd_id=ncdf_vardef(cdfid, 'wsdp',[event_did],/float)
qc_id=ncdf_vardef(cdfid, 'qc',[event_did],/float)
julday_id=ncdf_vardef(cdfid, 'julday',[event_did],/double)
ncdf_control, cdfid, /endef
ncdf_varput, cdfid, ss_calc_id, ss_calc_pre
ncdf_varput, cdfid, cn_calc_id, cn_pre
ncdf_varput, cdfid, ccn_calc_id, ccn_pre
ncdf_varput, cdfid, wdir_id, w_dir_pre
ncdf_varput, cdfid, wspd_id, w_spd_pre
ncdf_varput, cdfid, qc_id, qc_ccn_pre
ncdf_varput, cdfid, julday_id, julday_pre
ncdf_close, cdfid

cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/ena_ccn_post.cdf',/clobber)
event_did=ncdf_dimdef(cdfid, 'events', n_elements(julday_post))
ss_calc_id=ncdf_vardef(cdfid, 'ss_calc',[event_did],/float)
cn_calc_id=ncdf_vardef(cdfid, 'cn_calc',[event_did],/float)
ccn_calc_id=ncdf_vardef(cdfid, 'ccn_calc',[event_did],/float)
wdir_id=ncdf_vardef(cdfid, 'wdir',[event_did],/float)
wspd_id=ncdf_vardef(cdfid, 'wsdp',[event_did],/float)
qc_id=ncdf_vardef(cdfid, 'qc',[event_did],/float)
julday_id=ncdf_vardef(cdfid, 'julday',[event_did],/double)
ncdf_control, cdfid, /endef
ncdf_varput, cdfid, ss_calc_id, ss_calc_post
ncdf_varput, cdfid, cn_calc_id, cn_post
ncdf_varput, cdfid, ccn_calc_id, ccn_post
ncdf_varput, cdfid, wdir_id, w_dir_post
ncdf_varput, cdfid, wspd_id, w_spd_post
ncdf_varput, cdfid, qc_id, qc_ccn_post
ncdf_varput, cdfid, julday_id, julday_post
ncdf_close, cdfid



  ;;;;;;;;;  write nd data
  cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/pwv_PRE_POST.cdf',/clobber)
  event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(pwv_pre[conditions_lwp_pre]))
  event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(pwv_post[conditions_lwp_post]))
  albedo_pre_id=ncdf_vardef(cdfid, 'pwv_pre',[event_pre_did],/float)
  ncdf_attput, cdfid, albedo_pre_id, 'long_name', 'albedo Pre 2020'
  ncdf_attput, cdfid, albedo_pre_id, 'units', 'cm'
  albedo_post_id=ncdf_vardef(cdfid, 'pwv_post',[event_post_did],/float)
  ncdf_attput, cdfid, albedo_post_id, 'long_name', 'albedo Post 2020'
  ncdf_attput, cdfid, albedo_post_id, 'units', 'cm'
  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, albedo_pre_id, pwv_pre[conditions_lwp_pre]
  ncdf_varput, cdfid, albedo_post_id, pwv_post[conditions_lwp_post]
  ncdf_close, cdfid
  ;;;;; done re_oe

  ;;;;;;;;;  write nd data
  cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/albedo_PRE_POST.cdf',/clobber)
  event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(albedo_pre[conditions_cloud_pre]))
  event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(albedo_post[conditions_cloud_post]))
  albedo_pre_id=ncdf_vardef(cdfid, 'albedo_pre',[event_pre_did],/float)
  ncdf_attput, cdfid, albedo_pre_id, 'long_name', 'albedo Pre 2020'
  ncdf_attput, cdfid, albedo_pre_id, 'units', 'unitless'
  albedo_post_id=ncdf_vardef(cdfid, 'albedo_post',[event_post_did],/float)
  ncdf_attput, cdfid, albedo_post_id, 'long_name', 'albedo Post 2020'
  ncdf_attput, cdfid, albedo_post_id, 'units', 'unitless'
  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, albedo_pre_id, albedo_pre[conditions_cloud_pre]
  ncdf_varput, cdfid, albedo_post_id, albedo_post[conditions_cloud_post]
  ncdf_close, cdfid
  ;;;;; done re_oe
  ;;;;;;;;;  write nd data
  cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/optical_depth_PRE_POST.cdf',/clobber)
  event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(optical_depth_pre[conditions_cloud_pre]))
  event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(optical_depth_post[conditions_cloud_post]))
  optical_depth_pre_id=ncdf_vardef(cdfid, 'optical_depth_pre',[event_pre_did],/float)
  ncdf_attput, cdfid, optical_depth_pre_id, 'long_name', 'optical_depth Pre 2020'
  ncdf_attput, cdfid, optical_depth_pre_id, 'units', 'unitless'
  optical_depth_post_id=ncdf_vardef(cdfid, 'optical_depth_post',[event_post_did],/float)
  ncdf_attput, cdfid, optical_depth_post_id, 'long_name', 'optical_depth Post 2020'
  ncdf_attput, cdfid, optical_depth_post_id, 'units', 'unitless'
  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, optical_depth_pre_id, optical_depth_pre[conditions_cloud_pre]
  ncdf_varput, cdfid, optical_depth_post_id, optical_depth_post[conditions_cloud_post]
  ncdf_close, cdfid
  ;;;;; done re_oe
  ;;;;;;;;;  write nd data
  cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/rain_rate_PRE_POST.cdf',/clobber)
  event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(rain_rate_pre[conditions_precip_pre2]))
  event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(rain_rate_post[conditions_precip_post2]))
  rain_rate_pre_id=ncdf_vardef(cdfid, 'rain_rate_pre',[event_pre_did],/float)
  ncdf_attput, cdfid, rain_rate_pre_id, 'long_name', 'rain_rate Pre 2020'
  ncdf_attput, cdfid, rain_rate_pre_id, 'units', 'mm/day'
  rain_rate_post_id=ncdf_vardef(cdfid, 'rain_rate_post',[event_post_did],/float)
  ncdf_attput, cdfid, rain_rate_post_id, 'long_name', 'rain_rate Post 2020'
  ncdf_attput, cdfid, rain_rate_post_id, 'units', 'mm/day'
  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, rain_rate_pre_id, rain_rate_pre[conditions_precip_pre2]
  ncdf_varput, cdfid, rain_rate_post_id, rain_rate_post[conditions_precip_post2]
  ncdf_close, cdfid
  ;;;;; done re_oe
  ;;;;;;;;;  write nd data
  cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/re_oe_PRE_POST.cdf',/clobber)
  event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(re_top_oe_pre[conditions_cloud_pre]))
  event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(re_top_oe_post[conditions_cloud_post]))
  re_top_oe_pre_id=ncdf_vardef(cdfid, 're_top_oe_pre',[event_pre_did],/float)
  ncdf_attput, cdfid, re_top_oe_pre_id, 'long_name', 're_top_oe Pre 2020'
  ncdf_attput, cdfid, re_top_oe_pre_id, 'units', 'microns'
  re_top_oe_post_id=ncdf_vardef(cdfid, 're_top_oe_post',[event_post_did],/float)
  ncdf_attput, cdfid, re_top_oe_post_id, 'long_name', 're_top_oe Post 2020'
  ncdf_attput, cdfid, re_top_oe_post_id, 'units', 'microns'
  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, re_top_oe_pre_id, re_top_oe_pre[conditions_cloud_pre]
  ncdf_varput, cdfid, re_top_oe_post_id, re_top_oe_post[conditions_cloud_post]
  ncdf_close, cdfid
  ;;;;; done re_oe
  ;;;;;;;;;  write nd data
  cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/nd_oe_PRE_POST.cdf',/clobber)
  event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(nd_oe_pre[conditions_cloud_pre]))
  event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(nd_oe_post[conditions_cloud_post]))
  nd_oe_pre_id=ncdf_vardef(cdfid, 'nd_oe_pre',[event_pre_did],/float)
  ncdf_attput, cdfid, nd_oe_pre_id, 'long_name', 'nd_oe Pre 2020'
  ncdf_attput, cdfid, nd_oe_pre_id, 'units', '# per cubic cm'
  nd_oe_post_id=ncdf_vardef(cdfid, 'nd_oe_post',[event_post_did],/float)
  ncdf_attput, cdfid, nd_oe_post_id, 'long_name', 'nd_oe Post 2020'
  ncdf_attput, cdfid, nd_oe_post_id, 'units', '# per cubic cm'
  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, nd_oe_pre_id, nd_oe_pre[conditions_cloud_pre]
  ncdf_varput, cdfid, nd_oe_post_id, nd_oe_post[conditions_cloud_post]
  ncdf_close, cdfid
  ;;;;; done nd_oe
  ;;;;;;;;;  write lwp data
  cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/lwp_oe_PRE_POST.cdf',/clobber)
  event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(lwp_oe_pre[conditions_cloud_pre]))
  event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(lwp_oe_post[conditions_cloud_post]))
  lwp_oe_pre_id=ncdf_vardef(cdfid, 'lwp_oe_pre',[event_pre_did],/float)
  ncdf_attput, cdfid, lwp_oe_pre_id, 'long_name', 'lwp_oe Pre 2020'
  ncdf_attput, cdfid, lwp_oe_pre_id, 'units', 'grams per meter squared'
  lwp_oe_post_id=ncdf_vardef(cdfid, 'lwp_oe_post',[event_post_did],/float)
  ncdf_attput, cdfid, lwp_oe_post_id, 'long_name', 'lwp_oe Post 2020'
  ncdf_attput, cdfid, lwp_oe_post_id, 'units', 'grams per meter squared'
  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, lwp_oe_pre_id, lwp_oe_pre[conditions_cloud_pre]
  ncdf_varput, cdfid, lwp_oe_post_id, lwp_oe_post[conditions_cloud_post]
  ncdf_close, cdfid
  ;;;;; done lwp_oe
;;;;;;;;;  write ccn data
  cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/ccn_PRE_POST.cdf',/clobber)
  event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(ccn_pre[conditions_vec_pre]))
  event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(ccn_post[conditions_vec_post]))
  ccn_pre_id=ncdf_vardef(cdfid, 'ccn_pre',[event_pre_did],/float)
  ncdf_attput, cdfid, ccn_pre_id, 'long_name', 'CCN SS 0.2 Pre 2020'
  ncdf_attput, cdfid, ccn_pre_id, 'units', '# per cubic cm'
  ccn_post_id=ncdf_vardef(cdfid, 'ccn_post',[event_post_did],/float)
  ncdf_attput, cdfid, ccn_post_id, 'long_name', 'CCN SS 0.2 Post 2020'
  ncdf_attput, cdfid, ccn_post_id, 'units', '# per cubic cm'
  ncdf_control, cdfid, /endef
  ncdf_varput, cdfid, ccn_pre_id, ccn_pre[conditions_vec_pre]
  ncdf_varput, cdfid, ccn_post_id, ccn_post[conditions_vec_post]
  ncdf_close, cdfid
;;;;; done ccn
;;;;;;;;;  write cn data
cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/cn_PRE_POST.cdf',/clobber)
event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(cn_pre[conditions_cn_pre]))
event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(cn_post[conditions_cn_post]))
cn_pre_id=ncdf_vardef(cdfid, 'cn_pre',[event_pre_did],/float)
ncdf_attput, cdfid, cn_pre_id, 'long_name', 'CN Pre 2020'
ncdf_attput, cdfid, cn_pre_id, 'units', '# per cubic cm'
cn_post_id=ncdf_vardef(cdfid, 'cn_post',[event_post_did],/float)
ncdf_attput, cdfid, cn_post_id, 'long_name', 'cn Post 2020'
ncdf_attput, cdfid, cn_post_id, 'units', '# per cubic cm'
ncdf_control, cdfid, /endef
ncdf_varput, cdfid, cn_pre_id, cn_pre[conditions_cn_pre]
ncdf_varput, cdfid, cn_post_id, cn_post[conditions_cn_post]
ncdf_close, cdfid
;;;;; done cn
;;;;;;;;;  write wind speed data
cdfid=ncdf_create('/Users/u0029340/Documents/data/ena/graphics/wind_speed_during_clds_PRE_POST.cdf',/clobber)
event_pre_did=ncdf_dimdef(cdfid, 'events_pre', n_elements(w_spd_cld_pre[conditions_cloud_pre]))
event_post_did=ncdf_dimdef(cdfid, 'events_post', n_elements(w_spd_cld_post[conditions_cloud_post]))
cn_pre_id=ncdf_vardef(cdfid, 'w_spd_cld_pre',[event_pre_did],/float)
ncdf_attput, cdfid, cn_pre_id, 'long_name', 'w_spd Pre 2020'
ncdf_attput, cdfid, cn_pre_id, 'units', 'm/s'
cn_post_id=ncdf_vardef(cdfid, 'w_spd_cld_post',[event_post_did],/float)
ncdf_attput, cdfid, cn_post_id, 'long_name', 'wind speed Post 2020'
ncdf_attput, cdfid, cn_post_id, 'units', 'm/s'
ncdf_control, cdfid, /endef
ncdf_varput, cdfid, cn_pre_id, w_spd_cld_pre[conditions_cloud_pre]
ncdf_varput, cdfid, cn_post_id, w_spd_cld_post[conditions_cloud_post]
ncdf_close, cdfid
;;;;; done cn




  Result_ccn = TM_TEST( ccn_pre[conditions_vec_pre], ccn_post[conditions_vec_post] )
;  Result_cn = TM_TEST( cn_pre[conditions_cn_pre], cn_post[conditions_cn_post] )
  
  Result_ccn = TM_TEST( albedo_pre[conditions_cloud_pre], albedo_post[conditions_cloud_post], /unequal )


  lin_histo_2, xx[where(xx gt 0.)], yy[where(yy gt 0.)], 2, 20, wspd_pre_histo1, wspd_post_histo2, wspd_bins, $
    wspd_pre_moments1, wspd_post_moments2, wspd_pre_med1, wdpd_post_med2, num


lin_histo_2, ccn_pre[conditions_vec_pre], ccn_post[conditions_vec_post], 2, 20, ccn_pre_histo1, ccn_post_histo2, ccn_bins, $
  ccn_pre_moments1, ccn_post_moments2, ccn_pre_med1, ccn_post_med2, num

  lin_histo_2, cn_pre[conditions_cn_pre], cn_post[conditions_cn_post], 3, 20, cn_pre_histo1, cn_post_histo2, cn_bins, $
    cn_pre_moments1, cn_post_moments2, cn_pre_med1, cn_post_med2, num

  lin_histo_2, lwp_oe_pre[conditions_cloud_pre], lwp_oe_post[conditions_cloud_post], 3, 40, lwp_pre_histo1, lwp_post_histo2, lwp_bins, $
    lwp_pre_moments1, lwp_post_moments2, lwp_pre_med1, lwp_post_med2, num
    
    
;    x=lwp_oe_pre[conditions_lwp_pre]
;    y=lwp_oe_post[conditions_lwp_post]
;    
;    lin_histo_2, x[where(x gt 0. and x lt 400. and y gt 0. and y lt 400.)], y[where(x gt 0. and x lt 400. and y gt 0. and y lt 400.)], 3, 20, lwp_pre_histo1, lwp_post_histo2, lwp_bins, $
;    lwp_pre_moments1, lwp_post_moments2, lwp_pre_med1, lwp_post_med2, num
;

  lin_histo_2, pwv_pre[conditions_lwp_pre], pwv_post[conditions_lwp_post], 3, 20, pwv_pre_histo1, pwv_post_histo2, pwv_bins, $
    pwv_pre_moments1, pwv_post_moments2, pwv_pre_med1, pwv_post_med2, num
    
    lin_histo_2, nd_oe_pre[conditions_cloud_pre], nd_oe_post[conditions_cloud_post], 3, 30, nd_pre_histo1, nd_post_histo2, nd_bins, $
    nd_pre_moments1, nd_post_moments2, nd_pre_med1, nd_post_med2, num

  lin_histo_2, re_top_oe_pre[conditions_cloud_pre], re_top_oe_post[conditions_cloud_post], 3, 20, re_pre_histo1, re_post_histo2, re_bins, $
    re_pre_moments1, re_post_moments2, re_pre_med1, re_post_med2, num

  lin_histo_2, rain_rate_pre[conditions_precip_pre2], rain_rate_post[conditions_precip_post2], 3, 40, rain_pre_histo1, rain_post_histo2, rain_bins, $
    rain_pre_moments1, rain_post_moments2, rain_pre_med1, rain_post_med2, num
    
    lin_histo_2_logplot, rain_rate_pre[conditions_precip_pre2], rain_rate_post[conditions_precip_post2], 3, 40, rain_pre_histo1, rain_post_histo2, rain_bins, $
    rain_pre_moments1, rain_post_moments2, rain_pre_med1, rain_post_med2, num, 1.e-3, 50., 1.2
    
    lin_histo_2, albedo_pre[conditions_cloud_pre], albedo_post[conditions_cloud_post], 3, 15, albedo_pre_histo1, albedo_post_histo2, albedo_bins, $
    albedo_pre_moments1, albedo_post_moments2, albedo_pre_med1, albedo_post_med2, num

  lin_histo_2, optical_depth_pre[conditions_cloud_pre], optical_depth_post[conditions_cloud_post], 3, 15, optical_depth_pre_histo1, optical_depth_post_histo2, optical_depth_bins, $
    optical_depth_pre_moments1, optical_depth_post_moments2, optical_depth_pre_med1, optical_depth_post_med2, num


; create a histogram plot


set_plot, 'Z'
loadct, 5 & gamma_ct, 1.0 & set_plot, 'Z' & device, set_resolution=[3000,2000] & !p.charsize=3.25 & !p.font=-1 & !p.background=!d.n_colors-1
top_top_y=0.93 & dy=0.1 & top_y=0.95 & bot_y=top_y-dy & sep_y=0.05
sx=0.12 & sy=0.06 & xl=0.1 & xr=0.9 & yt=0.95 & yb=0.1
!p.thick=3. & numplots_x=3 & numplots_y=3
position_plots,xl,xr,yb,yt,sx,sy,numplots_x,numplots_y,pos
cbpos=pos & cbpos[*,0]=cbpos[*,2]+0.08 & cbpos[*,2]=cbpos[*,0]+0.012
!p.multi=[0,4,4]

pnum=8


plot, nd_bins[where(nd_bins ge -10.)], nd_pre_histo1[where(nd_bins ge -10.)]/float(total(nd_pre_histo1[where(nd_bins ge -10.)])), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='Nd per cc', ytitle='Frequency', title='Nd Pre 2020 (black), Post 2020 (red) ',  $
  charsize=3.25, charthick=4, yrange=[0.,0.35] ;max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])

oplot, nd_bins[where(nd_bins ge -10.)],nd_post_histo2[where(nd_bins ge -10.)]/float(total(nd_post_histo2[where(nd_bins ge -10.)])), psym=10, color=100

pnum=7


plot, re_bins[where(re_bins ge 0. and re_bins lt 25.)], re_pre_histo1[where(re_bins ge 0. and re_bins lt 25.)]/float(total(re_pre_histo1[where(re_bins ge 0. and re_bins lt 25.)])), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='re (microns)', ytitle='Frequency', title='re Pre 2020 (black), Post 2020 (red) ',  $
  charsize=3.25, charthick=4, yrange=[0.,max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])]

oplot, re_bins[where(re_bins ge 0. and re_bins lt 25.)],re_post_histo2[where(re_bins ge 0. and re_bins lt 25.)]/float(total(re_post_histo2[where(re_bins ge 0. and re_bins lt 25.)])), psym=10, color=100

pnum=6


plot, rain_bins[where(rain_bins ge 0.)], rain_pre_histo1[where(rain_bins ge 0.)]/float(total(rain_pre_histo1[where(rain_bins ge 0.)])), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='Drizzle Rate (mm/day)', ytitle='Frequency', title='P Rate (mm/day) Pre 2020 (black), Post 2020 (red) ',  $
  charsize=3.25, charthick=4, yrange=[1.e-4,max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])], xrange=[0.001,0.2],/ylog;, /xlog

oplot, rain_bins[where(rain_bins ge 0.)],rain_post_histo2[where(rain_bins ge 0.)]/float(total(rain_post_histo2[where(rain_bins ge 0.)])), psym=10, color=100

pnum=5

plot, optical_depth_bins[where(optical_depth_bins ge 0.)], optical_depth_pre_histo1[where(optical_depth_bins ge 0.)]/float(total(optical_depth_pre_histo1[where(optical_depth_bins ge 0.)])), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='optical depth ', ytitle='Frequency', title='Optical Depth Pre 2020 (black), Post 2020 (red) ',  $
  charsize=3.25, charthick=4, yrange=[0.,max(optical_depth_pre_histo1[where(optical_depth_bins ge 0.)]/float(total(optical_depth_pre_histo1[where(optical_depth_bins ge 0.)])))]
  
oplot, optical_depth_bins[where(optical_depth_bins ge 0.)],optical_depth_post_histo2[where(optical_depth_bins ge 0.)]/float(total(optical_depth_post_histo2[where(optical_depth_bins ge 0.)])), psym=10, color=100

pnum=4

plot, albedo_bins[where(albedo_bins ge 0.)], albedo_pre_histo1[where(albedo_bins ge 0.)]/float(total(albedo_pre_histo1[where(albedo_bins ge 0.)])), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='albedo ', ytitle='Frequency', title='Albedo Pre 2020 (black), Post 2020 (red) ',  $
  charsize=3.25, charthick=4, yrange=[0.,0.25]

oplot, albedo_bins[where(albedo_bins ge 0.)],albedo_post_histo2[where(albedo_bins ge 0.)]/float(total(albedo_post_histo2[where(albedo_bins ge 0.)])), psym=10, color=100


pnum=3

;c=a_warm & c1=b_warm & c2=c_warm & l=LWP_Warm & n=nd_warm & p=precip_rates_warm
;print, total((c*(l^(c1*1.0))*(n^(c2)))-p)/mean(p), correlate(c*(l^(c1*1.0))*(n^(c2)), p)

;string='LWP Exponent: '+strtrim(string(b_warm, '(f5.3)'),2)+' Nd Exponent: '+strtrim(string(c_warm, '(f6.3)'),2)

plot, ccn_bins, ccn_pre_histo1/float(total(ccn_pre_histo1)), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='CCN per cc', ytitle='Frequency', title='CCN SS 0.3 Pre 2020 (black), Post 2020 (red) ',  $
  charsize=3.25, charthick=4, yrange=[0.,max([ccn_pre_histo1/float(total(ccn_pre_histo1)),ccn_post_histo2/float(total(ccn_post_histo2))])]

oplot, ccn_bins,ccn_post_histo2/float(total(ccn_post_histo2)), psym=10, color=100

;xyouts, 0.0002, 0.4, 'r: '+strtrim(string(correlate(c*(l^(c1*1.0))*(n^(c2)), p), '(f5.3)'),2), color=0, charsize=2, charthick=5, /data

pnum=2

;c=a_cold & c1=b_cold & c2=c_cold & l=LWP_cold & n=nd_cold & p=precip_rates_cold
;print, total((c*(l^(c1*1.0))*(n^(c2)))-p)/mean(p), correlate(c*(l^(c1*1.0))*(n^(c2)), p)

;string='LWP Exponent: '+strtrim(string(b_cold, '(f5.3)'),2)+' Nd Exponent: '+strtrim(string(c_cold, '(f5.2)'),2)

;plot, cn_bins, cn_pre_histo1/float(total(cn_pre_histo1)), color=0,$
;  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='CN per cc', ytitle='Frequency', title='CN Pre 2020 (black), Post 2020 (red) ',$
;  charsize=3.25, charthick=4, yrange=[0.,max([cn_pre_histo1/float(total(cn_pre_histo1)),cn_post_histo2]/float(total(cn_post_histo2)))]
;
;oplot, cn_bins, cn_post_histo2/float(total(cn_post_histo2)), psym=10, color=100

;lin_histo_2, w_spd_cld_pre[conditions_cloud_pre], w_spd_cld_post[conditions_cloud_post], 2, 20, wspd_pre_histo1, wspd_post_histo2, wspd_bins, $
;  wspd_pre_moments1, wspd_post_moments2, wspd_pre_med1, wdpd_post_med2, num

;xyouts, 0.0002, 0.4, 'r: '+strtrim(string(correlate(c*(l^(c1*1.0))*(n^(c2)), p), '(f5.3)'),2), color=0, charsize=2, charthick=5, /data

plot, wspd_bins, wspd_pre_histo1/float(total(wspd_pre_histo1)), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='wind speed (m/s)', ytitle='Frequency', title='Wind Speed Pre 2020 (black), Post 2020 (red) ',$
  charsize=3.25, charthick=4, yrange=[0.,max([wspd_pre_histo1/float(total(wspd_pre_histo1)),wspd_post_histo2]/float(total(wspd_post_histo2)))]

oplot, wspd_bins, wspd_post_histo2/float(total(wspd_post_histo2)), psym=10, color=100


pnum=1

plot, lwp_bins[where(lwp_bins ge 0.)], lwp_pre_histo1[where(lwp_bins ge 0.)]/float(total(lwp_pre_histo1[where(lwp_bins ge 0.)])), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='LWP g/m2', ytitle='Frequency', title='LWP Pre 2020 (black), Post 2020 (red) ',  $
  charsize=3.25, charthick=4, yrange=[0.,max([lwp_pre_histo1/float(total(lwp_pre_histo1)),lwp_post_histo2/float(total(lwp_post_histo2))])]

oplot, lwp_bins[where(lwp_bins ge 0.)],lwp_post_histo2[where(lwp_bins ge 0.)]/float(total(lwp_post_histo2[where(lwp_bins ge 0.)])), psym=10, color=100

pnum=0

plot, pwv_bins, pwv_pre_histo1/float(total(pwv_pre_histo1)), color=0,$
  pos=pos[pnum,*], xstyle=0, ystyle=0, psym=10, thick=5, xtitle='PWV cm', ytitle='Frequency', title='PWV Pre 2020 (black), Post 2020 (red) ',  $
  charsize=3.25, charthick=4, yrange=[0.,max([pwv_pre_histo1/float(total(pwv_pre_histo1)),pwv_post_histo2/float(total(pwv_post_histo2))])]

oplot, pwv_bins,pwv_post_histo2/float(total(pwv_post_histo2)), psym=10, color=100


write_gif, '/Users/u0029340/Documents/data/ena/graphics/ccn_ccn_mwr_clouds_precip_comp_PRE_POST_2025.gif',tvrd()

print, sqrt(ccn_pre_moments1[1])/ccn_pre_moments1[0], sqrt(ccn_post_moments2[1])/ccn_post_moments2[0]


stop
end