pro calculate_lidar_atten_backscatter_profile_liquid_cloud, height, temp, press, tau_accum_below_liq, re_cld, ext_cld, lwc_cld, lwp_cld, nd_cld,$
eta, cld_top_index, cld_base_index,domain_name, file_path, plot_flag, fad,tau_at_extinction,extinction,nd_per_eta,best_delta,mean_depth_to_max,const,nd_per_ln,B, $
z_ln_cor, re_top, gamma_l

;;;;;; this routine is adapted from eccc_mixed_phase_lidar_anal.pro in eccc_retrieval_analysis
; eta is the multiple scattering factor
; pressure and temperature input in Pa and K
; height is input in m
; re_cld is input in cm
; ext_cld is input in per cm
; lwc_cld is input in g/cm3 ; for plotting only
; lwp_cld is input in g/m2  ; for plotting

Rd=287.04d
Rv=461.5d
Lv=2.27d6
g=9.81d  ; m/s2
cp=1003.5d ; j/kg/k   approximate between 250K and 300 K
rho_liquid=1.d6 ; grams per cubic meter


  ;;;;; calculate the molecular lidar backscatter and extinction profile
  lidar_gas_back_532=fltarr(n_elements(height))
  lidar_gas_ext_532=fltarr(n_elements(height))
  tau_mol_532_accum_below=fltarr(n_elements(height))
  tau_mol_532=0. & tau_mol_1064=0.
  ;rh_pro=rh_pro_out
  for k=n_elements(height)-1,0,-1 do begin
    if height[k] gt 0. then begin

      result=lidar_gas_rayleigh_backscatter_extinction_functionuse(press[k], temp[k], 0.532d-6)
      lidar_gas_back_532[k]=result[0] ; 1/m/sr
      lidar_gas_ext_532[k]=result[1]  ; 1/m
;      tau_mol_532=tau_mol_532+(lidar_gas_ext_532[k]*((height[2]-height[1])))
;      tau_mol_532_accum[k]=total(((height[2]-height[1]))*lidar_gas_ext_532[k:n_elements(height)-1])

    endif
  endfor

  for k=0,n_elements(height)-1 do begin
    tau_mol_532_accum_below[k]=total(((height[2]-height[1]))*lidar_gas_ext_532[0:k])
  endfor
  
  lidar_532_att_back_below_x=fltarr(n_elements(height))
  lidar_532_att_back_below_l=fltarr(n_elements(height))
  tau_salt_accum_below=fltarr(n_elements(height))
  lidar_532_att_back_below_no_snow_x=fltarr(n_elements(height))
  lidar_532_att_back_below_no_snow_l=fltarr(n_elements(height))
  lidar_liq_532_back=fltarr(n_elements(height))
  lidar_532_att_back_below=fltarr(n_elements(height))
  Sc=fltarr(n_elements(height))
  
  i_top=cld_top_index[0]
  i_base=cld_base_index[0]

  gamma_m=double(moist_adiabatic_lapse_rate(temp[i_base[0]], 1., press[i_base[0]]*100.))/1000.d   ; k/m
  cw=((press[i_base[0]]*100.)/(rd*temp[i_base[0]]))*(cp/lv)*((g/cp)-gamma_m)  ; condensation rate from Grosvenor et al, 2018 equation 14. kg/m3/m

  layer_int_atten_back_l=0.
  layer_int_atten_back_x=0.


  max_depol=0.
  for k=0,i_top do begin
    
    ;re=169.72-8.53SSc
    lidar_ratio=(169.72-(re_cld[k]*1.e4))/8.5355  ; Mace, Benson, Hu, 2020
    if re_cld[k] gt 0. then Sc[k]=lidar_ratio
    
    ; attenuated backscatter
    lidar_liq_532_back[k]=(ext_cld[k]*1.e2)/lidar_ratio  ; 1/m/sr



    ;tau_salt_accum_below[k]=((height[cld_top_index[0]]-height[k])/height[cld_base_index[0]])*sea_salt_optical_depth

    ;lidar_salt_back=((sea_salt_optical_depth/((height[cld_top_index[0]])))/lidar_ratio_sea_salt)/1000.  ; 1/m/sr

    ;atten=exp(-2.*((eta*(tau_accum_below_snow[k]+tau_accum_below_liq[k]))+tau_mol_532_accum_below[k]+tau_salt_accum_below[k]))
    if k gt 0 then begin
      atten=exp(-2.*((eta*(tau_accum_below_liq[k-1]))+tau_mol_532_accum_below[k]))
    endif else begin
      atten=0.
    endelse

    lidar_532_att_back_below[k]=1000.*(lidar_liq_532_back[k]+lidar_gas_back_532[k])*atten
;    lidar_532_att_back_below_x[k]=1000.*(lidar_liq_532_back_x[k]+lidar_snow_532_back_x[k]+(0.0284*lidar_gas_back_532[k]+(lidar_salt_back*sea_salt_depol)))*atten

;if re_cld[k] gt 0. then begin
;  ;;;; the following tests various parts of the nd_ln derivation on pg 21 of notes dated 8/18/2022
;if k gt 1 then begin
;  dln_beta_prime=(double(lidar_532_att_back_below[k])-double(lidar_532_att_back_below[k-2]))/(double(height[k]-height[k-2])*double(lidar_532_att_back_below[k-1]))
;  dln_beta=(lidar_liq_532_back[k]-lidar_liq_532_back[k-2])/((height[k]-height[k-2])*lidar_liq_532_back[k-1])
;;  eta_sigma=2.*eta*(ext_cld[k-1]*1.e2)
;;  print, 'dln_beta_prime,dln_beta,eta_sigam,dln_beta-eta_sigma',dln_beta_prime,dln_beta,eta_sigma,dln_beta-eta_sigma,(dln_beta-eta_sigma)/dln_beta_prime
;
;dln_sigma=(ext_cld[k]-ext_cld[k-2])/((height[k]-height[k-2])*ext_cld[k-1])
;dln_q=(double(lwc_cld[k])-double(lwc_cld[k-2]))/(double(height[k]-height[k-2])*double(lwc_cld[k-1]))
;;print, 'dln_sigma, dln_beta',dln_sigma, dln_beta,0.667*dln_q
;
;term3=2.*eta*((nd_cld*1.e6)^(1./3.))*((lwc_cld[k-1])^(2./3.))*B[k-1]
;term33=(2.d)*double(eta)*((double(lwc_cld[k-1]))^(2.d/3.d))*double(B[k-1])
;
;
;;term2=2.*eta*(ext_cld[k-1])
;;print, term2, term3
;;print, '0.667*dln_q, term2, dln_beta_prime,(0.667*dln_q)-term2',0.667*dln_q, term3, dln_beta_prime,(0.667*dln_q)-term3
;
;;print, dln_beta_prime,(((((2.d/3.d)*dln_q)-dln_beta_prime)/term33)^3)*1.e-6, nd_cld
;
;;print, dln_q,1./((height[k-1]-height[i_base]))
;
;
;dln_q_approx=1./((height[k-1]-height[i_base]))
;term33=(2.d)*double(eta)*((double((cw*1000.)*(height[k-1]-height[i_base])*fad)*1.d-6)^(2.d/3.d))*double(B[k-1])
;
;;print, dln_beta_prime,(((((2.d/3.d)*dln_q_approx)-dln_beta_prime)/term33)^3)*1.e-6, nd_cld
;
;term333=(cw*1000.)*(height[k-1]-height[i_base])*fad
;
;;print, lwc_cld[k-1]*1.e6,(cw*1000.)*(height[k-1]-height[i_base])*fad
;
;;numer=((2.d/3.d)*dln_q_approx)-dln_beta_prime
;numer=(((2.d/3.d)*dln_q_approx)-dln_beta_prime)
;
;denom=term33  ;2.*eta*(term33^(2./3.))*B[k-1]
;
;;print, dln_beta_prime,((numer/denom)^3)*1.e-6, nd_cld
;
;
;
;endif
;endif




    if finite(lidar_532_att_back_below[k]) eq 0 then lidar_532_att_back_below[k]=0.

;    lidar_532_att_back_below_no_snow_l[k]=1000.*(lidar_gas_back_532[k]+lidar_salt_back)*atten
;    lidar_532_att_back_below_no_snow_x[k]=1000.*((0.0284*lidar_gas_back_532[k]+(lidar_salt_back*sea_salt_depol)))*atten
;
;    lidar_532_att_back_no_salt=1000.*(lidar_liq_532_back_l[k]+lidar_snow_532_back_l[k]+lidar_gas_back_532[k])*atten
;    lidar_532_att_back_below_x_no_salt=1000.*(lidar_liq_532_back_x[k]+lidar_snow_532_back_x[k]+(0.0284*lidar_gas_back_532[k]))*atten
;
;    lidar_atten_back_below[j,k]=(lidar_532_att_back_below_l[k]+lidar_532_att_back_below_x[k])


  endfor
  
  if i_top[0]+2 ge n_elements(lidar_532_att_back_below) then i_top=n_elements(lidar_532_att_back_below)-5
  if i_base[0] le 0 then i_base[0]=0
  if i_top[0]+2 ge n_elements(lidar_532_att_back_below)-1 then return
  if i_base[0] ge n_elements(lidar_532_att_back_below)-1 then return
  if i_base[0] lt 0 then return
  if i_base[0] gt i_top[0] then return
  extinction_via_slope, extinction, eta, lidar_532_att_back_below[i_base[0]:i_top[0]+2],$
    height[i_base[0]:i_top[0]+2]/1000., extinction_sdv, eff_depth, num_to_max, num_to_atten
    
    ; find the mean of the extinction above the attenuated backscatter
    extinction=mean(ext_cld[where(ext_cld gt 0.)]*1.e5)

  gamma_m=double(moist_adiabatic_lapse_rate(temp[i_base[0]], 1., press[i_base[0]]*100.))/1000.d   ; k/m
  cw=((press[i_base[0]]*100.)/(rd*temp[i_base[0]]))*(cp/lv)*((g/cp)-gamma_m)  ; condensation rate from Grosvenor et al, 2018 equation 14. kg/m3/m
  gamma_l=cw
  depth_to_max=(num_to_max)*(height[2]-height[1])
  
  const=(1./(ext_cld[i_base+num_to_max]*100.))-(2.*eta*sc[i_base+num_to_max]*depth_to_max)

  
  ;nd_per=nd_zm_fad((depth_to_max), fad, 0.8, gamma_l)  ; replace fad[j] with 1.
  best_diff=1.e12
  for k=-2,2 do begin
  nd_per_eta=nd_zm_fad_eta(depth_to_max[0]+(float(k)*(height[2]-height[1])), fad, 0.8, gamma_l, eta)  ;
   if abs(nd_cld-nd_per_eta) lt best_diff then begin
    best_diff=abs(nd_cld-nd_per_eta)
    best_delta=k
    best_nd=nd_per_eta
   endif
  endfor
  
  zm=depth_to_max+(float(best_delta)*(height[2]-height[1]))
  if n_elements(best_nd) eq 0 then return
  nd_per_eta=best_nd

  ext_height_index=where(abs(extinction-(ext_cld[i_base[0]:i_top[0]+2]*1.e5)) eq min(abs(extinction-(ext_cld[i_base[0]:i_top[0]+2]*1.e5))))

  height_index=where(abs(extinction-(ext_cld[i_base[0]:i_top[0]+2]*1.e5)) eq min(abs(extinction-(ext_cld[i_base[0]:i_top[0]+2]*1.e5))))
  
;  ;;;;; run the new nd alg
  cloud_base_threshold=0.000025 ; 20180207
  base_index=min(where(lidar_532_att_back_below*1.e-3 gt cloud_base_threshold))
  max_index=where(lidar_532_att_back_below eq max(lidar_532_att_back_below))
  mean_depth_to_max=height[max_index[0]]-height[base_index[0]]
  nd_per_ln=nd_dlnbeta_calc(0.,(mean_depth_to_max)+(mean_depth_to_max*z_ln_cor),fad, eta, gamma_l*1000.,1.)  ;nd_dlnbeta[j]
  
  ;;;;;; Wood's cloud top effective radius (See Eqn 7 of his unpublished 2006 whitepaper)
  B=0.0620  ; units of m/kg^1/3
  gamma_eff=gamma_l*fad ; units of kg/m3/m
  nd_eff=0.8*nd_cld*1.e6 ; units of per cubic meter
  h=height[cld_top_index[0]]-height[cld_base_index[0]]  ; m


  ;if nd_per[count_per] gt 10. and nd_per[count_per] lt 200. then stop

  re_top=(1.e6)*B*(gamma_eff^(1./3.))*(nd_eff^(-1./3.))*(h^(1./3.)) ; units microns



;;;;;; get a log-linear fit for the vertical region just below the maximum in attenuated backscatter
;cbh=height[i_base[0]]
;dlnbeta_dz_fit_submaxz, lidar_532_att_back_below[i_base[0]:i_top[0]+2]/1000.,$
;  height[i_base[0]:i_top[0]+2],cbh,slope, y_intercept, chisq, yfit_copol, sig_values, i_max, i_down
;  
;;;;;;; what is the mean value of the heights used in the dln(beta)/dz fit?  Use this height in calculation of Nd
;vert_index=i_base[0]+fix((float(i_max)+float(i_down))/2.)
;
;;;;; use a value where the fitted attenuated backscatter is greater than 5.e-2 per km per steradian as cloud base - determined using synthetic data and obs
;; determine the height where that occurs
;cbh_fit=(alog(5.e-5)-y_intercept)/slope

;dlnbeta_dz_fit_submaxz, beta_b,z_in,slope, y_intercept, chsqr, yfit_copol, sig_values

  
  tau_cld=max(tau_accum_below_liq)
  if tau_cld gt 0. and plot_flag ge 1000 then begin  ; plot the profile

    set_plot, 'Z'
    loadct, 5 & gamma_ct, 1.0 & set_plot, 'Z' & device, set_resolution=[3000,2000] & !p.charsize=3. & !p.font=-1
    !p.background=!d.n_colors-1
    top_top_y=0.93 & dy=0.1 & top_y=0.95 & bot_y=top_y-dy & sep_y=0.05
    sx=0.12 & sy=0.06 & xl=0.1 & xr=0.9 & yt=0.95 & yb=0.1
    !p.thick=3. & numplots_x=3 & numplots_y=3
    position_plots,xl,xr,yb,yt,sx,sy,numplots_x,numplots_y,pos
    cbpos=pos & cbpos[*,0]=cbpos[*,2]+0.08 & cbpos[*,2]=cbpos[*,0]+0.012
    !p.multi=[0,4,4]

    pnum=8

    plot, lidar_gas_back_532[i_base[0]:i_top[0]+2]*1.e5,height[i_base[0]:i_top[0]+2]/1000., $
      color=0,xtitle='lidar_gas_back_532 (1/m/sr)',ytitle='Height (km)',$
      thick=3, charsize=3.5, charthick=2, xthick=3, ythick=-3, psym=2, title=' 532 nm molecular backscatter coeff', $
      xrange=[1.e-4,1.e-2], /xlog, position=pos[pnum,*], xstyle=1, symsize=1, yrange=[height[i_base[0]]/1000.,height[i_top[0]+2]/1000.]


    pnum=7

    plot, lidar_gas_ext_532[i_base[0]:i_top[0]+2],height[i_base[0]:i_top[0]+2]/1000., $
      color=0,xtitle='lidar_gas_ext_532',ytitle='Height (km)',$
      thick=3, charsize=3.5, charthick=2, xthick=3, ythick=-3, psym=2, title=' 532 nm molecular extinction (1/m)', $
      xrange=[1.e-8,1.e-6], /xlog, position=pos[pnum,*], xstyle=1, symsize=1, yrange=[height[i_base[0]]/1000.,height[i_top[0]+2]/1000.]

    pnum=6

    plot, lidar_liq_532_back[i_base[0]:i_top[0]+2]*1000.,height[i_base[0]:i_top[0]+2]/1000., $
      color=0,xtitle='liquid lidar backscatter (1/km/sr)',ytitle='Height (km)',$
      thick=3, charsize=3.5, charthick=2, xthick=3, ythick=-3, psym=2, title=' liquid lidar backscatter (1/km/sr), extinction (1/km red)', $
      xrange=[0.01,max(ext_cld[i_base[0]:i_top[0]+2]*1.e5)], /xlog, position=pos[pnum,*], xstyle=1, symsize=1, yrange=[height[i_base[0]]/1000.,height[i_top[0]+2]/1000.]

    oplot, ext_cld[i_base[0]:i_top[0]+2]*1.e5,height[i_base[0]:i_top[0]+2]/1000., color=150, psym=2, symsize=1
    
    
    ;oplot, [extinction],height[i_base+height_index]/1000., color=50, psym=5, symsize=1


    pnum=5

    plot, lwc_cld[i_base[0]:i_top[0]+2]*1.e6,height[i_base[0]:i_top[0]+2]/1000., $
      color=0,xtitle='liq water content (g/m3)',ytitle='Height (km)',$
      thick=3, charsize=3.5, charthick=2, xthick=3, ythick=-3, psym=2, title=' liquid water content', $
      xrange=[0.01,10.], /xlog, position=pos[pnum,*], xstyle=1, symsize=1, yrange=[height[i_base[0]]/1000.,height[i_top[0]+2]/1000.]

    pnum=4
    
    plot, re_cld[i_base[0]:i_top[0]+2]*10000.,height[i_base[0]:i_top[0]+2]/1000., $
      color=0,xtitle='effect radius (um)',ytitle='Height (km)',$
      thick=3, charsize=3.5, charthick=2, xthick=3, ythick=-3, psym=2, title=' cloud effective radius (microns)', $
      xrange=[0,30.], position=pos[pnum,*], xstyle=1, symsize=1, yrange=[height[i_base[0]]/1000.,height[i_top[0]+2]/1000.]

    oplot, [re_top,re_top],[height[i_top[0]],height[i_top[0]]], psym=2, color=50

    pnum=3

    plot, tau_accum_below_liq[i_base[0]:i_top[0]+2], height[i_base[0]:i_top[0]+2]/1000.,$
      color=0,xtitle='Visible Optical Depth',ytitle='Height (km)',$
      thick=3, charsize=3.5, charthick=2, xthick=3, ythick=-3, psym=2, title=' tau profile', $
      xrange=[0.,20.], position=pos[pnum,*], xstyle=1, symsize=1, yrange=[height[i_base[0]]/1000.,height[i_top[0]+2]/1000.]
      
      ;oplot, [tau_accum_below_liq[i_base[0]+ext_height_index[0]]],[height[i_base[0]+ext_height_index[0]]/1000.], psym=2, symsize=3., color=50

    pnum=2

    plot, lidar_532_att_back_below[i_base[0]:i_top[0]+2],height[i_base[0]:i_top[0]+2]/1000., $
      color=0,xtitle='Surface-Based Atten Back (1/km/sr)',ytitle='Height (km)',$
      thick=3, charsize=3.5, charthick=2, xthick=3, ythick=-3, psym=1, title=' atten backscatter', $
      xrange=[1.e-4,10.e1], /xlog, position=pos[pnum,*], xstyle=1, symsize=1, yrange=[height[i_base[0]]/1000.,height[i_top[0]+2]/1000.]
      
      ;oplot, [lidar_532_att_back_below[i_base[0]+ext_height_index[0]]],[height[i_base[0]+ext_height_index[0]]/1000.], psym=2, symsize=3., color=50



    lwp_string=strtrim(string(lwp_cld, format='(f6.2)'), 2)
    tau_cld_string=strtrim(string(tau_cld, format='(f6.2)'), 2)
    nd_cld_string=strtrim(string(nd_cld, format='(f6.2)'),2)
    nd_zm_string=strtrim(string(nd_per_eta, format='(f6.2)'),2)+' z_m: '+strtrim(string(depth_to_max[0], format='(i2)'),2)
    ext_string=strtrim(string(extinction, format='(f6.2)'),2)
    tau_string=strtrim(string(tau_accum_below_liq[i_base[0]+ext_height_index[0]], format='(f6.2)'),2)
    nd_ln_string=strtrim(string(nd_per_ln, format='(f6.2)'),2)+' z_m: '+strtrim(string(mean_depth_to_max, format='(i2)'),2)
    eta_string=strtrim(string(eta, format='(f6.3)'),2)+' fad: '+strtrim(string(fad, format='(f6.3)'),2)


    xyouts, 0.05,0.1, 'cld LWP: '+lwp_string, color=0, /normal, charsize=3., charthick=3
    xyouts, 0.05,0.14, 'cld tau: '+tau_cld_string, color=0, /normal, charsize=3., charthick=3
    xyouts, 0.05,0.16, 'nd_cld: '+nd_cld_string, color=0, /normal, charsize=3., charthick=3
    xyouts, 0.05,0.18, 'nd_zm: '+nd_zm_string, color=0, /normal, charsize=3., charthick=3
    xyouts, 0.05,0.22, 'nd_ln: '+nd_zm_string, color=0, /normal, charsize=3., charthick=3
    xyouts, 0.05,0.24, 'eta: '+eta_string, color=0, /normal, charsize=3., charthick=3
    xyouts, 0.05,0.26, domain_name, color=0, /normal, charsize=3., charthick=3

    

;    xyouts, 0.05,0.22, 'derived extinction: '+ext_string, color=0, /normal, charsize=3., charthick=3
;    xyouts, 0.05,0.20, 'derived extinction at tau: '+tau_string, color=0, /normal, charsize=3., charthick=3




    fname=file_path+domain_name+'_lidar_nd_eta_ext.gif'


    write_gif, fname, tvrd()
    plot_flag=0
    endif
    
   plot_flag=plot_flag+1

    tau_at_extinction=tau_accum_below_liq[i_base[0]+ext_height_index[0]]
    
    return
    end
