function clipLabEnds(labs,opt)

% CLIPLABENDS(LABS,OPT)
% CLIPLABENDS takes the current axes' tick labels, specified using LABS as
% either 'XTickLabels' or 'YTickLabels', and "clips" the lowest value
% (OPT='low'), the highest value (OPT='high'), or both (OPT='both'). This
% is useful when plotting tight subplots with the function
% 'tight_suplot.m'.

% ---------------------------------
% Kyle E. Fitch, Maj, USAF (AFIT/CI)
% University of Utah
% Salt Lake City, Utah
% kyle.fitch@us.af.mil
% ---------------------------------

% Dependencies:
% None

myyticklabs = get(gca,labs);

if strcmp(opt,'both')
    myyticklabs{1} = '';
    myyticklabs{end} = '';
    set(gca,labs,myyticklabs)
elseif strcmp(opt,'low')
    myyticklabs{1} = '';
    set(gca,labs,myyticklabs)
elseif strcmp(opt,'high')
    myyticklabs{end} = '';
    set(gca,labs,myyticklabs)
end
    