function slope = calcSlope(N,XLOC,color,LineWidth)

% SLOPE = CALCSLOPE(N,XLOC,COLOR,LINEWIDTH)
% CALC_SLOPE calculates the slope of the distribution tail on log-lin axes
% by performing a least squares linear regression fit to bin counts N and 
% bin centers XLOC from histogram output. The color of the linear fit is 
% specified with COLOR and line width with LINEWIDTH.

% ---------------------------------
% Kyle E. Fitch, Maj, USAF (AFIT/CI)
% University of Utah
% Salt Lake City, Utah
% kyle.fitch@us.af.mil
% ---------------------------------

% Dependencies:
% None

% find the location of the peak
MAXLOC = find(max(N)==N);

% the tail follows the peak in increasing XLOC direction
Ntail = N(MAXLOC:end);
Xtail = XLOC(MAXLOC:end);

% linear fit to the tail
ptail = polyfit(Xtail,log(Ntail),1);
slope = -ptail(1);

% log-linear prediction based on fit
Ytail = exp(ptail(2)).*exp(-slope.*Xtail);

% plot it
plot(Xtail,Ytail,[color,'-.'],'LineWidth',LineWidth);