function Re2 = calcRe2(dmax,dmin,theta,v,p,T)

% RE2 = CALCRE2(DMAX,DMIN,THETA,V,P,T)
% CALCRE2 calculates the Reynolds number of a hydrometeor from the input
% maximum dimension (DMAX, mm), minimum dimension (DMIN, mm), particle 
% fall orientation (THETA, deg), particle fall speed (V, m/s), pressure 
% (P, Pa), and temperature (T, K). Uses expressions from Bohm 
% (1989), primarily Eqn. (10).

% ---------------------------------
% Kyle E. Fitch, Maj, USAF (AFIT/CI)
% University of Utah
% Salt Lake City, Utah
% kyle.fitch@us.af.mil
% ---------------------------------

% Dependencies:
% None

% Constants
T0 = 273.15; % (K)
Rd = 287.058; % dry air gas constant (J kg^-1 K^-1)
eta0 = 1.74e-5; % dynamic viscosity at 0 degC (N s m^-2) 
mm2m = 1e-3; % convert mm to m

% Air density
airdens = p./(Rd.*T); % air density (kg m^-3)

% Dynamic viscosity
dynvisc = eta0.*sqrt(T./T0); % dynamic viscosity (N s m^-2)

% Correct Dmax and De based on orientation
Dmax_star = dmin + (dmax-dmin).*cosd(theta); % (mm)

% Reynolds number calculation
Re2 = ((airdens.*v.*Dmax_star)./dynvisc).*mm2m; % (unitless)
