function [slope,yint,yfit,yhi,ylo,gof] = calcLinFit(myx,myy)

% [SLOPE,YINT,YFIT,YHI,YLO,GOF] = CALCLINFIT(MYX,MYY)
% CALCLINFIT takes in x data MYX and y data MYY and performs a linear fit
% while providing lots of valuable, detailed output in a fashion I prefer.

% ---------------------------------
% Kyle E. Fitch, Maj, USAF (AFIT/CI)
% University of Utah
% Salt Lake City, Utah
% kyle.fitch@us.af.mil
% ---------------------------------

% Dependencies:
% None

% Fit:
[xData, yData] = prepareCurveData(myx,myy);
% Set up fittype and options.
ft = fittype('poly1');
% Fit model to data.
[fitresult, gof] = fit(xData,yData,ft);
ci = confint(fitresult,0.95);
slope = fitresult.p1;
yint = fitresult.p2;

yfit = slope.*xData + yint;
ylo = ci(1,1).*xData + ci(1,2);
yhi = ci(2,1).*xData + ci(2,2);