function maximum = isMyMax(xloc,N,low,high)

% MAX = ISMYMAX(XLOC,N,LOW,HIGH)
% Given a distribution (XLOC,N), this function finds the maximum within
% the specified range bounded by LOW and HIGH

% ---------------------------------
% Kyle E. Fitch, Maj, USAF (AFIT/CI)
% University of Utah
% Salt Lake City, Utah
% kyle.fitch@us.af.mil
% ---------------------------------

% Dependencies:
% None

% assumes bimodal dist. is between low and high (usually 0 and 2)
xrange = find(xloc < high & xloc > low);

% interpolate for better resolution
xq = linspace(xloc(xrange(1)),xloc(xrange(end)),1e5);
Nq = interp1(xloc,N,xq,'spline');

maximum = xq(Nq==max(Nq)); % locate local maximum

