/*************************************************************************
 * cycle through Orchestra binary file and print out 
 * time 
 * a = semimajor axis
 * (x, y, z) and (vx, vy, vz)
 * ecc and incl of orbit
**************************************************************************/
/* organization of data array
 * 0 = total mass in grams (m)
 * 1 = mass in gas 
 * 2 = mass * rho where rho is mass density in grams**2 / cm**3
 * 3 = radius in cm
 * 4 = luminosity
 * 5 = semimajor axis = a
 * 6, 7, 8 = x, y, z
 * 9, 10, 11 = vx, vy, vz
 * 12 = da/dt or a
 * 13 = ecc
 * 14 = incl
 * 15 = dm/dt or m
*/

/* usage

  it is useful to run "summary filename" first to learn how many
  timesteps are in the file

  gcc -lm extr6d.c -o extr6d
  extr6d filename n1 n2

  n1 is maximum index to print out
  n2 step size 

  example: extr6d pcs1-0011a 750 10 
  will step through 750 indices of file pcs1-0011a and print out info for 
  0th step (output in pcs1-0011a.0)
  every 10th step (output in psc1-0011a.10, psc1-0011a.20, etc)
  last step (output in pcs1-0011a.751)

  important to make sure that n1 step exists in input file (output of "summary" code)

*/

#include <stdio.h>
#include <stdarg.h>
#include <math.h>
#include <time.h>
#include <signal.h>
#include <unistd.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>

int F_GetLine(char *line, int max, FILE *fp);

int main(int argc, char *argv[])
{
  FILE *fp;
  FILE *ft;
  char f1[20], f2[20];
  char line[120];
  int  TIMEIDX, STEP;
  int  i, index, na, nb, nc, nd1, nd2, nt, nw;
  int  iprt;
  int  j;
  int  len;
  int  nzone[100000], nbin[100000];
  double time=0.,time0=-1.;
  double data[1000000];
  double yr=3.1556926e7;
  double rearth = 6.3781e8;
  double apc = 3.072*rearth;
  double frac=0., integer, now=0.;

  STEP = 10;
  if (argc <= 3) {
     printf("Usage: %s BINFILE TIMEIDX STEP\n\n",*argv);
     printf("Executable of summary.c gives info about BINFILE \n");
     printf("including a time index for each record.\n");
     printf("This code writes a file BINFILE.### for\n");
     printf("each record that has index <= TIMEIDX.\n");
     printf("stepping through records with step = STEP.\n");
     printf("The output filenames have extensions 0,1,2, ...\n");
     exit(0);
  } else {
/* open file */
     printf("#Using INPUT FILE: %s\n", *++argv);
     strcpy(f2, *argv); 
     if ((fp = fopen(*argv, "rb")) == NULL) {
        printf("Can't open file %s\n", *argv);
	exit(1);
     } else {
        printf("input timeindex is %s\n", *++argv);
        TIMEIDX = atoi(*argv) ;
        printf("input step is %s\n", *++argv);
        STEP = atoi(*argv) ;
        for (i = 0; i <= TIMEIDX; i++) {
/*    Frac = modf( (((double) GL_TimeIndex) / ((double) STEP)), &Integer); */
           now = ((double) i) / ((double) STEP) ;
           frac = modf( now, &integer) ;
           if (frac == 0. || i == TIMEIDX) {
              iprt = 0 ;
              sprintf(f1, "%s.%d", f2, i) ; 
	      ft = fopen(f1,"w") ;
              printf("opening file %s for output...\n",f1);
              fprintf(ft, "#timeindex %d for file %s\n", i, f2);
              fprintf(ft, "#time:  %e sec %e yr\n", time, time/yr);
	   } else {
             iprt = -1 ;
           }
           nc = 0;
           nd1 = 0;
           nd2 = 0;
           nt = 0;
           nw = 0;
           len = F_GetLine(line, sizeof(line), fp);
           if (len <= 1) {
              exit(1);
           } else {
	      sscanf(line, "%le %d %d %d %d %d%n", &time, &index, &nb, &nd1, &nt, &nd2, &nc);
	      if (nd1 > 0) {
	         nw = fread((char*)nzone,sizeof(int),nb,fp);
	         nw = fread((char*)nbin,sizeof(int),nb,fp);
	         nw = fread((char*)data,sizeof(double),nd1,fp);
                 na = 0;
                 for (j = 0; j < nd1; j+=16) {
                    if (data[j] > 0.)
                       na +=1 ;
                 }
                 if (iprt == 0) {
	            fprintf(ft, "# number of n-bodies: %d\n", na);
                    fprintf(ft, "#SemiMajorAxis          X                Y                Z              XDOT              YDOT             ZDOT               ECC             INCL\n");
                    for (j = 0; j < nd1; j+=16) {
                       if (data[j] > 0.)
                          fprintf(ft, "%15.10e %15.10e %15.10e %15.10e %15.10e %15.10e %15.10e %15.10e %15.10e\n", data[j+5], data[j+6], data[j+7], data[j+8], data[j+9], data[j+10], data[j+11], data[j+13], data[j+14]);
                    }
	            fprintf(ft, "# number of tracers: %d\n", nt);
                    fprintf(ft, "#SemiMajorAxis          X                Y                Z              XDOT              YDOT             ZDOT               ECC             INCL\n");
                 }
	         if (nt > 0) {
	            nw = fread((char*)nzone,sizeof(int),nt,fp);
	            nw = fread((char*)nbin,sizeof(int),nt,fp);
	            nw = fread((char*)data,sizeof(double),nd2,fp);
                    for (j = 0; j < nw; j+=16) {
                       if (iprt == 0) {
                          fprintf(ft, "%15.10e %15.10e %15.10e %15.10e %15.10e %15.10e %15.10e %15.10e %15.10e\n", data[j+5], data[j+6], data[j+7], data[j+8], data[j+9], data[j+10], data[j+11], data[j+13], data[j+14]);
                       }
                    }
                 }
	      } else {
	         exit(1);
	      }
	   }
           if (iprt == 0)
              fclose(ft) ;
        }
     }
  }
  fclose(fp);
  return(0);
}
/* F_GetLine
   Input:  string ptr, line length, file ptr
   Output: string
   Used to read lines from an input parameter file.
*/   
int F_GetLine(char *line, int max, FILE *fp)
{    
  if (fgets(line, max, fp) == NULL) 
    return 0;
  else   
    return strlen(line);
} /* end F_GetLine */
